/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.upgrade;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.plugins.mail.handlers.CVSLogHandler;
import com.atlassian.jira.plugins.mail.handlers.CreateIssueHandler;
import com.atlassian.jira.plugins.mail.handlers.CreateOrCommentHandler;
import com.atlassian.jira.plugins.mail.handlers.FullCommentHandler;
import com.atlassian.jira.plugins.mail.handlers.NonQuotedCommentHandler;
import com.atlassian.jira.plugins.mail.handlers.RegexCommentHandler;
import com.atlassian.jira.plugins.mail.model.HandlerDetailsModel;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.google.common.collect.ImmutableList;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_2_SwitchToUserKeys
implements PluginUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_2_SwitchToUserKeys.class);
    private static final String ENTITY_NAME = "ServiceConfig";
    private static final String SERVICE_CONFIG_NAME = "name";
    private static final String SERVICE_CONFIG_CLAZZ = "clazz";
    public static final List<String> handlers = ImmutableList.of((Object)CreateOrCommentHandler.class.getName(), (Object)CreateIssueHandler.class.getName(), (Object)CVSLogHandler.class.getName(), (Object)FullCommentHandler.class.getName(), (Object)NonQuotedCommentHandler.class.getName(), (Object)RegexCommentHandler.class.getName(), (Object)"com.atlassian.studio.jira.service.util.handler.StudioEmailHandler");
    private final ServiceManager serviceManager;
    private final OfBizDelegator genericDelegator;
    private final UserKeyService userKeyService;

    public UpgradeTask_2_SwitchToUserKeys(ServiceManager serviceManager, OfBizDelegator delegator, UserKeyService userKeyService) {
        this.serviceManager = serviceManager;
        this.genericDelegator = delegator;
        this.userKeyService = userKeyService;
    }

    public int getBuildNumber() {
        return 2;
    }

    public String getShortDescription() {
        return "Updates existing services that use user names to use user keys.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Message> doUpgrade() throws Exception {
        boolean refreshNeeded = false;
        List serviceConfigGVs = this.genericDelegator.findAll(ENTITY_NAME);
        try {
            for (GenericValue configGV : serviceConfigGVs) {
                Object serviceName = configGV.get(SERVICE_CONFIG_NAME);
                PropertySet ps = OFBizPropertyUtils.getPropertySet((GenericValue)configGV);
                if (ps == null || !ps.exists("handler") || ps.getType("handler") != 5) continue;
                String handler = ps.getString("handler");
                String params = ps.getString("handler.params");
                if (!handlers.contains(handler) || params == null || !params.contains("reporterusername")) continue;
                HandlerDetailsModel details = new HandlerDetailsModel();
                details.fromServiceParams(params);
                String reporterUsername = details.getReporterusername();
                String reporterUserKey = StringUtils.defaultString((String)this.userKeyService.getKeyForUsername(reporterUsername), (String)IdentifierUtils.toLowerCase((String)reporterUsername));
                log.info((Object)String.format("Upgrading service '%s' - replacing user name %s with user key %s", serviceName, reporterUsername, reporterUserKey));
                ps.setString("handler.params", ServiceUtils.toParameterString(details.toServiceParams()));
                configGV.store();
                refreshNeeded = true;
            }
        }
        finally {
            if (refreshNeeded) {
                this.serviceManager.refreshAll();
            }
        }
        return Collections.emptyList();
    }

    public String getPluginKey() {
        return "com.atlassian.jira.jira-mail-plugin";
    }
}

