/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.upgrade;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.plugins.mail.handlers.CVSLogHandler;
import com.atlassian.jira.plugins.mail.handlers.CreateIssueHandler;
import com.atlassian.jira.plugins.mail.handlers.CreateOrCommentHandler;
import com.atlassian.jira.plugins.mail.handlers.FullCommentHandler;
import com.atlassian.jira.plugins.mail.handlers.NonQuotedCommentHandler;
import com.atlassian.jira.plugins.mail.handlers.RegexCommentHandler;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.service.services.mail.MailFetcherService;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_1_MoveMailHandlers
implements PluginUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_1_MoveMailHandlers.class);
    private static final String ENTITY_NAME = "ServiceConfig";
    private static final String SERVICE_CONFIG_NAME = "name";
    private static final String SERVICE_CONFIG_CLAZZ = "clazz";
    public static final Map<String, String> handlerTranslation = ImmutableMap.builder().put((Object)"com.atlassian.jira.service.util.handler.CreateOrCommentHandler", (Object)CreateOrCommentHandler.class.getName()).put((Object)"com.atlassian.jira.service.util.handler.CreateIssueHandler", (Object)CreateIssueHandler.class.getName()).put((Object)"com.atlassian.jira.service.util.handler.CVSLogHandler", (Object)CVSLogHandler.class.getName()).put((Object)"com.atlassian.jira.service.util.handler.FullCommentHandler", (Object)FullCommentHandler.class.getName()).put((Object)"com.atlassian.jira.service.util.handler.NonQuotedCommentHandler", (Object)NonQuotedCommentHandler.class.getName()).put((Object)"com.atlassian.jira.service.util.handler.RegexCommentHandler", (Object)RegexCommentHandler.class.getName()).build();
    private static final Set<String> obsoleteServices = ImmutableSet.of((Object)"com.atlassian.jira.service.services.imap.ImapService", (Object)"com.atlassian.jira.service.services.pop.PopService");
    private final ServiceManager serviceManager;
    private final OfBizDelegator genericDelegator;

    public UpgradeTask_1_MoveMailHandlers(ServiceManager serviceManager, OfBizDelegator delegator) {
        this.serviceManager = serviceManager;
        this.genericDelegator = delegator;
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return "Updates existing services that use the old mail handlers to use the ones from the plugin.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Message> doUpgrade() throws Exception {
        boolean refreshNeeded = false;
        List serivceConfigGVs = this.genericDelegator.findAll(ENTITY_NAME);
        try {
            for (GenericValue configGV : serivceConfigGVs) {
                String handler;
                PropertySet ps;
                String serviceClass = configGV.getString(SERVICE_CONFIG_CLAZZ);
                Object serviceName = configGV.get(SERVICE_CONFIG_NAME);
                if (obsoleteServices.contains(serviceClass)) {
                    log.info((Object)String.format("Upgrading service '%s' - fixing service to %s", serviceName, MailFetcherService.class.getName()));
                    configGV.setString(SERVICE_CONFIG_CLAZZ, MailFetcherService.class.getName());
                    configGV.store();
                    refreshNeeded = true;
                }
                if ((ps = OFBizPropertyUtils.getPropertySet((GenericValue)configGV)) == null || !ps.exists("handler") || ps.getType("handler") != 5 || !handlerTranslation.containsKey(handler = ps.getString("handler"))) continue;
                String newHandler = handlerTranslation.get(handler);
                log.info((Object)String.format("Upgrading service '%s' - fixing mail handler to %s", serviceName, newHandler));
                ps.setString("handler", newHandler);
                configGV.store();
                refreshNeeded = true;
            }
        }
        finally {
            if (refreshNeeded) {
                this.serviceManager.refreshAll();
            }
        }
        return Collections.emptyList();
    }

    public String getPluginKey() {
        return "com.atlassian.jira.jira-mail-plugin";
    }
}

