/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.model;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.service.util.ServiceUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class HandlerDetailsModel {
    private String projectKey;
    private String issueTypeId;
    private boolean stripquotes;
    private String reporterusername;
    private String catchemail;
    private String bulk;
    private String forwardEmail;
    private boolean createusers;
    private boolean notifyusers;
    private boolean ccwatcher;
    private boolean ccassignee = true;
    private String splitregex;

    public HandlerDetailsModel() {
    }

    public HandlerDetailsModel(@Nullable String projectKey, @Nullable String issueTypeId, boolean stripquotes, @Nullable String reporterusername, @Nullable String catchemail, @Nullable String bulk, @Nullable String forwardEmail, boolean createusers, boolean notifyusers, boolean ccwatcher, boolean ccassignee, @Nullable String splitregex) {
        this.projectKey = projectKey;
        this.issueTypeId = issueTypeId;
        this.stripquotes = stripquotes;
        this.reporterusername = reporterusername;
        this.catchemail = catchemail;
        this.bulk = bulk;
        this.forwardEmail = forwardEmail;
        this.createusers = createusers;
        this.notifyusers = notifyusers;
        this.ccwatcher = ccwatcher;
        this.ccassignee = ccassignee;
        this.splitregex = splitregex;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueTypeId(String issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public boolean isStripquotes() {
        return this.stripquotes;
    }

    public void setStripquotes(boolean stipquotes) {
        this.stripquotes = stipquotes;
    }

    public String getReporterusername() {
        return this.reporterusername;
    }

    public void setReporterusername(String reporterusername) {
        this.reporterusername = reporterusername;
    }

    public String getCatchemail() {
        return this.catchemail;
    }

    public void setCatchemail(String catchemail) {
        this.catchemail = catchemail;
    }

    public String getBulk() {
        return this.bulk;
    }

    public void setBulk(String bulk) {
        this.bulk = bulk;
    }

    public String getForwardEmail() {
        return this.forwardEmail;
    }

    public void setForwardEmail(String forwardEmail) {
        this.forwardEmail = forwardEmail;
    }

    public boolean isCreateusers() {
        return this.createusers;
    }

    public void setCreateusers(boolean createusers) {
        this.createusers = createusers;
    }

    public boolean isNotifyusers() {
        return this.notifyusers;
    }

    public void setNotifyusers(boolean notifyusers) {
        this.notifyusers = notifyusers;
    }

    public boolean isCcwatcher() {
        return this.ccwatcher;
    }

    public void setCcwatcher(boolean ccwatcher) {
        this.ccwatcher = ccwatcher;
    }

    public boolean isCcassignee() {
        return this.ccassignee;
    }

    public void setCcassignee(boolean ccassignee) {
        this.ccassignee = ccassignee;
    }

    public String getSplitregex() {
        return this.splitregex;
    }

    public void setSplitregex(String splitregex) {
        this.splitregex = splitregex;
    }

    public Map<String, String> toServiceParams() {
        LinkedHashMap res = Maps.newLinkedHashMap();
        if (StringUtils.isNotBlank((String)this.projectKey)) {
            res.put("project", this.projectKey);
        }
        if (StringUtils.isNotBlank((String)this.issueTypeId)) {
            res.put("issuetype", this.issueTypeId);
        }
        if (StringUtils.isNotBlank((String)this.reporterusername)) {
            res.put("reporteruserkey", this.getKeyForUsername(this.reporterusername));
        }
        if (StringUtils.isNotBlank((String)this.catchemail)) {
            res.put("catchemail", this.catchemail);
        }
        if (StringUtils.isNotBlank((String)this.bulk)) {
            res.put("bulk", this.bulk);
        }
        if (StringUtils.isNotBlank((String)this.splitregex)) {
            res.put("splitregex", this.splitregex);
        }
        res.put("createusers", String.valueOf(this.createusers));
        res.put("notifyusers", String.valueOf(this.notifyusers));
        res.put("ccwatcher", String.valueOf(this.ccwatcher));
        res.put("ccassignee", String.valueOf(this.ccassignee));
        res.put("stripquotes", String.valueOf(this.stripquotes));
        return res;
    }

    @Nullable
    protected String getKeyForUsername(@Nullable String reporterusername) {
        return ComponentAccessor.getUserKeyService().getKeyForUsername(reporterusername);
    }

    public void fromServiceParams(@Nullable String property) {
        Map params = ServiceUtils.getParameterMap((String)StringUtils.defaultString((String)property, (String)""));
        HashSet allowedFields = Sets.newHashSet((Object[])new String[]{"stripquotes", "reporterusername", "reporteruserkey", "catchemail", "bulk", "createusers", "notifyusers", "ccwatcher", "ccassignee", "splitregex"});
        if (params != null) {
            String project;
            for (Map.Entry param : params.entrySet()) {
                if (!StringUtils.isNotBlank((String)((String)param.getValue())) || !allowedFields.contains(param.getKey()) || !StringUtils.isNotBlank((String)((String)param.getKey()))) continue;
                try {
                    BeanUtils.copyProperty((Object)this, (String)((String)param.getKey()), param.getValue());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            String reporterUserKey = (String)params.get("reporteruserkey");
            if (StringUtils.isNotBlank((String)reporterUserKey)) {
                this.reporterusername = this.getUsernameForKey(reporterUserKey);
            }
            if (StringUtils.isNotBlank((String)(project = (String)params.get("project")))) {
                this.setProjectKey(project.toUpperCase(Locale.getDefault()));
            }
            if (params.containsKey("issuetype")) {
                this.setIssueTypeId((String)params.get("issuetype"));
            }
        }
    }

    @Nullable
    private String getUsernameForKey(@Nullable String reporteruserkey) {
        return ComponentAccessor.getUserKeyService().getUsernameForKey(reporteruserkey);
    }
}

