/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.internal;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.plugins.mail.extensions.MessageHandlerModuleDescriptor;
import com.atlassian.jira.plugins.mail.upgrade.UpgradeTask_1_MoveMailHandlers;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.classloader.PluginsClassLoader;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class DefaultMessageHandlerFactory
implements MessageHandlerFactory {
    private final ComponentClassManager componentClassManager;
    private final PluginAccessor pluginAccessor;
    private final Logger log;

    public DefaultMessageHandlerFactory(MailLoggingManager mailLoggingManager, PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        this.componentClassManager = ComponentAccessor.getComponentClassManager();
        this.log = mailLoggingManager.getIncomingMailChildLogger(DefaultMessageHandlerFactory.class.getSimpleName());
    }

    protected boolean isStudio() {
        return ((FeatureManager)ComponentAccessor.getComponent(FeatureManager.class)).isEnabled(CoreFeatures.ON_DEMAND);
    }

    public MessageHandler getHandler(final String clazz) {
        if (UpgradeTask_1_MoveMailHandlers.handlerTranslation.containsKey(clazz)) {
            this.log.error((Object)("Not instantiating the obsolete class [" + clazz + "]. Please ignore this message during restore from a backup or JIRA upgrade, the service configuration should be upgraded later during the process."));
            this.log.error((Object)"If you are still seeing this after JIRA has been fully upgraded please reconfigure your mail handling services using the Incoming Mail Servers screen.");
            return null;
        }
        try {
            Iterable corespondingDescriptors = Iterables.filter((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(MessageHandlerModuleDescriptor.class), (Predicate)new Predicate<MessageHandlerModuleDescriptor>(){

                public boolean apply(@Nullable MessageHandlerModuleDescriptor descriptor) {
                    return descriptor != null && descriptor.getMessageHandler().getName().equals(clazz);
                }
            });
            Iterator iterator = corespondingDescriptors.iterator();
            if (!iterator.hasNext()) {
                this.log.error((Object)("Handler '" + clazz + "' cannot be instantiated because there is no corresponding enabled module defining message-handler of such class"));
                return null;
            }
            MessageHandlerModuleDescriptor descriptor = (MessageHandlerModuleDescriptor)((Object)iterator.next());
            Class messageHandlerClass = descriptor.getPlugin().loadClass(clazz, this.getClass());
            Object handler = this.componentClassManager.newInstanceFromPlugin(messageHandlerClass, descriptor.getPlugin());
            if (handler == null) {
                this.log.error((Object)("Could not instantiate message handler with class: " + clazz + ": null returned."));
                return null;
            }
            if (!MessageHandler.class.isInstance(handler)) {
                this.log.error((Object)("Cannot instantiate message handler of requested class '" + clazz + "'. Expected " + "an instance of '" + MessageHandler.class.getName() + "' class, but found '" + handler.getClass().getName() + "'."));
                return null;
            }
            return (MessageHandler)handler;
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)("Message handler class [" + clazz + "] not found. Please make sure the plugin providing this class is enabled or reconfigure your mail handling services using the Incoming Mail Servers screen."), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)("Could not instantiate message handler with class: " + clazz), (Throwable)e);
        }
        return null;
    }

    @Nullable
    public String getCorrespondingModuleDescriptorKey(final String clazz) {
        Plugin pluginForClass = ((PluginsClassLoader)ComponentAccessor.getPluginAccessor().getClassLoader()).getPluginForClass(clazz);
        if (pluginForClass == null) {
            return null;
        }
        try {
            return ((MessageHandlerModuleDescriptor)((Object)Iterables.find((Iterable)Iterables.filter((Iterable)pluginForClass.getModuleDescriptors(), MessageHandlerModuleDescriptor.class), (Predicate)new Predicate<MessageHandlerModuleDescriptor>(){

                public boolean apply(@Nullable MessageHandlerModuleDescriptor input) {
                    return input != null && clazz.equals(input.getMessageHandler().getName());
                }
            }))).getCompleteKey();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

