/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.internal;

import com.atlassian.jira.plugins.mail.internal.MailLoopDetectionService;
import com.atlassian.mail.MailUtils;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.base.Function;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultMailLoopDetectionService
implements MailLoopDetectionService {
    static final String FLAG_FETCHED = "fetched";
    public static final int DISABLED_VALUE = 0;
    private static final Logger log = Logger.getLogger(DefaultMailLoopDetectionService.class);
    public static final String SETTINGS_THRESHOLD_KEY = "com.atlassian.plugins.mail:mail-threshold";
    public static final String SETTINGS_IGNORED_SUFFIXES_KEY = "com.atlassian.plugins.mail:ignored-suffixes";
    private static final int timeLimitInSeconds = 900;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final Cache<String, AtomicInteger> cache;

    @Autowired
    public DefaultMailLoopDetectionService(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(900L, TimeUnit.SECONDS).build((CacheLoader)new MailCacheLoader());
    }

    DefaultMailLoopDetectionService(Ticker cacheTicker, PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(900L, TimeUnit.SECONDS).ticker(cacheTicker).build((CacheLoader)new MailCacheLoader());
    }

    @Override
    public boolean isPotentialMessageLoop(Message message) {
        List senders;
        Integer threshold = this.getCurrentThreshold();
        if (threshold == 0) {
            return false;
        }
        boolean isAlreadyChecked = false;
        try {
            isAlreadyChecked = message.getFlags().contains(FLAG_FETCHED);
            Flags flags = new Flags(FLAG_FETCHED);
            message.setFlags(flags, true);
        }
        catch (MessagingException e) {
            log.error((Object)"Unable to set flags", (Throwable)e);
        }
        try {
            senders = MailUtils.getSenders((Message)message);
        }
        catch (MessagingException e) {
            log.error((Object)"Cannot fetch senders from the mail message", (Throwable)e);
            return false;
        }
        boolean isThresholdReached = false;
        for (String sender : senders) {
            log.trace((Object)String.format("Checking sender: '%s'", sender));
            if (this.isAddressIgnored(sender)) {
                log.debug((Object)String.format("Address '%s' is on ignored list, skipping", sender));
                continue;
            }
            int counter = isAlreadyChecked ? ((AtomicInteger)this.cache.getUnchecked((Object)sender)).get() : ((AtomicInteger)this.cache.getUnchecked((Object)sender)).getAndIncrement();
            if (counter < threshold) continue;
            log.debug((Object)String.format("Address %s sent already %s messages within configured timeframe which indicates potential mail loop", sender, counter));
            isThresholdReached = true;
        }
        return isThresholdReached;
    }

    private boolean isAddressIgnored(String sender) {
        if (sender == null) {
            return false;
        }
        for (String ignoredSuffix : this.getIgnoredSuffixes()) {
            if (!sender.endsWith(ignoredSuffix)) continue;
            return true;
        }
        return false;
    }

    public int getCurrentThreshold() {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        Object value = settings.get(SETTINGS_THRESHOLD_KEY);
        if (value == null) {
            return 0;
        }
        return Integer.parseInt((String)value);
    }

    public void setCurrentThreshold(int threshold) {
        if (threshold < 0) {
            throw new IllegalArgumentException("Threshold value should not be negative");
        }
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        settings.put(SETTINGS_THRESHOLD_KEY, (Object)Integer.toString(threshold));
    }

    public List<String> getIgnoredSuffixes() {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        Object value = settings.get(SETTINGS_IGNORED_SUFFIXES_KEY);
        if (value == null) {
            return Collections.emptyList();
        }
        return (List)value;
    }

    public void setIgnoredSuffixes(List<String> suffixes) {
        ImmutableList santitisedDomains = ImmutableList.copyOf((Iterable)Iterables.transform(suffixes, (Function)new Function<String, String>(){

            public String apply(@Nullable String input) {
                return StringUtils.trim((String)input);
            }
        }));
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        settings.put(SETTINGS_IGNORED_SUFFIXES_KEY, (Object)santitisedDomains);
    }

    public int getTimeLimitInSeconds() {
        return 900;
    }

    private static class MailCacheLoader
    extends CacheLoader<String, AtomicInteger> {
        private MailCacheLoader() {
        }

        public AtomicInteger load(String key) throws Exception {
            return new AtomicInteger(0);
        }
    }
}

