/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.mail.handlers;

import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.mail.MessagingException;
import javax.mail.Part;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class GeneratedAttachmentRecogniser {
    public static final String IMAGE_FORMAT = "javax_imageio_png_1.0";
    private final boolean isJiraGeneratedAttachment;
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_ID = "Content-ID";
    private final String JIRA_SYSTEM_IMAGE_TYPE = "jira-system-image-type";

    public GeneratedAttachmentRecogniser(Part part) {
        this.isJiraGeneratedAttachment = this.containsJiraHeader(part) || this.containsJiraMetadata(part);
    }

    private boolean isPng(Part part) {
        String[] contentTypeHeaders;
        for (String contentTypeHeader : contentTypeHeaders = this.tryAndGetHeader(part, CONTENT_TYPE)) {
            if (!StringUtils.startsWithIgnoreCase((String)contentTypeHeader, (String)"image/png")) continue;
            return true;
        }
        return false;
    }

    public boolean isJiraGeneratedAttachment() {
        return this.isJiraGeneratedAttachment;
    }

    private boolean containsJiraMetadata(Part part) {
        if (!this.isPng(part)) {
            return false;
        }
        ImageReader imageReader = ImageIO.getImageReadersByFormatName("png").next();
        try {
            imageReader.setInput(ImageIO.createImageInputStream(part.getInputStream()));
            Node metadataTree = imageReader.getImageMetadata(0).getAsTree(IMAGE_FORMAT);
            if (metadataTree == null) {
                return false;
            }
            NodeList metadataNodes = metadataTree.getChildNodes();
            for (int i1 = 0; i1 < metadataNodes.getLength(); ++i1) {
                Node item = metadataNodes.item(i1);
                if (item == null || !"tEXt".equals(item.getNodeName())) continue;
                NodeList entries = item.getChildNodes();
                for (int i2 = 0; i2 < entries.getLength(); ++i2) {
                    Node keyword;
                    NamedNodeMap attributes;
                    Node entry = entries.item(i2);
                    if (entry == null || !"tEXtEntry".equals(entry.getNodeName()) || (attributes = entry.getAttributes()) == null || (keyword = attributes.getNamedItem("keyword")) == null || !"jira-system-image-type".equals(keyword.getNodeValue())) continue;
                    return true;
                }
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        catch (MessagingException e) {
            return false;
        }
        return false;
    }

    private boolean containsJiraHeader(Part part) {
        String[] headers;
        for (String header : headers = this.tryAndGetHeader(part, CONTENT_ID)) {
            if (!header.startsWith("<jira-generated-image-")) continue;
            return true;
        }
        return false;
    }

    private String[] tryAndGetHeader(Part part, String name) {
        try {
            String[] header = part.getHeader(name);
            return header == null ? new String[]{} : header;
        }
        catch (MessagingException e) {
            return new String[0];
        }
    }
}

