/*
 * Copyright (C) 2002-2011 Atlassian
 * All rights reserved.
 */
package com.atlassian.jira.plugins.mail.webwork;

import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.Sets;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;

public class AddSmtpMailServer extends AddMailServer
{

    public static Map<String, String> getSupportedServiceProviders(I18nHelper i18nHelper)
    {
        return MapBuilder.<String, String>newBuilder()
            .add("custom", i18nHelper.getText("admin.mailservers.custom"))
            .add("gmail-smtp", "Google Apps Mail / Gmail")
            .add("yahooplus-smtp", "Yahoo! Mail Plus")
            .toLinkedHashMap();
    }

    private final NotificationSchemeManager notificationSchemeManager;
    private Collection<Project> projects;

    public AddSmtpMailServer(NotificationSchemeManager notificationSchemeManager)
    {
        this.notificationSchemeManager = notificationSchemeManager;
    }

    @Override
    public String doDefault() throws Exception
    {
        projects = Sets.newTreeSet(new Comparator<Project>()
        {
            @Override
            public int compare(Project p1, Project p2)
            {
                return p1.getName().compareToIgnoreCase(p2.getName());
            }
        });

        for (Scheme scheme : notificationSchemeManager.getSchemeObjects())
        {
            projects.addAll(notificationSchemeManager.getProjects(scheme));
        }

        return super.doDefault();
    }

    public Collection<Project> getProjects()
    {
        return projects;
    }

    @Override
    public Map<String, String> getSupportedServiceProviders()
    {
        return getSupportedServiceProviders(this);
    }

    @Override
    public String getActiveTab()
    {
        return ViewMailServers.OUTGOING_MAIL_TAB;
    }

    @Override
    public String getCancelURI()
    {
        return ViewMailServers.OUTGOING_MAIL_ACTION;
    }
}
