package com.atlassian.jira.plugins.mail.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;

import com.atlassian.jira.mail.settings.MailSettings;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.websudo.WebSudoRequired;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON;
import static javax.ws.rs.core.Response.Status.FORBIDDEN;

/**
 * Outgoing mail resource.
 *
 * @since 6.1
 */
@WebSudoRequired
@Path("outgoingMail")
@Consumes(APPLICATION_JSON)
public class OutgoingMailResource
{
    private static final Logger log = LoggerFactory.getLogger(OutgoingMailResource.class);
    private final MailSettings.Send outgoingMailSetting;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;

    public OutgoingMailResource(MailSettings outgoingMailSetting, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext)
    {
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
        this.outgoingMailSetting = outgoingMailSetting.send();
    }

    @PUT
    @Path("config")
    public void setConfig(OutgoingMailConfig config)
    {
        log.debug("Received outgoing mail configuration", config);
        ApplicationUser user = authenticationContext.getUser();
        boolean isAdmin = permissionManager.hasPermission(Permissions.ADMINISTER, user);
        boolean isSysadmin = permissionManager.hasPermission(Permissions.SYSTEM_ADMIN, user);
        if (!isAdmin && !isSysadmin)
        {
            throw new WebApplicationException(FORBIDDEN);
        }

        if (config.enabled)
        {
            outgoingMailSetting.enable();
        }
        else
        {
            outgoingMailSetting.disable();
        }
    }
}
