package com.atlassian.jira.plugins.mail.model;

import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;

import java.util.Arrays;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Represents errors object in a JSON format
 *
 * Lightweight version of com.atlassian.jira.rest.api.util.ErrorCollection from jira-rest
 */
@XmlRootElement
public class ErrorModel
{
    /**
     * Generic error messages
     */
    @XmlElement
    private Collection<String> errorMessages = Lists.newArrayList();

    /**
     * Adds the given error messages to this error collection.
     *
     * @param messages a collection of Strings containing error messages
     * @return this
     */
    public ErrorModel addErrorMessages(Collection<String> messages)
    {
        errorMessages.addAll(Assertions.notNull(messages));
        return this;
    }

    /**
     * Returns a new ErrorModel containing a list of error messages.
     *
     * @param messages an Iterable of Strings containing error messages
     * @return a new ErrorModel
     */
    public static ErrorModel of(Collection<String> messages)
    {
        return new ErrorModel().addErrorMessages(messages);
    }

    /**
     * Returns a new ErrorModel containing a list of error messages.
     *
     * @param messages an array of Strings containing error messages
     * @return a new ErrorModel
     */
    public static ErrorModel of(String... messages)
    {
        return of(Arrays.asList(messages));
    }
}
