package com.atlassian.jira.plugins.mail.internal;

import javax.mail.Message;

/**
 * Service which is used for heuristic analyze of the mail messages used to detection of mail loops
 *
 * @since v6.1.18-1
 */
public interface MailLoopDetectionService
{

    /**
     * Checks for potential mail loop in given {@link Message}. This method may register some data regarding message in
     * order to be able to detect possible mail loops
     * @param message message to test against
     * @return true wheter there is a potential of message being a part of message loop
     */
    boolean isPotentialMessageLoop(Message message);

}
