package com.atlassian.jira.plugins.mail.internal;

import com.atlassian.jira.plugins.mail.extensions.ParamsFormatter;
import com.atlassian.jira.plugins.mail.handlers.AbstractMessageHandler;
import com.atlassian.jira.plugins.mail.webwork.EditHandlerDetailsWebAction;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.lang.Pair;
import org.apache.commons.lang.StringUtils;

import java.util.Map;

/**
 *
 * @since v5.2.23
 */
public class DefaultParamsFormatter implements ParamsFormatter {

	protected final JiraAuthenticationContext authenticationContext;
	protected final UserKeyService userKeyService;

	public DefaultParamsFormatter(JiraAuthenticationContext authenticationContext, UserKeyService userKeyService) {
		this.authenticationContext = authenticationContext;
		this.userKeyService = userKeyService;
	}

	@Override
	public Pair<String,String> formatParam(final String key, final String value) {
		if (key == null || key.equals("project") || key.equals("issuetype")) {
			return null;
		}

		final I18nHelper i18n = authenticationContext.getI18nHelper();
		final Map<String, String> defaults = EditHandlerDetailsWebAction.getFieldLabels();

		if (key.equals(AbstractMessageHandler.KEY_REPORTER_KEY)) {
			return Pair.of(i18n.getText(defaults.get(AbstractMessageHandler.KEY_REPORTER)), formattedUserNameForKey(value));
		}

		return Pair.of(StringUtils.defaultString(i18n.getText(defaults.get(key)), key), value);
	}

    private String formattedUserNameForKey(final String userKeyValue)
    {
        if (userKeyValue == null)
        {
            return "Unknown User";
        }

        final String userName = userKeyService.getUsernameForKey(userKeyValue);

        return userName != null ? userName : userKeyValue;
    }

}
