/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence.service;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.plugin.link.confluence.ConfluenceGlobalId;
import com.atlassian.jira.plugin.link.confluence.service.ConfluenceGlobalIdFactory;
import com.atlassian.jira.plugin.viewissue.issuelink.GlobalIdFactory;
import com.atlassian.jira.util.UriMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;

public class ConfluenceGlobalIdFactoryImpl
implements ConfluenceGlobalIdFactory {
    private static final String APP_ID_KEY = "appId";
    private static final String PAGE_ID_KEY = "pageId";
    private static final List<String> KEYS = ImmutableList.of((Object)"appId", (Object)"pageId");
    private final ApplicationLinkService applicationLinkService;

    public ConfluenceGlobalIdFactoryImpl(ApplicationLinkService applicationLinkService) {
        this.applicationLinkService = applicationLinkService;
    }

    public static String encode(ApplicationId applicationId, String pageId) {
        ImmutableMap values = ImmutableMap.of((Object)APP_ID_KEY, (Object)applicationId.get(), (Object)PAGE_ID_KEY, (Object)pageId);
        return GlobalIdFactory.encode(KEYS, (Map)values);
    }

    @Override
    public ConfluenceGlobalId create(RemoteIssueLink link) {
        Map values = GlobalIdFactory.decode((String)link.getGlobalId(), KEYS);
        String appId = (String)values.get(APP_ID_KEY);
        ApplicationLink appLink = this.getApplicationLink(appId, link.getUrl());
        if (appLink == null) {
            throw new IllegalArgumentException("No Application Link found for the given Application Id: " + appId + " or URL: " + link.getUrl());
        }
        String pageId = (String)values.get(PAGE_ID_KEY);
        return new ConfluenceGlobalId(appLink, pageId);
    }

    private ApplicationLink getApplicationLink(String appId, String url) {
        URI uri;
        ApplicationLink urlLink = null;
        int matchLength = -1;
        try {
            uri = url != null ? new URI(url) : null;
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        for (ApplicationLink appLink : this.applicationLinkService.getApplicationLinks(ConfluenceApplicationType.class)) {
            int length;
            if (appLink.getId().get().equals(appId)) {
                return appLink;
            }
            if (uri == null || !UriMatcher.isBaseEqual((URI)appLink.getDisplayUrl(), (URI)uri) || (length = appLink.getDisplayUrl().getPath().length()) <= matchLength) continue;
            urlLink = appLink;
            matchLength = length;
        }
        return urlLink;
    }
}

