/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence.rest;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.link.applinks.RemoteResponse;
import com.atlassian.jira.plugin.link.confluence.ConfluenceSearchResult;
import com.atlassian.jira.plugin.link.confluence.ConfluenceSpace;
import com.atlassian.jira.plugin.link.confluence.rest.ConfluenceApplicationLinksBean;
import com.atlassian.jira.plugin.link.confluence.rest.ConfluenceSearchResponseBean;
import com.atlassian.jira.plugin.link.confluence.rest.ConfluenceSpaceResponseBean;
import com.atlassian.jira.plugin.link.confluence.service.rpc.ConfluenceRpcService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BaseUrlSwapper;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="confluence")
public class ConfluenceResource {
    private final ConfluenceRpcService confluenceRpcService;
    private final ApplicationLinkService applicationLinkService;
    private final I18nHelper.BeanFactory beanFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public ConfluenceResource(ConfluenceRpcService confluenceRpcService, ApplicationLinkService applicationLinkService, I18nHelper.BeanFactory beanFactory, JiraAuthenticationContext jiraAuthenticationContext) {
        this.confluenceRpcService = confluenceRpcService;
        this.applicationLinkService = applicationLinkService;
        this.beanFactory = beanFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @GET
    @Path(value="/space")
    @Produces(value={"application/json"})
    public Response getSpaces(@QueryParam(value="appId") String appId) {
        I18nHelper i18n = this.getI18n(this.jiraAuthenticationContext.getLoggedInUser());
        ApplicationLink appLink = this.getConfluenceAppLink(appId);
        if (appLink == null) {
            ErrorCollection errors = ErrorCollection.of((String[])new String[]{i18n.getText("addconfluencelink.search.applink.not.found")});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).cacheControl(CacheControl.never()).build();
        }
        try {
            RemoteResponse<List<ConfluenceSpace>> response = this.confluenceRpcService.getSpaces(appLink);
            if (!response.isSuccessful()) {
                return this.handleUnsuccessfulResponse(response);
            }
            ConfluenceSpaceResponseBean bean = this.convertSpacesToBean((List)response.getEntity());
            return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
        }
        catch (CredentialsRequiredException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.never()).build();
        }
        catch (ResponseException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(CacheControl.never()).build();
        }
    }

    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response getSiteSearch(@QueryParam(value="query") String query, @QueryParam(value="appId") String appId, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="spaceKey") String spaceKey) {
        I18nHelper i18n = this.getI18n(this.jiraAuthenticationContext.getLoggedInUser());
        ApplicationLink appLink = this.getConfluenceAppLink(appId);
        if (appLink == null) {
            ErrorCollection errors = ErrorCollection.of((String[])new String[]{i18n.getText("addconfluencelink.search.applink.not.found")});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).cacheControl(CacheControl.never()).build();
        }
        try {
            RemoteResponse<List<ConfluenceSearchResult>> response = this.confluenceRpcService.search(appLink, query, maxResults, spaceKey);
            if (!response.isSuccessful()) {
                return this.handleUnsuccessfulResponse(response);
            }
            List<ConfluenceSearchResult> results = this.convertToDisplayUrl((List)response.getEntity(), appLink);
            ConfluenceSearchResponseBean bean = this.convertSearchResultsToBean(results);
            return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
        }
        catch (CredentialsRequiredException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.never()).build();
        }
        catch (ResponseException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(CacheControl.never()).build();
        }
    }

    @GET
    @Path(value="/applink")
    @Produces(value={"application/json"})
    public Response getApplicationLinks() {
        ConfluenceApplicationLinksBean bean = new ConfluenceApplicationLinksBean(this.getConfluenceAppLinks());
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    private ApplicationLink getConfluenceAppLink(String appId) {
        for (ApplicationLink appLink : this.getConfluenceAppLinks()) {
            if (!appLink.getId().get().equals(appId)) continue;
            return appLink;
        }
        return null;
    }

    private Iterable<ApplicationLink> getConfluenceAppLinks() {
        return this.applicationLinkService.getApplicationLinks(ConfluenceApplicationType.class);
    }

    private ConfluenceSpaceResponseBean convertSpacesToBean(List<ConfluenceSpace> spaces) {
        if (spaces == null) {
            return new ConfluenceSpaceResponseBean(Collections.<ConfluenceSpaceResponseBean.Space>emptyList());
        }
        ArrayList<ConfluenceSpaceResponseBean.Space> spaceBeans = new ArrayList<ConfluenceSpaceResponseBean.Space>(spaces.size());
        for (ConfluenceSpace space : spaces) {
            spaceBeans.add(new ConfluenceSpaceResponseBean.Space(space.getKey(), space.getName(), space.getType(), space.getUrl()));
        }
        return new ConfluenceSpaceResponseBean(spaceBeans);
    }

    private ConfluenceSearchResponseBean convertSearchResultsToBean(List<ConfluenceSearchResult> searchResults) {
        if (searchResults == null) {
            return new ConfluenceSearchResponseBean(Collections.<ConfluenceSearchResponseBean.Result>emptyList());
        }
        ArrayList<ConfluenceSearchResponseBean.Result> results = new ArrayList<ConfluenceSearchResponseBean.Result>(searchResults.size());
        for (ConfluenceSearchResult result : searchResults) {
            results.add(new ConfluenceSearchResponseBean.Result(result.getId(), result.getType(), result.getTitle(), result.getExcerpt(), result.getUrl()));
        }
        return new ConfluenceSearchResponseBean(results);
    }

    private List<ConfluenceSearchResult> convertToDisplayUrl(List<ConfluenceSearchResult> results, final ApplicationLink appLink) {
        return Lists.transform(results, (Function)new Function<ConfluenceSearchResult, ConfluenceSearchResult>(){

            public ConfluenceSearchResult apply(@Nullable ConfluenceSearchResult from) {
                return new ConfluenceSearchResult.ConfluenceSearchResultBuilder(from).url(BaseUrlSwapper.swapRpcUrlToDisplayUrl((String)from.getUrl(), (ApplicationLink)appLink)).build();
            }
        });
    }

    private Response handleUnsuccessfulResponse(RemoteResponse<?> response) {
        ErrorCollection errors = ErrorCollection.of((String[])new String[]{response.getStatusText()});
        if (response.hasErrors()) {
            errors.addErrorCollection(response.getErrors());
        }
        return Response.status((int)response.getStatusCode()).entity((Object)errors).cacheControl(CacheControl.never()).build();
    }

    private I18nHelper getI18n(User user) {
        return this.beanFactory.getInstance(user);
    }
}

