/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence.render;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.plugin.link.confluence.service.ConfluenceGlobalIdFactory;
import com.atlassian.jira.plugin.link.confluence.service.ConfluenceIssueLinkDecoratingService;
import com.atlassian.jira.plugin.viewissue.issuelink.DefaultIssueLinkRenderer;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceIssueLinkRenderer
extends DefaultIssueLinkRenderer {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceIssueLinkRenderer.class);
    private final ConfluenceIssueLinkDecoratingService confluenceIssueLinkDecoratingService;
    private final ConfluenceGlobalIdFactory confluenceGlobalIdFactory;

    public ConfluenceIssueLinkRenderer(ConfluenceIssueLinkDecoratingService confluenceIssueLinkDecoratingService, ConfluenceGlobalIdFactory confluenceGlobalIdFactory) {
        this.confluenceIssueLinkDecoratingService = confluenceIssueLinkDecoratingService;
        this.confluenceGlobalIdFactory = confluenceGlobalIdFactory;
    }

    public Map<String, Object> getFinalContext(RemoteIssueLink remoteIssueLink, Map<String, Object> context) {
        HashMap finalContext = Maps.newHashMap();
        try {
            remoteIssueLink = this.confluenceIssueLinkDecoratingService.decorate(remoteIssueLink);
        }
        catch (CredentialsRequiredException exception) {
            URI authorisationURI = exception.getAuthorisationURI();
            I18nHelper i18n = (I18nHelper)context.get("i18n");
            if (authorisationURI == null) {
                finalContext.put("noApplinkAuthConfigured", Boolean.TRUE);
            } else {
                ApplicationLink applicationLink = this.confluenceGlobalIdFactory.create(remoteIssueLink).getApplicationLink();
                String applicationName = StringUtils.defaultIfEmpty((String)applicationLink.getName(), (String)i18n.getText("viewissue.links.types.confluencepage"));
                finalContext.put("authenticationRequired", Boolean.TRUE);
                finalContext.put("authenticationUrl", exception.getAuthorisationURI());
                finalContext.put("applicationName", applicationName);
                finalContext.put("appLinkId", applicationLink.getId());
                finalContext.put("applicationUrl", applicationLink.getDisplayUrl());
                remoteIssueLink = new RemoteIssueLinkBuilder(remoteIssueLink).applicationName(applicationName).build();
            }
        }
        catch (PermissionException e) {
            I18nHelper i18n = (I18nHelper)context.get("i18n");
            ApplicationLink applicationLink = this.confluenceGlobalIdFactory.create(remoteIssueLink).getApplicationLink();
            String applicationName = StringUtils.defaultIfEmpty((String)applicationLink.getName(), (String)i18n.getText("viewissue.links.types.confluencepage"));
            finalContext.put("permissionDenied", Boolean.TRUE);
            finalContext.put("applicationName", applicationName);
            finalContext.put("applicationUrl", applicationLink.getDisplayUrl());
            remoteIssueLink = new RemoteIssueLinkBuilder(remoteIssueLink).applicationName(applicationName).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (StringUtils.isBlank((String)remoteIssueLink.getIconTitle())) {
            remoteIssueLink = new RemoteIssueLinkBuilder(remoteIssueLink).iconTitle("Page").build();
        }
        if (StringUtils.isBlank((String)remoteIssueLink.getRelationship())) {
            remoteIssueLink = new RemoteIssueLinkBuilder(remoteIssueLink).relationship("mentioned in").build();
        }
        finalContext.putAll(super.getInitialContext(remoteIssueLink, context));
        if (log.isDebugEnabled()) {
            log.debug("ConfluenceIssueLinkRenderer: finalContext: " + finalContext);
        }
        return finalContext;
    }

    public boolean requiresAsyncLoading(RemoteIssueLink remoteIssueLink) {
        return true;
    }
}

