/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.confluence;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.link.RemoteIssueLinkService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.plugin.link.applinks.RemoteResponse;
import com.atlassian.jira.plugin.link.confluence.service.ConfluenceGlobalIdFactoryImpl;
import com.atlassian.jira.plugin.link.confluence.service.ConfluencePageService;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.UriMatcher;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.web.action.issue.AbstractIssueLinkAction;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class LinkConfluencePage
extends AbstractIssueLinkAction {
    private static final String TITLE = "Wiki Page";
    private static final String RELATIONSHIP = "Wiki Page";
    private String pageUrl;
    private ApplicationLink appLink;
    private Collection<ApplicationLink> confluenceAppLinks;
    private final ApplicationLinkService applicationLinkService;
    private final ConfluencePageService confluencePageService;

    public LinkConfluencePage(SubTaskManager subTaskManager, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, ProjectRoleManager projectRoleManager, CommentService commentService, UserUtil userUtil, RemoteIssueLinkService remoteIssueLinkService, EventPublisher eventPublisher, ApplicationLinkService applicationLinkService, ConfluencePageService confluencePageService) {
        super(subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil, remoteIssueLinkService, eventPublisher);
        this.applicationLinkService = applicationLinkService;
        this.confluencePageService = confluencePageService;
    }

    public boolean isValidToView() {
        return super.isValidToView() && !this.getConfluenceAppLinks().isEmpty();
    }

    protected void doValidation() {
        super.doValidation();
        this.appLink = this.validatePageUrl(this.pageUrl);
        String pageId = null;
        if (!this.hasAnyErrors()) {
            pageId = this.getPageId(this.pageUrl, this.appLink);
        }
        if (!this.hasAnyErrors() && pageId == null) {
            this.addErrorMessage(this.getText("addconfluencelink.error.pageid.notfound"));
        }
        if (!this.hasAnyErrors()) {
            String globalId = ConfluenceGlobalIdFactoryImpl.encode(this.appLink.getId(), pageId);
            RemoteIssueLink remoteIssueLink = new RemoteIssueLinkBuilder().issueId(this.getIssue().getLong("id")).url(LinkConfluencePage.buildPageUrl(this.appLink, pageId)).title("Wiki Page").globalId(globalId).relationship("Wiki Page").applicationType(RemoteIssueLink.APPLICATION_TYPE_CONFLUENCE).applicationName(this.appLink.getName()).build();
            this.validationResult = this.remoteIssueLinkService.validateCreate(this.getLoggedInUser(), remoteIssueLink);
            if (!this.validationResult.isValid()) {
                this.mapErrors(this.validationResult.getErrorCollection());
                this.addErrorCollection(this.validationResult.getErrorCollection());
            }
        }
    }

    private static String buildPageUrl(ApplicationLink appLink, String pageId) {
        return new UrlBuilder(appLink.getDisplayUrl().toASCIIString()).addPathUnsafe("pages/viewpage.action").addParameter("pageId", pageId).asUrlString();
    }

    private void mapErrors(ErrorCollection errorCollection) {
        for (Map.Entry entry : errorCollection.getErrors().entrySet()) {
            if ("globalId".equals(entry.getKey())) {
                errorCollection.addErrorMessage(this.getText("addconfluencelink.error.duplicate"));
                continue;
            }
            errorCollection.addErrorMessage((String)entry.getValue());
        }
    }

    private ApplicationLink validatePageUrl(String pageUrl) {
        URI pageUri;
        if (StringUtils.isBlank((String)pageUrl)) {
            this.addError("pageUrl", this.getText("addconfluencelink.error.url.required"));
            return null;
        }
        try {
            pageUri = new URI(pageUrl);
        }
        catch (URISyntaxException e) {
            this.addError("pageUrl", this.getText("addconfluencelink.error.url.invalid"));
            return null;
        }
        ApplicationLink appLink = this.getAppLink(pageUri);
        if (appLink == null) {
            this.addErrorMessage(this.getText("addconfluencelink.error.no.matching.app.link", "<a href='#' class='confluence-search-trigger'>", "</a>"));
        }
        return appLink;
    }

    private ApplicationLink getAppLink(URI pageUri) {
        for (ApplicationLink appLink : this.getConfluenceAppLinks()) {
            if (!UriMatcher.isBaseEqual((URI)appLink.getDisplayUrl(), (URI)pageUri)) continue;
            return appLink;
        }
        return null;
    }

    private String getPageId(String pageUrl, ApplicationLink appLink) {
        try {
            RemoteResponse<String> response = this.confluencePageService.getPageId(appLink, pageUrl);
            if (response.isSuccessful()) {
                return (String)response.getEntity();
            }
            switch (response.getStatusCode()) {
                case 403: {
                    this.addErrorMessage(this.getText("addconfluencelink.error.page.forbidden"));
                    break;
                }
                case 401: {
                    this.handleCredentialsRequired();
                    break;
                }
                default: {
                    this.addErrorMessage(this.getText("addconfluencelink.error.pageid.notfound"));
                    this.log.error((Object)("Invalid response from getting the pageId: " + response.getStatusCode() + ": " + response.getStatusText()));
                    break;
                }
            }
        }
        catch (CredentialsRequiredException e) {
            this.handleCredentialsRequired();
        }
        catch (ResponseException e) {
            this.addErrorMessage(this.getText("addconfluencelink.error.pageid.notfound"));
            this.log.error((Object)("Invalid response from getting the pageId: " + e.getMessage()));
        }
        return null;
    }

    public String doDefault() throws Exception {
        this.pageUrl = "http://";
        return super.doDefault();
    }

    @RequiresXsrfCheck
    protected String doExecute() {
        RemoteIssueLinkService.RemoteIssueLinkResult result = this.createLink();
        if (!result.isValid()) {
            this.addErrorCollection(result.getErrorCollection());
            return "error";
        }
        this.createComment();
        return this.returnComplete(this.getRedirectUrl());
    }

    public String getPageUrl() {
        return this.pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public String getAppId() {
        if (this.appLink != null) {
            return this.appLink.getId().get();
        }
        return "";
    }

    @HtmlSafe
    public Collection<String> getFlushedErrorMessages() {
        return super.getFlushedErrorMessages();
    }

    public Collection<ApplicationLink> getConfluenceAppLinks() {
        if (this.confluenceAppLinks == null) {
            Iterable iterable = this.applicationLinkService.getApplicationLinks(ConfluenceApplicationType.class);
            this.confluenceAppLinks = ImmutableList.copyOf((Iterable)iterable);
        }
        return this.confluenceAppLinks;
    }
}

