/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav.legacy;

import com.atlassian.jira.plugin.headernav.legacy.ReadOnlyStudioTabManager;
import com.atlassian.jira.plugin.headernav.legacy.StudioTab;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Deprecated
@Component
public class DefaultReadOnlyStudioTabManager
implements ReadOnlyStudioTabManager {
    private static final String STUDIO_TABS_PREFIX = "studio.tabs.";
    private static final Logger log = LoggerFactory.getLogger(DefaultReadOnlyStudioTabManager.class);
    private final PluginSettingsFactory pluginSettingsFactory;

    @Autowired
    public DefaultReadOnlyStudioTabManager(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Override
    public List<StudioTab> getAllTabs(String projectKey) {
        List<StudioTab> studioTabs = this.collectTabs(this.getStudioTabSettings(projectKey));
        return studioTabs;
    }

    private StudioTab getTab(PluginSettings studioTabSettings, int position) {
        Object setting = studioTabSettings.get(Integer.toString(position));
        if (setting == null) {
            return null;
        }
        StudioTab studioTab = StudioTab.fromString(setting.toString());
        if (studioTab == null) {
            log.warn("Studio tabs seem corrupted. (" + position + ", " + setting + ").");
        }
        return studioTab;
    }

    private void visitStudioTabs(PluginSettings studioTabSettings, StudioTabsVisitor visitor) {
        StudioTab studioTab;
        int i = 0;
        while ((studioTab = this.getTab(studioTabSettings, i)) != null) {
            visitor.visit(studioTabSettings, i, studioTab);
            ++i;
        }
    }

    private PluginSettings getStudioTabSettings(String projectKey) {
        PluginSettings studioTabSettings;
        String studioTabsPrefix;
        if (projectKey == null) {
            studioTabsPrefix = STUDIO_TABS_PREFIX;
            studioTabSettings = this.pluginSettingsFactory.createGlobalSettings();
        } else if ("_default".equals(projectKey)) {
            studioTabSettings = this.pluginSettingsFactory.createGlobalSettings();
            studioTabsPrefix = "studio.tabs.default.";
        } else {
            PluginSettings ps;
            try {
                ps = this.pluginSettingsFactory.createSettingsForKey(projectKey);
            }
            catch (IllegalArgumentException iae) {
                ps = this.pluginSettingsFactory.createGlobalSettings();
            }
            studioTabSettings = ps;
            studioTabsPrefix = STUDIO_TABS_PREFIX;
        }
        return new PluginSettings(){

            public Object remove(String key) {
                return studioTabSettings.remove(studioTabsPrefix + key);
            }

            public Object put(String key, Object value) {
                return studioTabSettings.put(studioTabsPrefix + key, value);
            }

            public Object get(String key) {
                return studioTabSettings.get(studioTabsPrefix + key);
            }
        };
    }

    private List<StudioTab> collectTabs(PluginSettings studioTabSettings) {
        final ArrayList<StudioTab> studioTabs = new ArrayList<StudioTab>();
        this.visitStudioTabs(studioTabSettings, new StudioTabsVisitor(){

            @Override
            public void visit(PluginSettings studioTabSettings, int position, StudioTab studioTab) {
                studioTabs.add(position, studioTab);
            }
        });
        return studioTabs;
    }

    static interface StudioTabsVisitor {
        public void visit(PluginSettings var1, int var2, StudioTab var3);
    }
}

