/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav.customcontentlinks;

import com.atlassian.plugins.navlink.producer.contentlinks.customcontentlink.CustomContentLinkService;
import javax.annotation.Nonnull;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomContentLinkServiceFactory
implements InitializingBean,
DisposableBean {
    private ServiceTracker serviceTracker = null;
    @Nonnull
    private final BundleContext bundleContext;

    @Autowired
    public CustomContentLinkServiceFactory(@Nonnull BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void destroy() throws Exception {
        this.serviceTracker.close();
    }

    public void afterPropertiesSet() throws Exception {
        this.serviceTracker = new ServiceTracker(this.bundleContext, CustomContentLinkService.class.getName(), null);
        this.serviceTracker.open();
    }

    public CustomContentLinkService getCustomContentLinkService() {
        if (this.serviceTracker == null) {
            throw new IllegalStateException("Service Tracker not created yet");
        }
        return (CustomContentLinkService)this.serviceTracker.getService();
    }
}

