/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.contextproviders.AbstractJiraContextProvider;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CreateMenuContextProvider
extends AbstractJiraContextProvider {
    static final String CREATE_MENU_SECTION = "system.user.create.options/create-menu-section";
    static final String FIRST_CREATE_MENU_LINK_KEY = "createIssueLink";
    private final SimpleLinkManager simpleLinkManager;
    private final JiraAuthenticationContext authenticationContext;

    public CreateMenuContextProvider(@Nonnull SimpleLinkManager simpleLinkManager, @Nonnull JiraAuthenticationContext authenticationContext) {
        this.simpleLinkManager = (SimpleLinkManager)Assertions.notNull((Object)simpleLinkManager);
        this.authenticationContext = (JiraAuthenticationContext)Assertions.notNull((Object)authenticationContext);
    }

    public Map<String, Object> getContextMap(@Nullable User user, @Nullable JiraHelper jiraHelper) {
        SimpleLink firstCreateMenuLink = this.getFirstLinkForCreateMenuSection(jiraHelper);
        return MapBuilder.newBuilder((Object)FIRST_CREATE_MENU_LINK_KEY, (Object)firstCreateMenuLink).toHashMap();
    }

    @Nullable
    private SimpleLink getFirstLinkForCreateMenuSection(@Nullable JiraHelper helper) {
        User user = this.authenticationContext.getLoggedInUser();
        List linksForSection = this.simpleLinkManager.getLinksForSection(CREATE_MENU_SECTION, user, helper);
        if (linksForSection != null && !linksForSection.isEmpty()) {
            return (SimpleLink)linksForSection.get(0);
        }
        return null;
    }
}

