/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AdminMenuContextProvider
implements ContextProvider {
    static final String ADMIN_TOP_NAVIGATION_BAR_LOCATION = "system.admin.top.navigation.bar";
    static final String ADMIN_ONDEMAND_OVERRIDE_LOCATION = "system.admin.top.navigation.bar.od.override";
    static final String PROJECT_MENU_SECTION = "admin_project_menu/project_section";
    static final String CONTEXT_SECTIONS_KEY = "adminHeaderSections";
    static final String CONTEXT_SECTION_LINKS_KEY = "adminHeaderSectionsLinkMap";
    static final String CONTEXT_LINKS_KEY = "adminHeaderLinks";
    static final String CONTEXT_ROOT_ADMIN_MENU_KEY = "rootAdminMenuLink";
    private final SimpleLinkManager simpleLinkManager;
    private final JiraAuthenticationContext authenticationContext;

    public AdminMenuContextProvider(@Nonnull SimpleLinkManager simpleLinkManager, @Nonnull JiraAuthenticationContext authenticationContext) {
        this.simpleLinkManager = (SimpleLinkManager)Assertions.notNull((Object)simpleLinkManager);
        this.authenticationContext = (JiraAuthenticationContext)Assertions.notNull((Object)authenticationContext);
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        User user = this.authenticationContext.getLoggedInUser();
        JiraHelper helper = (JiraHelper)context.get("helper");
        List onDemandOverrideLinks = this.simpleLinkManager.getLinksForSection(ADMIN_ONDEMAND_OVERRIDE_LOCATION, user, helper);
        List links = this.simpleLinkManager.getLinksForSection(PROJECT_MENU_SECTION, user, helper);
        SimpleLink rootAdminMenuLink = null;
        if (!links.isEmpty()) {
            rootAdminMenuLink = (SimpleLink)links.get(0);
        }
        if (onDemandOverrideLinks != null && !onDemandOverrideLinks.isEmpty()) {
            List adminHeaderLinks = this.simpleLinkManager.getLinksForSection(ADMIN_TOP_NAVIGATION_BAR_LOCATION, user, helper);
            List onDemandOverrideSections = this.simpleLinkManager.getSectionsForLocation(ADMIN_ONDEMAND_OVERRIDE_LOCATION, user, helper);
            MapBuilder adminHeaderSectionLinkMap = MapBuilder.newBuilder();
            for (SimpleLinkSection onDemandOverrideSection : onDemandOverrideSections) {
                adminHeaderSectionLinkMap.add((Object)onDemandOverrideSection.getId(), Iterables.getFirst((Iterable)this.simpleLinkManager.getLinksForSection(onDemandOverrideSection.getId(), user, helper), null));
            }
            return MapBuilder.newBuilder(context).add((Object)CONTEXT_SECTIONS_KEY, (Object)onDemandOverrideSections).add((Object)CONTEXT_SECTION_LINKS_KEY, (Object)adminHeaderSectionLinkMap.toMutableMap()).add((Object)CONTEXT_LINKS_KEY, (Object)onDemandOverrideLinks).add((Object)CONTEXT_ROOT_ADMIN_MENU_KEY, (Object)rootAdminMenuLink).toHashMap();
        }
        List<SimpleLinkSection> adminHeaderSections = this.removeCurrentProjectLink(this.simpleLinkManager.getNotEmptySectionsForLocation(ADMIN_TOP_NAVIGATION_BAR_LOCATION, user, helper));
        Map<String, SimpleLink> adminHeaderSectionLinkMap = this.collectRelavantLinkOfEachAdminSection(adminHeaderSections, user, helper);
        List adminHeaderLinks = this.simpleLinkManager.getLinksForSection(ADMIN_TOP_NAVIGATION_BAR_LOCATION, user, helper);
        return MapBuilder.newBuilder(context).add((Object)CONTEXT_SECTIONS_KEY, adminHeaderSections).add((Object)CONTEXT_SECTION_LINKS_KEY, adminHeaderSectionLinkMap).add((Object)CONTEXT_LINKS_KEY, (Object)adminHeaderLinks).add((Object)CONTEXT_ROOT_ADMIN_MENU_KEY, (Object)rootAdminMenuLink).toHashMap();
    }

    private List<SimpleLinkSection> removeCurrentProjectLink(List<SimpleLinkSection> originalSectionLinks) {
        ArrayList<SimpleLinkSection> adminMenuListSections = new ArrayList<SimpleLinkSection>();
        for (SimpleLinkSection linkSection : originalSectionLinks) {
            if (linkSection.getId().equals("admin_project_current")) continue;
            adminMenuListSections.add(linkSection);
        }
        return adminMenuListSections;
    }

    @Nonnull
    private Map<String, SimpleLink> collectRelavantLinkOfEachAdminSection(@Nonnull List<SimpleLinkSection> adminHeaderSections, @Nullable User user, @Nonnull JiraHelper helper) {
        HashMap<String, SimpleLink> firstAdminHeaderSectionLinks = new HashMap<String, SimpleLink>();
        for (SimpleLinkSection adminHeaderSection : adminHeaderSections) {
            SimpleLink relavantLink = this.findFirstLinkForSubSection(adminHeaderSection, user, helper);
            if (relavantLink == null) {
                relavantLink = (SimpleLink)this.simpleLinkManager.getLinksForSection(adminHeaderSection.getId(), user, helper).get(0);
            }
            if (relavantLink == null) continue;
            firstAdminHeaderSectionLinks.put(adminHeaderSection.getId(), relavantLink);
        }
        return firstAdminHeaderSectionLinks;
    }

    @Nullable
    private SimpleLink findFirstLinkForSubSection(@Nonnull SimpleLinkSection adminHeaderSection, @Nullable User user, @Nonnull JiraHelper helper) {
        List nonEmptySubSections = this.simpleLinkManager.getNotEmptySectionsForLocation(adminHeaderSection.getId(), user, helper);
        for (SimpleLinkSection subSection : nonEmptySubSections) {
            if ("atl.jira.proj.config".equals(subSection.getId())) continue;
            String subSectionKey = adminHeaderSection.getId() + "/" + subSection.getId();
            List links = this.simpleLinkManager.getLinksForSection(subSectionKey, user, helper);
            if (!links.isEmpty()) {
                return (SimpleLink)links.get(0);
            }
            SimpleLink firstLinkOfSubSection = this.findFirstLinkForSubSection(subSection, user, helper);
            if (firstLinkOfSubSection == null) continue;
            return firstLinkOfSubSection;
        }
        return null;
    }
}

