/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.workflow.AbstractTestWorkflowMigration;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryItem;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryRecord;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebTable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestWorkflowMigrationEnterprise
extends AbstractTestWorkflowMigration {
    private static final String TEST_PROJECT_NAME = "Test Project";
    private static final String DESTINATION_WORKFLOW_SCHEME = "Destination Workflow Scheme";
    private static final String REOPENED_STATUS_NAME = "Reopened";
    private static final String WORFKLOW_HOMOSAPIEN_SOURCE_1 = "Homosapien Source 1";
    private static final String WORKFLOW_HOMOSPIEN_DESTINATION = "Homospien Destination";
    private static final String WORKFLOW_HOMOSAPIEN_SOURCE_2 = "Homosapien Source 2";
    private static final String WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_SOURCE = "Homosapien Custom Issue Type Source";
    private static final String WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_DESTINATION = "Homosapien Custom Issue Type Destination";
    private static final String SUMMARY_FIELD_ID = "Summary";
    private static final String TRANSITION_NAME_GO_CUSTOM = "Go Custom";
    private static final String ACKNOWLEDGE = "Acknowledge";
    private static final String DONE = "Done";

    public TestWorkflowMigrationEnterprise(String name) {
        super(name);
    }

    public void testWorkflowMigration() throws SAXException {
        this.restoreData("WorkflowMigrationTest.xml");
        HashMap<String, String> statusMapping = new HashMap<String, String>();
        statusMapping.put("mapping_1_1", "Custom Status 3");
        statusMapping.put("mapping_1_10001", "Custom Status 4");
        statusMapping.put("mapping_4_1", "Custom Status 3");
        statusMapping.put("mapping_4_3", "Resolved");
        statusMapping.put("mapping_4_6", "Custom Status 4");
        statusMapping.put("mapping_2_1", "Custom Status 3");
        statusMapping.put("mapping_2_3", "Resolved");
        statusMapping.put("mapping_2_6", "Custom Status 4");
        this.associateWorkFlowSchemeToProject(TEST_PROJECT_NAME, DESTINATION_WORKFLOW_SCHEME, statusMapping);
        this.waitForSuccessfulWorkflowSchemeMigration(TEST_PROJECT_NAME, DESTINATION_WORKFLOW_SCHEME);
        this.assertIssuesWorkflowState("TST-1", "Open", Arrays.asList("Start Progress", "Resolve Issue", "Close Issue"));
        this.assertLastChangeHistoryRecords("TST-1", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "jira")));
        this.assertIssuesWorkflowState("TST-2", "Open", Arrays.asList("Start Progress", "Resolve Issue", "Close Issue"));
        this.assertLastChangeHistoryRecords("TST-2", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "jira")));
        this.assertIssuesWorkflowState("TST-3", "Resolved", Arrays.asList("Go 4"));
        this.assertLastChangeHistoryRecords("TST-3", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "Destinatiom Workflow"), new ExpectedChangeHistoryItem("Status", "In Progress", "Resolved"))));
        this.assertIssuesWorkflowState("TST-4", "Custom Status 4", Arrays.asList("Go 3"));
        this.assertLastChangeHistoryRecords("TST-4", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 2", "Destinatiom Workflow"), new ExpectedChangeHistoryItem("Status", "Custom Status 2", "Custom Status 4"))));
        this.assertIssuesWorkflowState("TST-5", "Custom Status 3", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("TST-5", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 2", "Destinatiom Workflow"), new ExpectedChangeHistoryItem("Status", "Open", "Custom Status 3"))));
        this.assertIssuesWorkflowState("TST-6", "Custom Status 4", Arrays.asList("Go 3"));
        this.assertLastChangeHistoryRecords("TST-6", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 2", "Destinatiom Workflow"), new ExpectedChangeHistoryItem("Status", "Custom Status 2", "Custom Status 4"))));
        this.assertIssuesWorkflowState("TST-7", "Custom Status 4", Arrays.asList("Go 3"));
        this.assertLastChangeHistoryRecords("TST-7", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "Destinatiom Workflow"), new ExpectedChangeHistoryItem("Status", "Closed", "Custom Status 4"))));
        this.assertIssuesWorkflowState("TST-8", "Resolved", Arrays.asList("Go 4"));
        this.assertLastChangeHistoryRecords("TST-8", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "Destinatiom Workflow"), new ExpectedChangeHistoryItem("Status", "In Progress", "Resolved"))));
        this.assertIssuesWorkflowState("TST-9", "Closed", Arrays.asList("Reopen Issue"));
        this.assertLastChangeHistoryRecords("TST-9", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "jira")));
        this.assertIssuesWorkflowState("TST-10", "Custom Status 3", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("TST-10", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 2", "Destinatiom Workflow"), new ExpectedChangeHistoryItem("Status", "Open", "Custom Status 3"))));
        this.assertIssuesWorkflowState("TST-11", "Custom Status 3", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("TST-11", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 2", "Destinatiom Workflow"), new ExpectedChangeHistoryItem("Status", "Open", "Custom Status 3"))));
    }

    public void testWorkflowMigrationHalfMigratedData() throws SAXException {
        this.restoreData("WorkflowMigrationTestBrokenHalfWay.xml");
        HashMap<String, String> statusMapping = new HashMap<String, String>();
        statusMapping.put("mapping_1_1", "Custom Status 3");
        statusMapping.put("mapping_1_10001", "Custom Status 4");
        statusMapping.put("mapping_4_1", "Custom Status 3");
        statusMapping.put("mapping_4_3", "Resolved");
        statusMapping.put("mapping_4_6", "Custom Status 4");
        statusMapping.put("mapping_2_1", "Custom Status 3");
        statusMapping.put("mapping_2_3", "Resolved");
        statusMapping.put("mapping_2_6", "Custom Status 4");
        this.associateWorkFlowSchemeToProject(TEST_PROJECT_NAME, DESTINATION_WORKFLOW_SCHEME, statusMapping);
        this.waitForSuccessfulWorkflowSchemeMigration(TEST_PROJECT_NAME, DESTINATION_WORKFLOW_SCHEME);
        this.assertIssuesMigratedAndChangeHistory();
    }

    public void testWorkflowMigrationWithKilledWFEntry() throws SAXException {
        this.restoreData("WorkflowMigrationTestBrokenHalfWay.xml");
        HashMap<String, String> statusMapping = new HashMap<String, String>();
        statusMapping.put("mapping_1_1", "Custom Status 3");
        statusMapping.put("mapping_1_10001", "Custom Status 4");
        statusMapping.put("mapping_4_1", "Custom Status 3");
        statusMapping.put("mapping_4_3", "Resolved");
        statusMapping.put("mapping_4_6", "Custom Status 4");
        statusMapping.put("mapping_2_1", "Custom Status 3");
        statusMapping.put("mapping_2_3", "Resolved");
        statusMapping.put("mapping_2_6", "Custom Status 4");
        this.associateWorkFlowSchemeToProject(TEST_PROJECT_NAME, DESTINATION_WORKFLOW_SCHEME, statusMapping);
        this.waitForSuccessfulWorkflowSchemeMigration(TEST_PROJECT_NAME, DESTINATION_WORKFLOW_SCHEME);
        this.assertIssuesMigratedAndChangeHistory();
    }

    public void testWorkflowMigrationWithUnupdatedIssue() throws SAXException {
        this.restoreData("WorkflowMigrationTestIssueWithUnupdatedIssue.xml");
        HashMap<String, String> statusMapping = new HashMap<String, String>();
        statusMapping.put("mapping_1_1", "Custom Status 3");
        statusMapping.put("mapping_1_10001", "Custom Status 4");
        statusMapping.put("mapping_4_1", "Custom Status 3");
        statusMapping.put("mapping_4_3", "Resolved");
        statusMapping.put("mapping_4_6", "Custom Status 4");
        statusMapping.put("mapping_2_1", "Custom Status 3");
        statusMapping.put("mapping_2_3", "Resolved");
        statusMapping.put("mapping_2_6", "Custom Status 4");
        this.associateWorkFlowSchemeToProject(TEST_PROJECT_NAME, DESTINATION_WORKFLOW_SCHEME, statusMapping);
        this.waitForSuccessfulWorkflowSchemeMigration(TEST_PROJECT_NAME, DESTINATION_WORKFLOW_SCHEME);
        this.assertIssuesMigratedAndChangeHistory();
    }

    private void assertIssuesMigratedAndChangeHistory() throws SAXException {
        this.assertIssuesWorkflowState("TST-1", "Open", Arrays.asList("Start Progress", "Resolve Issue", "Close Issue"));
        this.assertLastChangeHistoryRecords("TST-1", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "jira")));
        this.assertIssuesWorkflowState("TST-2", "Open", Arrays.asList("Start Progress", "Resolve Issue", "Close Issue"));
        this.assertLastChangeHistoryRecords("TST-2", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "jira")));
        this.assertIssuesWorkflowState("TST-3", "Resolved", Arrays.asList("Go 4"));
        this.assertLastChangeHistoryRecords("TST-3", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "Destinatiom Workflow"), new ExpectedChangeHistoryItem("Status", "In Progress", "Resolved"))));
        this.assertIssuesWorkflowState("TST-4", "Custom Status 4", Arrays.asList("Go 3"));
        this.assertLastChangeHistoryRecords("TST-4", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 2", "Destinatiom Workflow"), new ExpectedChangeHistoryItem("Status", "Custom Status 2", "Custom Status 4"))));
        this.assertIssuesWorkflowState("TST-5", "Custom Status 3", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("TST-5", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 2", "Destinatiom Workflow")));
        this.assertIssuesWorkflowState("TST-6", "Custom Status 4", Arrays.asList("Go 3"));
        this.assertLastChangeHistoryRecords("TST-6", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 2", "Destinatiom Workflow"), new ExpectedChangeHistoryItem("Status", "Custom Status 2", "Custom Status 4"))));
        this.assertIssuesWorkflowState("TST-7", "Custom Status 4", Arrays.asList("Go 3"));
        this.assertLastChangeHistoryRecords("TST-7", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "Destinatiom Workflow"), new ExpectedChangeHistoryItem("Status", "Closed", "Custom Status 4"))));
        this.assertIssuesWorkflowState("TST-8", "Resolved", Arrays.asList("Go 4"));
        this.assertLastChangeHistoryRecords("TST-8", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "Destinatiom Workflow"), new ExpectedChangeHistoryItem("Status", "In Progress", "Resolved"))));
        this.assertIssuesWorkflowState("TST-9", "Closed", Arrays.asList("Reopen Issue"));
        this.assertLastChangeHistoryRecords("TST-9", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "jira")));
        this.assertIssuesWorkflowState("TST-10", "Custom Status 3", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("TST-10", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 2", "Destinatiom Workflow")));
        this.assertIssuesWorkflowState("TST-11", "Custom Status 3", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("TST-11", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 2", "Destinatiom Workflow"), new ExpectedChangeHistoryItem("Status", "Open", "Custom Status 3"))));
    }

    public void testWorkflowMigrationWithUnupdatedWorkflowScheme() throws SAXException {
        this.restoreData("WorkflowMigrationTestUnchangedScheme.xml");
        HashMap<String, String> statusMapping = new HashMap<String, String>();
        statusMapping.put("mapping_1_1", "Custom Status 3");
        statusMapping.put("mapping_1_10001", "Custom Status 4");
        statusMapping.put("mapping_4_1", "Custom Status 3");
        statusMapping.put("mapping_4_3", "Resolved");
        statusMapping.put("mapping_4_6", "Custom Status 4");
        statusMapping.put("mapping_2_1", "Custom Status 3");
        statusMapping.put("mapping_2_3", "Resolved");
        statusMapping.put("mapping_2_6", "Custom Status 4");
        this.associateWorkFlowSchemeToProject(TEST_PROJECT_NAME, DESTINATION_WORKFLOW_SCHEME, statusMapping);
        this.waitForSuccessfulWorkflowSchemeMigration(TEST_PROJECT_NAME, DESTINATION_WORKFLOW_SCHEME);
        this.assertIssuesWorkflowState("TST-1", "Open", Arrays.asList("Start Progress", "Resolve Issue", "Close Issue"));
        this.assertLastChangeHistoryRecords("TST-1", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "jira")));
        this.assertIssuesWorkflowState("TST-2", "Open", Arrays.asList("Start Progress", "Resolve Issue", "Close Issue"));
        this.assertLastChangeHistoryRecords("TST-2", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "jira")));
        this.assertIssuesWorkflowState("TST-3", "Resolved", Arrays.asList("Go 4"));
        this.assertLastChangeHistoryRecords("TST-3", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "Destinatiom Workflow")));
        this.assertIssuesWorkflowState("TST-4", "Custom Status 4", Arrays.asList("Go 3"));
        this.assertLastChangeHistoryRecords("TST-4", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 2", "Destinatiom Workflow")));
        this.assertIssuesWorkflowState("TST-5", "Custom Status 3", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("TST-5", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 2", "Destinatiom Workflow")));
        this.assertIssuesWorkflowState("TST-6", "Custom Status 4", Arrays.asList("Go 3"));
        this.assertLastChangeHistoryRecords("TST-6", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 2", "Destinatiom Workflow")));
        this.assertIssuesWorkflowState("TST-7", "Custom Status 4", Arrays.asList("Go 3"));
        this.assertLastChangeHistoryRecords("TST-7", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "Destinatiom Workflow")));
        this.assertIssuesWorkflowState("TST-8", "Resolved", Arrays.asList("Go 4"));
        this.assertLastChangeHistoryRecords("TST-8", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "Destinatiom Workflow")));
        this.assertIssuesWorkflowState("TST-9", "Closed", Arrays.asList("Reopen Issue"));
        this.assertLastChangeHistoryRecords("TST-9", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "jira")));
        this.assertIssuesWorkflowState("TST-10", "Custom Status 3", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("TST-10", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 2", "Destinatiom Workflow")));
        this.assertIssuesWorkflowState("TST-11", "Custom Status 3", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("TST-11", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 2", "Destinatiom Workflow")));
    }

    public void testWorkflowMigrationWithRemovedWorkflowScheme() throws SAXException {
        this.restoreData("WorkflowMigrationTestRemovedWorkflowScheme.xml");
        HashMap<String, String> statusMapping = new HashMap<String, String>();
        statusMapping.put("mapping_1_1", "Custom Status 3");
        statusMapping.put("mapping_1_3", "Resolved");
        statusMapping.put("mapping_1_6", "Custom Status 4");
        statusMapping.put("mapping_1_4", "Custom Status 3");
        statusMapping.put("mapping_4_1", "Custom Status 3");
        statusMapping.put("mapping_4_3", "Resolved");
        statusMapping.put("mapping_4_6", "Custom Status 4");
        statusMapping.put("mapping_4_4", "Custom Status 3");
        statusMapping.put("mapping_2_1", "Custom Status 3");
        statusMapping.put("mapping_2_3", "Resolved");
        statusMapping.put("mapping_2_6", "Custom Status 4");
        statusMapping.put("mapping_2_4", "Custom Status 3");
        this.associateWorkFlowSchemeToProject(TEST_PROJECT_NAME, DESTINATION_WORKFLOW_SCHEME, statusMapping);
        this.waitForSuccessfulWorkflowSchemeMigration(TEST_PROJECT_NAME, DESTINATION_WORKFLOW_SCHEME);
        this.assertIssuesWorkflowState("TST-1", "Open", Arrays.asList("Start Progress", "Resolve Issue", "Close Issue"));
        this.assertLastChangeHistoryRecords("TST-1", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "jira")));
        this.assertIssuesWorkflowState("TST-2", "Open", Arrays.asList("Start Progress", "Resolve Issue", "Close Issue"));
        this.assertLastChangeHistoryRecords("TST-2", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "jira")));
        this.assertIssuesWorkflowState("TST-3", "Resolved", Arrays.asList("Go 4"));
        this.assertLastChangeHistoryRecords("TST-3", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "jira", "Destinatiom Workflow")));
        this.assertIssuesWorkflowState("TST-4", "Custom Status 4", Arrays.asList("Go 3"));
        this.assertLastChangeHistoryRecords("TST-4", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "jira", "Destinatiom Workflow")));
        this.assertIssuesWorkflowState("TST-5", "Custom Status 3", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("TST-5", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "jira", "Destinatiom Workflow")));
        this.assertIssuesWorkflowState("TST-6", "Custom Status 4", Arrays.asList("Go 3"));
        this.assertLastChangeHistoryRecords("TST-6", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "jira", "Destinatiom Workflow")));
        this.assertIssuesWorkflowState("TST-7", "Custom Status 4", Arrays.asList("Go 3"));
        this.assertLastChangeHistoryRecords("TST-7", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "jira", "Destinatiom Workflow")));
        this.assertIssuesWorkflowState("TST-8", "Resolved", Arrays.asList("Go 4"));
        this.assertLastChangeHistoryRecords("TST-8", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "jira", "Destinatiom Workflow")));
        this.assertIssuesWorkflowState("TST-9", "Closed", Arrays.asList("Reopen Issue"));
        this.assertLastChangeHistoryRecords("TST-9", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "Source Workflow 1", "jira")));
        this.assertIssuesWorkflowState("TST-10", "Custom Status 3", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("TST-10", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "jira", "Destinatiom Workflow")));
        this.assertIssuesWorkflowState("TST-11", "Custom Status 3", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("TST-11", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", "jira", "Destinatiom Workflow")));
    }

    public void testWorkflowMigrationHalfMigratedDataNewDestination() throws SAXException {
        this.restoreData("WorkflowMigrationHalfMigratedDataNewDestination.xml");
        this.gotoPage("/plugins/servlet/project-config/HSP/workflows");
        this.clickLink("project-config-workflows-scheme-change");
        this.assertLinkNotPresentWithText("Add");
        this.assertTextNotPresent("There are currently no workflow schemes setup.");
        String destinationSchemeName = "Homosapien Destination Scheme";
        this.selectOption("schemeId", destinationSchemeName);
        this.submit("Associate");
        this.assertTextPresent("Step 2 of 3");
        this.assertTextPresent("Migrate statuses from the old workflow scheme to the new one.");
        WebTable statusTable = this.getDialog().getResponse().getTableWithID("statusmapping_1");
        TestWorkflowMigrationEnterprise.assertEquals((String)WORFKLOW_HOMOSAPIEN_SOURCE_1, (String)statusTable.getCellAsText(0, 0).trim());
        TestWorkflowMigrationEnterprise.assertEquals((String)WORKFLOW_HOMOSPIEN_DESTINATION, (String)statusTable.getCellAsText(0, 2).trim());
        this.assertStatusMapping(statusTable, "In Progress", 1, 1, 3, new String[]{"Open", "Custom Status 3", "Custom Status 4", "Resolved"}, "Open");
        this.assertStatusMapping(statusTable, "Closed", 2, 1, 6, new String[]{"Open", "Custom Status 3", "Custom Status 4", "Resolved"}, "Resolved");
        this.assertStatusMapping(statusTable, "Custom Status 1", 3, 1, 10000, new String[]{"Open", "Custom Status 3", "Custom Status 4", "Resolved"}, "Custom Status 3");
        this.assertStatusMapping(statusTable, "Custom Status 2", 4, 1, 10001, new String[]{"Open", "Custom Status 3", "Custom Status 4", "Resolved"}, "Custom Status 4");
        this.assertFormElementNotPresent("mapping_1_10003");
        statusTable = this.getDialog().getResponse().getTableWithID("statusmapping_4");
        TestWorkflowMigrationEnterprise.assertEquals((String)WORKFLOW_HOMOSAPIEN_SOURCE_2, (String)statusTable.getCellAsText(0, 0).trim());
        TestWorkflowMigrationEnterprise.assertEquals((String)"jira", (String)statusTable.getCellAsText(0, 2).trim());
        this.assertStatusMapping(statusTable, "Custom Status 1", 1, 4, 10000, new String[]{"Open", "In Progress", "Resolved", REOPENED_STATUS_NAME, "Closed"}, "In Progress");
        this.assertStatusMapping(statusTable, "Custom Status 3", 2, 4, 10002, new String[]{"Open", "In Progress", "Resolved", REOPENED_STATUS_NAME, "Closed"}, "Resolved");
        this.assertTableNotPresent("statusmapping_2");
        this.assertTextNotPresent("New Feature");
        statusTable = this.getDialog().getResponse().getTableWithID("statusmapping_3");
        TestWorkflowMigrationEnterprise.assertEquals((String)WORKFLOW_HOMOSPIEN_DESTINATION, (String)statusTable.getCellAsText(0, 0).trim());
        TestWorkflowMigrationEnterprise.assertEquals((String)WORKFLOW_HOMOSPIEN_DESTINATION, (String)statusTable.getCellAsText(0, 2).trim());
        this.assertStatusMapping(statusTable, "In Progress", 1, 3, 3, new String[]{"Open", "Custom Status 3", "Custom Status 4", "Resolved"}, "Custom Status 3");
        this.assertStatusMapping(statusTable, "Closed", 2, 3, 6, new String[]{"Open", "Custom Status 3", "Custom Status 4", "Resolved"}, "Resolved");
        statusTable = this.getDialog().getResponse().getTableWithID("statusmapping_5");
        TestWorkflowMigrationEnterprise.assertEquals((String)WORFKLOW_HOMOSAPIEN_SOURCE_1, (String)statusTable.getCellAsText(0, 0).trim());
        TestWorkflowMigrationEnterprise.assertEquals((String)WORKFLOW_HOMOSPIEN_DESTINATION, (String)statusTable.getCellAsText(0, 2).trim());
        this.assertStatusMapping(statusTable, "Custom Status 1", 1, 5, 10000, new String[]{"Open", "Custom Status 3", "Custom Status 4", "Resolved"}, "Custom Status 3");
        this.assertStatusMapping(statusTable, "Custom Status 2", 2, 5, 10001, new String[]{"Open", "Custom Status 3", "Custom Status 4", "Resolved"}, "Custom Status 4");
        this.assertTableNotPresent("statusmapping_6");
        this.assertTextNotPresent("Custom Issue Type");
        this.submit("Associate");
        this.waitForSuccessfulWorkflowSchemeMigration("homosapien", destinationSchemeName);
        this.assertIssuesWorkflowState("HSP-1", "Open", Arrays.asList("Go Custom 3"));
        this.assertLastChangeHistoryRecords("HSP-1", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-2", "Open", Arrays.asList("Go Custom 3"));
        this.assertLastChangeHistoryRecords("HSP-2", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-3", "Open", Arrays.asList("Go Custom 3"));
        this.assertLastChangeHistoryRecords("HSP-3", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), new ExpectedChangeHistoryItem("Status", "In Progress", "Open"))));
        this.assertIssuesWorkflowState("HSP-4", "Open", Arrays.asList("Go Custom 3"));
        this.assertLastChangeHistoryRecords("HSP-4", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), new ExpectedChangeHistoryItem("Status", "In Progress", "Open"))));
        this.assertIssuesWorkflowState("HSP-5", "Custom Status 4", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("HSP-5", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-6", "Custom Status 4", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("HSP-6", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-7", "Resolved", Arrays.asList("Reopen"));
        this.assertLastChangeHistoryRecords("HSP-7", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), new ExpectedChangeHistoryItem("Status", "Closed", "Resolved"))));
        this.assertIssuesWorkflowState("HSP-8", "Resolved", Arrays.asList("Reopen"));
        this.assertLastChangeHistoryRecords("HSP-8", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), new ExpectedChangeHistoryItem("Status", "Closed", "Resolved"))));
        this.assertIssuesWorkflowState("HSP-9", "Open", Arrays.asList("Go Custom 3"));
        this.assertLastChangeHistoryRecords("HSP-9", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-10", "Open", Arrays.asList("Go Custom 3"));
        this.assertLastChangeHistoryRecords("HSP-10", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-11", "Custom Status 3", Arrays.asList("Go custom 4"));
        this.assertLastChangeHistoryRecords("HSP-11", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), new ExpectedChangeHistoryItem("Status", "Custom Status 1", "Custom Status 3"))));
        this.assertIssuesWorkflowState("HSP-12", "Custom Status 3", Arrays.asList("Go custom 4"));
        this.assertLastChangeHistoryRecords("HSP-12", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), new ExpectedChangeHistoryItem("Status", "Custom Status 1", "Custom Status 3"))));
        this.assertIssuesWorkflowState("HSP-13", "Custom Status 4", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("HSP-13", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), new ExpectedChangeHistoryItem("Status", "Custom Status 2", "Custom Status 4"))));
        this.assertIssuesWorkflowState("HSP-14", "Custom Status 4", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("HSP-14", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), new ExpectedChangeHistoryItem("Status", "Custom Status 2", "Custom Status 4"))));
        this.assertIssuesWorkflowState("HSP-15", "Custom Status 3", Arrays.asList("Go custom 4"));
        this.assertLastChangeHistoryRecords("HSP-15", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-16", "Custom Status 3", Arrays.asList("Go custom 4"));
        this.assertLastChangeHistoryRecords("HSP-16", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-17", "Open", Arrays.asList("Go Custom 3"));
        this.assertLastChangeHistoryRecords("HSP-17", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSPIEN_DESTINATION, WORKFLOW_HOMOSPIEN_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-18", "Custom Status 3", Arrays.asList("Go custom 4"));
        this.assertLastChangeHistoryRecords("HSP-18", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSPIEN_DESTINATION, WORKFLOW_HOMOSPIEN_DESTINATION), new ExpectedChangeHistoryItem("Status", "In Progress", "Custom Status 3"))));
        this.assertIssuesWorkflowState("HSP-19", "Custom Status 4", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("HSP-19", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSPIEN_DESTINATION, WORKFLOW_HOMOSPIEN_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-20", "Resolved", Arrays.asList("Reopen"));
        this.assertLastChangeHistoryRecords("HSP-20", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSPIEN_DESTINATION, WORKFLOW_HOMOSPIEN_DESTINATION), new ExpectedChangeHistoryItem("Status", "Closed", "Resolved"))));
        this.assertIssuesWorkflowState("HSP-21", "Open", Arrays.asList("Go Custom 3"));
        this.assertLastChangeHistoryRecords("HSP-21", (List)null);
        this.assertIssuesWorkflowState("HSP-22", "Custom Status 3", Arrays.asList("Go custom 4"));
        this.assertLastChangeHistoryRecords("HSP-22", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Status", "Open", "Custom Status 3")));
        this.assertIssuesWorkflowState("HSP-23", "Custom Status 4", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("HSP-23", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Status", "Custom Status 3", "Custom Status 4")));
        this.assertIssuesWorkflowState("HSP-24", "Resolved", Arrays.asList("Reopen"));
        this.assertLastChangeHistoryRecords("HSP-24", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Status", "Custom Status 4", "Resolved"), new ExpectedChangeHistoryItem("Resolution", "", "Fixed"))));
        this.assertIssuesWorkflowState("HSP-25", "Open", Arrays.asList("Start Progress", "Resolve Issue", "Close Issue"));
        this.assertLastChangeHistoryRecords("HSP-25", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSAPIEN_SOURCE_2, "jira")));
        this.assertIssuesWorkflowState("HSP-26", "Open", Arrays.asList("Start Progress", "Resolve Issue", "Close Issue"));
        this.assertLastChangeHistoryRecords("HSP-26", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSAPIEN_SOURCE_2, "jira")));
        this.assertIssuesWorkflowState("HSP-27", "In Progress", Arrays.asList("Stop Progress", "Resolve Issue", "Close Issue"));
        this.assertLastChangeHistoryRecords("HSP-27", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSAPIEN_SOURCE_2, "jira"), new ExpectedChangeHistoryItem("Status", "Custom Status 1", "In Progress"))));
        this.assertIssuesWorkflowState("HSP-28", "In Progress", Arrays.asList("Stop Progress", "Resolve Issue", "Close Issue"));
        this.assertLastChangeHistoryRecords("HSP-28", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSAPIEN_SOURCE_2, "jira"), new ExpectedChangeHistoryItem("Status", "Custom Status 1", "In Progress"))));
        this.assertIssuesWorkflowState("HSP-29", "Resolved", Arrays.asList("Reopen Issue", "Close Issue"));
        this.assertLastChangeHistoryRecords("HSP-29", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSAPIEN_SOURCE_2, "jira"), new ExpectedChangeHistoryItem("Status", "Custom Status 3", "Resolved"))));
        this.assertIssuesWorkflowState("HSP-30", "Resolved", Arrays.asList("Reopen Issue", "Close Issue"));
        this.assertLastChangeHistoryRecords("HSP-30", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSAPIEN_SOURCE_2, "jira"), new ExpectedChangeHistoryItem("Status", "Custom Status 3", "Resolved"))));
        this.assertIssuesWorkflowState("HSP-31", "Closed", Arrays.asList("Reopen Issue"));
        this.assertLastChangeHistoryRecords("HSP-31", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSAPIEN_SOURCE_2, "jira")));
        this.assertIssuesWorkflowState("HSP-32", "Closed", Arrays.asList("Reopen Issue"));
        this.assertLastChangeHistoryRecords("HSP-32", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSAPIEN_SOURCE_2, "jira")));
        this.assertIssuesWorkflowState("HSP-33", "Open", Arrays.asList("Go Custom 3"));
        this.assertLastChangeHistoryRecords("HSP-33", (List)null);
        this.assertIssuesWorkflowState("HSP-34", "Open", Arrays.asList("Go Custom 3"));
        this.assertLastChangeHistoryRecords("HSP-34", (List)null);
        this.assertIssuesWorkflowState("HSP-35", "Custom Status 3", Arrays.asList("Go custom 4"));
        this.assertLastChangeHistoryRecords("HSP-35", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem(SUMMARY_FIELD_ID, "In Progress New Feature 1", "Custom Status 3 New Feature 1")));
        this.assertIssuesWorkflowState("HSP-36", "Custom Status 3", Arrays.asList("Go custom 4"));
        this.assertLastChangeHistoryRecords("HSP-36", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem(SUMMARY_FIELD_ID, "In Progress New Feature 2", "Custom Status 3 New Feature 2")));
        this.assertIssuesWorkflowState("HSP-37", "Custom Status 4", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("HSP-37", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Status", "Custom Status 3", "Custom Status 4")));
        this.assertIssuesWorkflowState("HSP-38", "Custom Status 4", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("HSP-38", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Status", "Custom Status 3", "Custom Status 4")));
        this.assertIssuesWorkflowState("HSP-39", "Resolved", Arrays.asList("Reopen"));
        this.assertLastChangeHistoryRecords("HSP-39", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Status", "Custom Status 4", "Resolved"), new ExpectedChangeHistoryItem("Resolution", "", "Fixed"))));
        this.assertIssuesWorkflowState("HSP-40", "Resolved", Arrays.asList("Reopen"));
        this.assertLastChangeHistoryRecords("HSP-40", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Status", "Custom Status 4", "Resolved"), new ExpectedChangeHistoryItem("Resolution", "", "Fixed"))));
        this.assertIssuesWorkflowState("HSP-41", "Open", Arrays.asList("Go Custom 3"));
        this.assertLastChangeHistoryRecords("HSP-41", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-42", "Custom Status 4", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("HSP-42", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), new ExpectedChangeHistoryItem("Status", "Custom Status 2", "Custom Status 4"))));
        this.assertIssuesWorkflowState("HSP-43", "Custom Status 3", Arrays.asList("Go custom 4"));
        this.assertLastChangeHistoryRecords("HSP-43", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), new ExpectedChangeHistoryItem("Status", "Custom Status 1", "Custom Status 3"))));
        this.assertIssuesWorkflowState("HSP-44", "Open", Arrays.asList("Go Custom 3"));
        this.assertLastChangeHistoryRecords("HSP-44", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-45", "Custom Status 3", Arrays.asList("Go custom 4"));
        this.assertLastChangeHistoryRecords("HSP-45", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-46", "Custom Status 3", Arrays.asList("Go custom 4"));
        this.assertLastChangeHistoryRecords("HSP-46", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), new ExpectedChangeHistoryItem("Status", "Custom Status 1", "Custom Status 3"))));
        this.assertIssuesWorkflowState("HSP-47", "Custom Status 3", Arrays.asList("Go custom 4"));
        this.assertLastChangeHistoryRecords("HSP-47", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-48", "Custom Status 4", Arrays.asList("Resolve"));
        this.assertLastChangeHistoryRecords("HSP-48", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Workflow", WORFKLOW_HOMOSAPIEN_SOURCE_1, WORKFLOW_HOMOSPIEN_DESTINATION), new ExpectedChangeHistoryItem("Status", "Custom Status 2", "Custom Status 4"))));
        this.assertIssuesWorkflowState("HSP-49", "Open", Arrays.asList("Go custom"));
        this.assertLastChangeHistoryRecords("HSP-49", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_SOURCE, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-50", "Custom Status 3", Arrays.asList("Close"));
        this.assertLastChangeHistoryRecords("HSP-50", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_SOURCE, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-51", "Open", Arrays.asList("Go custom"));
        this.assertLastChangeHistoryRecords("HSP-51", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_SOURCE, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-52", "Resolved", Arrays.asList("Go Custom 3"));
        this.assertLastChangeHistoryRecords("HSP-52", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_SOURCE, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-53", "Resolved", Arrays.asList("Go Custom 3"));
        this.assertLastChangeHistoryRecords("HSP-53", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_SOURCE, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_DESTINATION)));
        this.assertIssuesWorkflowState("HSP-54", "Custom Status 3", Arrays.asList("Close"));
        this.assertLastChangeHistoryRecords("HSP-54", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Workflow", WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_SOURCE, WORKFLOW_HOMOSAPIEN_CUSTOM_ISSUETYPE_DESTINATION)));
        this.checkIssuesInTestProject();
    }

    private void checkIssuesInTestProject() throws SAXException {
        this.assertIssuesWorkflowState("TST-1", "Open", Arrays.asList("Start Progress"));
        this.assertLastChangeHistoryRecords("TST-1", (List)null);
        this.assertIssuesWorkflowState("TST-2", "Open", Arrays.asList("Start Progress"));
        this.assertLastChangeHistoryRecords("TST-2", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Assignee", "Developer User", "Admin"))));
        this.assertIssuesWorkflowState("TST-3", "In Progress", Arrays.asList("Stop Progress", "Close"));
        this.assertLastChangeHistoryRecords("TST-3", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Status", "Open", "In Progress"))));
        this.assertIssuesWorkflowState("TST-4", "Custom Status 2", Arrays.asList("Reopen"));
        this.assertLastChangeHistoryRecords("TST-4", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Status", "Open", "Custom Status 2"), new ExpectedChangeHistoryItem("Resolution", "", "Incomplete"))));
        this.assertIssuesWorkflowState("TST-5", "Open", Arrays.asList(TRANSITION_NAME_GO_CUSTOM));
        this.assertLastChangeHistoryRecords("TST-5", (List)null);
        this.assertIssuesWorkflowState("TST-6", "Custom Status 2", Arrays.asList("Reopen"));
        this.assertLastChangeHistoryRecords("TST-6", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Status", "Open", "Custom Status 2"), new ExpectedChangeHistoryItem("Fix Version/s", "", "Version 1"), new ExpectedChangeHistoryItem("Resolution", "", "Fixed"))));
        this.assertIssuesWorkflowState("TST-7", "Closed", null);
        this.assertLastChangeHistoryRecords("TST-7", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Status", "In Progress", "Closed"), new ExpectedChangeHistoryItem("Fix Version/s", "", "Version 1"), new ExpectedChangeHistoryItem("Resolution", "", "Cannot Reproduce"))));
        this.assertIssuesWorkflowState("TST-8", "In Progress", Arrays.asList("Stop Progress", "Close"));
        this.assertLastChangeHistoryRecords("TST-8", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Status", "Open", "In Progress"))));
        this.assertIssuesWorkflowState("TST-9", "Closed", null);
        this.assertLastChangeHistoryRecords("TST-9", new ExpectedChangeHistoryRecord(Arrays.asList(new ExpectedChangeHistoryItem("Status", "In Progress", "Closed"), new ExpectedChangeHistoryItem("Fix Version/s", "", "Version 3"), new ExpectedChangeHistoryItem("Resolution", "", "Won't Fix"))));
        this.assertIssuesWorkflowState("TST-10", "Open", Arrays.asList(TRANSITION_NAME_GO_CUSTOM));
        this.assertLastChangeHistoryRecords("TST-10", (List)null);
        this.assertIssuesWorkflowState("TST-11", "Open", Arrays.asList(TRANSITION_NAME_GO_CUSTOM));
        this.assertLastChangeHistoryRecords("TST-11", (List)null);
    }

    public void testIssueVerifier() {
        this.restoreData("WorkflowMigrationTestIssueVerifier.xml");
        this.administration.project().associateWorkflowScheme(TEST_PROJECT_NAME, DESTINATION_WORKFLOW_SCHEME, Collections.EMPTY_MAP, false);
        this.waitForFailedMigration("WORKFLOW ASSOCIATION ERROR");
        this.assertTextPresent("There are errors associated with issues that are to be migrated to the new workflow association");
        this.assertTextPresent("Unable to determine the current workflow entry for issue &#39;TST-2&#39;");
        this.assertTextPresent("Unable to determine the current status for issue &#39;TST-3&#39;");
        this.assertTextPresent("Unable to determine the current workflow entry for issue &#39;TST-6&#39;");
        this.assertTextPresent("Unable to determine the current issue type for issue &#39;TST-7&#39;");
        this.assertTextPresent("Unable to determine the current issue type for issue &#39;TST-9&#39;");
        this.assertTextPresent("Unable to determine the current status for issue &#39;TST-11&#39;");
    }

    public void testMultipleActiveWorkflowErrorMessageNotPresentInEnterprise() {
        this.restoreData("WorkflowMigrationTest.xml");
        this.gotoPage("secure/admin/workflows/ListWorkflows.jspa");
        this.assertTextNotPresent("An error has occured during workflow activation and the result is multiple active workflows");
    }

    public void testMultiAdminTaskProgressFlow() {
        this.restoreData("WorkflowMigrationTwoAdmins.xml");
        HashMap<String, String> statusMapping = new HashMap<String, String>();
        statusMapping.put("mapping_1_1", "Custom Status 3");
        statusMapping.put("mapping_1_10001", "Custom Status 4");
        statusMapping.put("mapping_4_1", "Custom Status 3");
        statusMapping.put("mapping_4_3", "Resolved");
        statusMapping.put("mapping_4_6", "Custom Status 4");
        statusMapping.put("mapping_2_1", "Custom Status 3");
        statusMapping.put("mapping_2_3", "Resolved");
        statusMapping.put("mapping_2_6", "Custom Status 4");
        this.administration.project().associateWorkflowScheme(TEST_PROJECT_NAME, DESTINATION_WORKFLOW_SCHEME, statusMapping, false);
        long taskId = this.getSubmittedTaskId();
        this.waitForTaskAcknowledgement(taskId);
        this.assertTextPresent("input type=\"submit\" name=\"Acknowledge\"");
        this.assertTextNotPresent("input type=\"submit\" name=\"Done\"");
        this.validateProgressBarUI(ACKNOWLEDGE);
        this.logout();
        this.login("admin2", "admin2");
        this.navigation.gotoAdmin();
        this.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep3.jspa?projectId=10000&taskId=" + taskId + "&schemeId=10001");
        this.validateProgressBarUI(DONE);
        this.assertTextNotPresent("input type=\"submit\" name=\"Acknowledge\"");
        this.assertTextPresent("input type=\"submit\" name=\"Done\"");
        this.logout();
        this.login("admin", "admin");
        this.navigation.gotoAdmin();
        this.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep3.jspa?projectId=10000&taskId=" + taskId + "&schemeId=10001");
        this.assertTextPresent("input type=\"submit\" name=\"Acknowledge\"");
        this.assertTextNotPresent("input type=\"submit\" name=\"Done\"");
        this.validateProgressBarUI(ACKNOWLEDGE);
        this.submit(ACKNOWLEDGE);
        this.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep3.jspa?projectId=10000&taskId=" + taskId + "&schemeId=10001");
        this.assertTextPresent("The task could not be found. Perhaps it has finished and has been acknowledged?");
        this.assertTextPresent("input type=\"submit\" name=\"Done\"");
    }

    private void assertStatusMapping(WebTable statusTable, String sourceStatusName, int tableRow, int issueTypeId, int sourceStatusId, String[] destinationStatuses, String optionToSelect) {
        TestWorkflowMigrationEnterprise.assertEquals((String)sourceStatusName, (String)statusTable.getCellAsText(tableRow, 0).trim());
        TableCell tableCell = statusTable.getTableCell(tableRow, 2);
        String selectName = "mapping_" + issueTypeId + "_" + sourceStatusId;
        HTMLElement[] selectList = tableCell.getElementsWithName(selectName);
        TestWorkflowMigrationEnterprise.assertNotNull((Object)selectList);
        TestWorkflowMigrationEnterprise.assertEquals((int)1, (int)selectList.length);
        this.assertOptionsEqual(selectName, destinationStatuses);
        this.selectOption(selectName, optionToSelect);
    }

    private void waitForFailedMigration(String typeOfErrorPage) {
        int MAX_ITERATIONS = 100;
        int its = 0;
        while (true) {
            if (++its > 100) {
                TestWorkflowMigrationEnterprise.fail((String)"The Workflow Migration took longer than 100 attempts!  Why?");
            }
            if (this.getResponseText().indexOf("type=\"submit\" name=\"Refresh\"") != -1) {
                this.submit("Refresh");
            } else {
                if (this.getDialog().getResponsePageTitle().indexOf(typeOfErrorPage) != -1) {
                    return;
                }
                TestWorkflowMigrationEnterprise.fail((String)"Page encountered during migration that was not expected");
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                TestWorkflowMigrationEnterprise.fail((String)"Test interupted");
                continue;
            }
            break;
        }
    }
}

