/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.ViewWorkflows;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestWorkflowDesigner
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testWorkflowDesignerValidWorkflowName() {
        ViewWorkflows viewWorkflows = this.administration.workflows().goTo();
        String name = "UNIQUE_WORKFLOW_NAME";
        String description = "UNIQUE_WORKFLOW_DESCRIPTION";
        viewWorkflows.addWorkflow("UNIQUE_WORKFLOW_NAME", "UNIQUE_WORKFLOW_DESCRIPTION");
        viewWorkflows.launchDesigner("UNIQUE_WORKFLOW_NAME");
        this.tester.assertTextPresent("UNIQUE_WORKFLOW_NAME");
        this.tester.assertTextPresent("UNIQUE_WORKFLOW_DESCRIPTION");
    }

    public void testWorkflowDesignerInvalidWorkflowName() {
        String name = "UNIQUE_WORKFLOW_NAME";
        this.navigation.gotoPage("secure/admin/workflows/WorkflowDesigner.jspa?wfName=UNIQUE_WORKFLOW_NAME");
        this.tester.assertTextPresent("No workflow with name 'UNIQUE_WORKFLOW_NAME' could be found.");
    }

    public void testWorkflowDesignerNoWorkflowName() {
        this.administration.workflows().goTo();
        String name = "";
        this.navigation.gotoPage("secure/admin/workflows/WorkflowDesigner.jspa?wfName=");
        this.tester.assertTextPresent("No workflow with name '' could be found.");
    }

    public void testWorkflowDesignerScriptTagInNameAndDescription() {
        ViewWorkflows viewWorkflows = this.administration.workflows().goTo();
        String name = "\"><script>alert('hello');</script>";
        String description = "\"><script>alert('world');</script>";
        viewWorkflows.addWorkflow("\"><script>alert('hello');</script>", "\"><script>alert('world');</script>");
        viewWorkflows.launchDesigner("\"><script>alert('hello');</script>");
        this.tester.assertTextNotPresent("\"><script>alert('hello');</script>");
        this.tester.assertTextNotPresent("\"><script>alert('world');</script>");
        this.tester.assertTextPresent("&gt;&lt;script&gt;alert(&#39;hello&#39;);&lt;/script&gt;");
        this.tester.assertTextPresent("&gt;&lt;script&gt;alert(&#39;world&#39;);&lt;/script&gt;");
    }

    public void testOldWorkflowEditorLinksToDesigner() {
        ViewWorkflows viewWorkflows = this.administration.workflows().goTo();
        String name = "UNIQUE_WORKFLOW_NAME";
        String description = "UNIQUE_WORKFLOW_DESCRIPTION";
        viewWorkflows.addWorkflow("UNIQUE_WORKFLOW_NAME", "UNIQUE_WORKFLOW_DESCRIPTION");
        viewWorkflows.workflowSteps("UNIQUE_WORKFLOW_NAME");
        this.tester.assertLinkPresent("workflow-designer-lnk");
        this.tester.clickLink("workflow-designer-lnk");
        this.tester.assertTextPresent("Workflow Designer");
        this.tester.assertTextPresent("UNIQUE_WORKFLOW_NAME");
    }
}

