/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import java.util.Arrays;
import java.util.HashMap;

@WebTest(value={Category.FUNC_TEST, Category.PERMISSIONS, Category.WORKFLOW})
public class TestWorkflowBasedPermissions
extends JIRAWebTest {
    public TestWorkflowBasedPermissions(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("WorkflowBasedPermissions.zip");
        this.administration.attachments().enable();
    }

    public void testWorkflowPermissions() {
        this._testSingleIssuePermissions();
        this._testBulkEdit();
    }

    private void _testSingleIssuePermissions() {
        TestWorkflowBasedPermissions.log("Check that non-overridden 'assignables' are correct");
        this.login("test", "test");
        this.createIssueStep1("Test Project", "Bug");
        this.assertFormElementPresent("assignee");
        this.assertOptionValuesEqual("assignee", new String[]{"-1", "assignable", "devadmin", "developer", "test"});
        TestWorkflowBasedPermissions.log("Test that the 'assignables' list is overridden when creating issues");
        this.createIssueStep1("Test Project", "ChangeRequest");
        this.assertOptionValuesEqual("assignee", new String[]{"-1", "assignable", "devadmin", "developer"});
        TestWorkflowBasedPermissions.log("Testing normal permissions on Open state");
        this.assertIssuePermissions("test", "TP-8", new boolean[]{true, true, true, true, true, true, true, true, true, true});
        this.assertIssuePermissions("test", "TP-9", new boolean[]{true, true, true, true, true, false, true, true, true, true});
        this.gotoIssue("TP-8");
        this.clickLink("assign-issue");
        this.assertOptionValuesEqual("assignee", new String[]{"-1", "developer", "assignable", "devadmin", "developer"});
        TestWorkflowBasedPermissions.log("Set the assignee to 'developer'");
        this.selectOption("assignee", "Joe Developer");
        this.submit();
        this.assertTextPresentBeforeText("Assignee:", "Joe Developer");
        TestWorkflowBasedPermissions.log("Progress workflow to 'Approved' status");
        this.clickLinkWithText("Approved");
        this.setFormElement("summary", "Approved CR");
        this.submit();
        this.assertIssuePermissions("test", "TP-8", new boolean[]{true, false, true, true, true, true, true, false, false, false});
        this.assertIssuePermissions("user1", "TP-8", new boolean[]{true, false, false, true, false, true, false, false, false, false});
        this.assertIssuePermissions("qa", "TP-8", new boolean[]{true, false, false, true, false, true, false, false, false, false});
        this.assertIssuePermissions("tpcustomer", "TP-8", new boolean[]{true, false, false, true, false, true, false, true, false, false});
        this.assertIssuePermissions("assignable", "TP-8", new boolean[]{true, true, true, true, false, true, false, false, false, false});
        this.assertIssuePermissions("manager", "TP-8", new boolean[]{true, false, false, true, false, true, false, false, true, false});
        this.assertIssuePermissions("devadmin", "TP-8", new boolean[]{true, false, true, true, false, true, false, false, false, true});
        this.assertIssuePermissions("test", "TP-9", new boolean[]{true, false, false, true, false, false, false, false, false, false});
        this.gotoIssue("TP-8");
        TestWorkflowBasedPermissions.log("Check that permissions are back to normal in 'In Progress' state");
        this.clickLinkWithText("Start Progress");
        this.setFormElement("summary", "In Progress CR");
        this.submit();
        this.assertIssuePermissions("test", "TP-8", new boolean[]{true, true, true, true, true, true, true, true, true, true});
        this.gotoIssue("TP-8");
        TestWorkflowBasedPermissions.log("Check that the correct users are assignable in 'In Progress' state");
        this.clickLink("assign-issue");
        this.assertOptionValuesEqual("assignee", new String[]{"-1", "developer", "test", "assignable", "devadmin", "developer", "test"});
        this.gotoIssue("TP-10");
        TestWorkflowBasedPermissions.log("Check that a subtask in the 'Approved' state becomes invisible");
        this.clickLinkWithText("Approved");
        this.setFormElement("summary", "hideme");
        this.submit();
        this.assertTextPresent("Permission Violation");
        this.gotoIssue("TP-8");
        TestWorkflowBasedPermissions.log("Check that on 'Resolve' transition screen, we see subset of assignees permissible for Resolved issues");
        this.clickLinkWithText("Resolve");
        this.assertOptionValuesEqual("assignee", new String[]{"-1", "developer", "developer"});
        TestWorkflowBasedPermissions.log("Check that we can resolve the issue");
        this.setFormElement("summary", "Resolved CR");
        this.selectOption("assignee", "Joe Developer");
        this.setFormElement("customfield_10000", "developer");
        this.submit();
        this.assertTextPresentBeforeText("Assignee:", "Joe Developer");
        TestWorkflowBasedPermissions.log("Check that in the 'Resolved' state, editing is limited to developer (custom field val), and permissions are otherwise normal");
        this.assertIssuePermissions("test", "TP-8", new boolean[]{true, true, true, true, true, true, true, false, true, true});
        this.assertIssuePermissions("developer", "TP-8", new boolean[]{true, true, true, true, true, true, false, true, true, true});
        this.assertIssuePermissions("qa", "TP-8", new boolean[]{true, false, true, true, true, true, false, false, false, false});
        this.assertIssuePermissions("tpcustomer", "TP-8", new boolean[]{true, false, true, true, true, true, false, false, false, false});
        this.assertIssuePermissions("assignable", "TP-8", new boolean[]{true, true, true, true, true, true, false, false, true, true});
        this.assertIssuePermissions("manager", "TP-8", new boolean[]{true, false, true, true, true, true, false, false, true, false});
        this.assertIssuePermissions("devadmin", "TP-8", new boolean[]{true, true, true, true, true, true, false, false, true, true});
    }

    private void assertIssuePermissions(String user, String key, boolean[] permissions) {
        this.login(user, user);
        this.gotoIssue(key);
        TestWorkflowBasedPermissions.log("Testing " + key + " permissions for " + user);
        if (permissions[0]) {
            if (permissions[1]) {
                this.assertLinkPresent("assign-issue");
            } else {
                this.assertLinkNotPresent("assign-issue");
            }
            if (permissions[2]) {
                this.assertLinkPresent("attach-file");
            } else {
                this.assertLinkNotPresent("attach-file");
            }
            if (permissions[3]) {
                this.assertLinkPresent("clone-issue");
            } else {
                this.assertLinkNotPresent("clone-issue");
            }
            if (permissions[4]) {
                this.assertLinkPresent("comment-issue");
            } else {
                this.assertLinkNotPresent("comment-issue");
            }
            if (permissions[5]) {
                this.assertLinkPresent("create-subtask");
            } else {
                this.assertLinkNotPresent("create-subtask");
            }
            if (permissions[6]) {
                this.assertLinkPresent("delete-issue");
            } else {
                this.assertLinkNotPresent("delete-issue");
            }
            if (permissions[7]) {
                this.assertLinkPresent("editIssue");
            } else {
                this.assertLinkNotPresent("editIssue");
            }
            if (permissions[8]) {
                this.assertLinkPresent("link-issue");
            } else {
                this.assertLinkNotPresent("link-issue");
            }
            if (permissions[9]) {
                this.assertLinkPresent("move-issue");
            } else {
                this.assertLinkNotPresent("move-issue");
            }
        } else {
            this.assertTextPresent("Permission Violation");
        }
    }

    private void _testBulkEdit() {
        this.clickLink("assign-issue");
        this.assertOptionValuesEqual("assignee", new String[]{"-1", "developer", "developer"});
        this.gotoIssue("TP-11");
        this.clickLink("assign-issue");
        this.assertOptionValuesEqual("assignee", new String[]{"-1", "assignable", "devadmin", "developer"});
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeSelectIssues(Arrays.asList("TP-8", "TP-11"));
        this.bulkChangeChooseOperationEdit();
        this.assertOptionValuesEqual("assignee", new String[]{"-1", "developer", "developer"});
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("assignee", "Joe Developer");
        this.bulkEditOperationDetailsSetAs(fields);
        fields = new HashMap();
        fields.put("assignee", "Joe Developer");
        this.bulkEditConfirmEdit(fields);
        this.bulkChangeConfirm();
        this.gotoIssue("TP-8");
        this.assertTextPresentBeforeText("Assignee", "Joe Developer");
        this.gotoIssue("TP-11");
        this.assertTextPresentBeforeText("Assignee", "Joe Developer");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeSelectIssues(Arrays.asList("TP-11"));
        this.bulkChangeChooseOperationEdit();
        this.assertOptionValuesEqual("assignee", new String[]{"-1", "developer", "assignable", "devadmin", "developer"});
        fields = new HashMap();
        fields.put("assignee", "Dev-Admin");
        this.bulkEditOperationDetailsSetAs(fields);
        fields = new HashMap();
        fields.put("assignee", "Dev-Admin");
        this.bulkEditConfirmEdit(fields);
        this.bulkChangeConfirm();
        this.gotoIssue("TP-11");
        this.assertTextPresentBeforeText("Assignee", "Dev-Admin");
    }
}

