/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestWorkFlowActions
extends JIRAWebTest {
    public static final String issueKey = "HSP-1";
    private static final String DODGY_WORKFLOW_NAME = "'><script>altert('hello')</script>";

    public TestWorkFlowActions(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestWorkflowActions.xml");
    }

    public void testCopyWorkflowWithXSS() {
        this.administration.workflows().goTo().addWorkflow(DODGY_WORKFLOW_NAME, "Some desc");
        this.administration.workflows().goTo();
        this.tester.clickLink("copy_'><script>altert('hello')</script>");
        this.tester.assertTextPresent("&#39;&gt;&lt;script&gt;altert(&#39;hello&#39;)&lt;/script&gt;");
        this.tester.setFormElement("newWorkflowName", "Copy of '><script>altert('hello')</script>");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Copy of &#39;&gt;&lt;script&gt;altert(&#39;hello&#39;)&lt;/script&gt;");
    }

    public void testWorkFlowActions() {
        this.assignIssue(issueKey);
        this.resolveIssue(issueKey);
        this.closeAndReopenIssue(issueKey);
        this.closeIssueFromOpen(issueKey);
        this.navigation.issue().deleteIssue(issueKey);
    }

    public void testInvalidWorkflowAction() throws Exception {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.gotoPage("/secure/WorkflowUIDispatcher.jspa?id=10000&action=3&atl_token=" + this.page.getXsrfToken());
        this.tester.assertTextPresent("Workflow Action Invalid");
        this.tester.assertTextPresent("Reopen Issue");
        this.tester.assertLinkPresent("refreshIssue");
    }

    public void testInvalidWorkflowActionDoesNotBreakThePage() throws Exception {
        this.administration.restoreData("TestWorkflowActionsDodgyWorkflow.xml");
        this.navigation.issue().viewIssue("TST-1");
        this.tester.assertTextPresent("Details");
        this.tester.assertLinkNotPresentWithText("Close Issue");
        this.tester.assertLinkNotPresentWithText("Resolve Issue");
    }

    public void testWorkflowWithReturnUrl() {
        this.tester.gotoPage("/secure/WorkflowUIDispatcher.jspa?id=10000&action=5&atl_token=" + this.page.getXsrfToken() + "&returnUrl=%2Fsecure%2FIssueNavigator.jspa%3Freset%3Dtrue%26jqlQuery%3Dproject%2B%3D%2BHSP%26selectedIssueId%3D10000");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        String currentUrl = this.tester.getDialog().getResponse().getURL().toExternalForm();
        TestWorkFlowActions.assertTrue((String)"Did not get redirected to the issue navigator.", (boolean)currentUrl.endsWith("/secure/IssueNavigator.jspa?reset=true&jqlQuery=project+=+HSP&selectedIssueId=10000"));
    }

    public void assignIssue(String issueKey) {
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        try {
            this.administration.usersAndGroups().addUserToGroup("bob", "jira-developers");
        }
        catch (Throwable t) {
            TestWorkFlowActions.log("bob is already part of jira-developers");
        }
        this.navigation.issue().assignIssue(issueKey, "issue assigned", "Bob The Builder");
        this.administration.usersAndGroups().removeUserFromGroup("bob", "jira-developers");
        this.navigation.issue().assignIssue(issueKey, "issue assigned", "Administrator");
    }

    public void resolveIssue(String issueKey) {
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Open", (Object)"resolution", (Object)"Unresolved", (Object)"key", (Object)issueKey), null, issueKey);
        this.progressAndResolve(issueKey, 5, "issue resolved");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Resolved", (Object)"resolution", (Object)"Fixed", (Object)"key", (Object)issueKey), null, issueKey);
    }

    public void closeAndReopenIssue(String issueKey) {
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Resolved", (Object)"resolution", (Object)"Fixed", (Object)"key", (Object)issueKey, (Object)"version", (Object)"New Version 1"), null, issueKey);
        this.progressWorkflow(issueKey, 701, "issue closed");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Closed", (Object)"key", (Object)issueKey), null, issueKey);
        this.progressWorkflow(issueKey, 3, "issue reopened");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Reopened", (Object)"key", (Object)issueKey), null, issueKey);
    }

    public void closeIssueFromOpen(String issueKey) {
        this.progressAndResolve(issueKey, 2, "issue resolved and closed");
        this.progressWorkflow(issueKey, 3, "issue reopened");
    }
}

