/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestTransitionWorkflowScreen
extends JIRAWebTest {
    public static final String TEST_BACKUP_XML = "TestTransitionWorkflowScreen.xml";
    private static final String COMMENT_VALUE = "i should survive the error";
    private static final String COMMENT_1 = "This issue is resolved now.";
    private static final String COMMENT_2 = "Viewable by developers group.";
    private static final String COMMENT_3 = "Viewable by Developers role.";
    private static final String COMMENT_4 = "Viewable by jira-adminiistrators role.";
    private static final String COMMENT_5 = "Viewable by Administrators role.";
    private static final String HSP_1 = "HSP-1";
    private static final String HSP_2 = "HSP-2";
    private static final String HSP_3 = "HSP-3";
    private static final String HSP_4 = "HSP-4";
    private static final String HSP_5 = "HSP-5";

    public TestTransitionWorkflowScreen(String name) {
        super(name);
    }

    @Override
    public void tearDown() {
        this.restoreBlankInstance();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCommentValueRemainsOnError() {
        this.restoreData(TEST_BACKUP_XML);
        this.enableCommentGroupVisibility(Boolean.TRUE);
        String issueKey = HSP_1;
        try {
            this.gotoIssue(issueKey);
            this.clickLinkWithText("Resolve Issue");
            this.setWorkingForm("issue-workflow-transition");
            this.setFormElement("summary", "");
            this.setFormElement("comment", COMMENT_VALUE);
            this.selectOption("commentLevel", "jira-developers");
            this.submit("Transition");
            this.assertTextPresent("You must specify a summary of the issue");
            this.assertTextPresent(COMMENT_VALUE);
            this.setFormElement("summary", "summary of resolving issue");
            this.submit("Transition");
            this.checkCommentVisibility("fred", issueKey, null, EasyList.build((Object)COMMENT_VALUE));
            this.checkCommentVisibility("admin", issueKey, EasyList.build((Object)COMMENT_VALUE), null);
        }
        catch (Throwable throwable) {
            this.deleteIssue(issueKey);
            this.removeFieldFromFieldScreen("Resolve Issue Screen", new String[]{"Summary"});
            throw throwable;
        }
        this.deleteIssue(issueKey);
        this.removeFieldFromFieldScreen("Resolve Issue Screen", new String[]{"Summary"});
    }

    public void testTransitionIssueForTheCommentVisibility() {
        this.restoreData(TEST_BACKUP_XML);
        this.enableCommentGroupVisibility(Boolean.TRUE);
        this.displayAllIssues();
        this.clickLinkWithText(HSP_1);
        this.clickLink("action_id_5");
        this.setWorkingForm("issue-workflow-transition");
        this.setFormElement("comment", COMMENT_1);
        this.submit("Transition");
        this.displayAllIssues();
        this.clickLinkWithText(HSP_2);
        this.clickLink("action_id_5");
        this.setWorkingForm("issue-workflow-transition");
        this.setFormElement("comment", COMMENT_2);
        this.selectOption("commentLevel", "jira-developers");
        this.submit("Transition");
        this.displayAllIssues();
        this.clickLinkWithText(HSP_3);
        this.clickLink("action_id_5");
        this.setWorkingForm("issue-workflow-transition");
        this.setFormElement("comment", COMMENT_3);
        this.selectOption("commentLevel", "Developers");
        this.submit("Transition");
        this.displayAllIssues();
        this.clickLinkWithText(HSP_4);
        this.clickLink("action_id_5");
        this.setWorkingForm("issue-workflow-transition");
        this.setFormElement("comment", COMMENT_4);
        this.selectOption("commentLevel", "Administrators");
        this.submit("Transition");
        this.displayAllIssues();
        this.clickLinkWithText(HSP_5);
        this.clickLink("action_id_5");
        this.setWorkingForm("issue-workflow-transition");
        this.setFormElement("comment", COMMENT_5);
        this.selectOption("commentLevel", "jira-administrators");
        this.submit("Transition");
        this.checkCommentVisibility("fred", HSP_1, EasyList.build((Object)COMMENT_1), null);
        this.checkCommentVisibility("fred", HSP_2, null, EasyList.build((Object)COMMENT_2));
        this.checkCommentVisibility("fred", HSP_3, null, EasyList.build((Object)COMMENT_3));
        this.checkCommentVisibility("admin", HSP_1, EasyList.build((Object)COMMENT_1), null);
        this.checkCommentVisibility("admin", HSP_2, EasyList.build((Object)COMMENT_2), null);
        this.checkCommentVisibility("admin", HSP_3, EasyList.build((Object)COMMENT_3), null);
        this.checkCommentVisibility("devman", HSP_2, EasyList.build((Object)COMMENT_2), null);
        this.checkCommentVisibility("devman", HSP_3, EasyList.build((Object)COMMENT_3), null);
        this.checkCommentVisibility("devman", HSP_4, null, EasyList.build((Object)COMMENT_4));
        this.checkCommentVisibility("devman", HSP_5, null, EasyList.build((Object)COMMENT_5));
        this.checkCommentVisibility("adminman", HSP_2, null, EasyList.build((Object)COMMENT_2));
        this.checkCommentVisibility("adminman", HSP_3, null, EasyList.build((Object)COMMENT_3));
        this.checkCommentVisibility("adminman", HSP_4, EasyList.build((Object)COMMENT_4), null);
        this.checkCommentVisibility("adminman", HSP_5, EasyList.build((Object)COMMENT_5), null);
    }

    public void testTransitionWithBlankDescription() throws Exception {
        this.restoreData("TestTransitionDescriptionEmpty.xml");
        this.gotoIssue("HMS-1");
        this.assertTextPresent("Start Progress - a description");
        this.assertTextNotPresent("Resolve Issue - ");
    }
}

