/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.workflow.TestDraftWorkflow;
import com.meterware.httpunit.WebResponse;
import java.util.Collections;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestDraftWorkflowEnterprise
extends TestDraftWorkflow {
    public TestDraftWorkflowEnterprise(String name) {
        super(name);
    }

    public void testCreateAndDeleteDraftWorkflow() throws SAXException {
        this._testCreateAndDeleteDraftWorkflow(5);
    }

    public void testWorkflowCachingHeaders() {
        this.gotoWorkFlow();
        this.tester.clickLink("xml_jira");
        WebResponse response = this.getDialog().getResponse();
        TestDraftWorkflowEnterprise.assertEquals((String)"", (String)response.getHeaderField("Pragma"));
        String cacheControl = response.getHeaderField("Cache-Control");
        TestDraftWorkflowEnterprise.assertTrue((cacheControl.indexOf("private") > -1 ? 1 : 0) != 0);
        TestDraftWorkflowEnterprise.assertTrue((cacheControl.indexOf("must-revalidate") > -1 ? 1 : 0) != 0);
        TestDraftWorkflowEnterprise.assertTrue((cacheControl.indexOf("max-age") > -1 ? 1 : 0) != 0);
        this.assertResponseCanBeCached();
    }

    public void testInstructions() {
        this.gotoWorkFlow();
        this.assertTextPresent("All workflows have one of the following statuses");
        this.assertTextSequence(new String[]{"Active", "currently assigned to at least one scheme which is associated with one or more projects."});
        this.assertTextSequence(new String[]{"Draft", "a draft version of an active workflow, which can be published to apply all changes"});
        this.assertTextSequence(new String[]{"Inactive", "not assigned to any scheme, or assigned to schemes which are not associated with any projects."});
        this.assertTextPresent("To delete a workflow, you must first unassign it from any workflow schemes.");
    }

    public void testDeactivateDraftWorkflow() throws SAXException, InterruptedException {
        this.restoreData("TestDeactivateDraftWorkflowEnterprise.xml");
        this.gotoWorkFlow();
        this.assertTableCellHasText("workflows_table", 2, 0, "Workflow1");
        this.assertTableCellHasText("workflows_table", 2, 2, "Active");
        this.assertTableCellHasText("workflows_table", 2, 3, "WorkflowScheme_Workflow1");
        this.assertTableCellHasText("workflows_table", 2, 3, "A second scheme");
        this.assertTableCellHasText("workflows_table", 3, 0, "Workflow1");
        this.assertTableCellHasText("workflows_table", 3, 2, "Draft");
        this.assertTableCellHasText("workflows_table", 3, 3, "WorkflowScheme_Workflow1");
        this.assertTableCellHasText("workflows_table", 3, 3, "A second scheme");
        this.assertTableCellHasText("workflows_table", 5, 0, "Workflow3");
        this.assertTableCellHasText("workflows_table", 5, 2, "Active");
        this.assertTableCellHasNotText("workflows_table", 5, 3, "WorkflowScheme_Workflow1");
        this.assertTableCellHasText("workflows_table", 5, 3, "A second scheme");
        this.assertTableCellHasText("workflows_table", 6, 0, "Workflow3");
        this.assertTableCellHasText("workflows_table", 6, 2, "Draft");
        this.assertTableCellHasNotText("workflows_table", 6, 3, "WorkflowScheme_Workflow1");
        this.assertTableCellHasText("workflows_table", 6, 3, "A second scheme");
        this.clickLink("steps_live_Workflow1");
        this.assertTextNotPresent("NewDraftStep");
        this.gotoWorkFlow();
        this.clickLink("steps_draft_Workflow1");
        this.assertTextPresent("NewDraftStep");
        this.gotoWorkFlow();
        this.clickLink("steps_live_Workflow3");
        this.assertTextNotPresent("AnotherNewDraftStep");
        this.gotoWorkFlow();
        this.clickLink("steps_draft_Workflow3");
        this.assertTextPresent("AnotherNewDraftStep");
        this.associateWorkFlowSchemeToProject("monkey", "Default");
        this.gotoWorkFlow();
        this.assertTableCellHasText("workflows_table", 2, 0, "Copy of Workflow3");
        this.assertTableCellHasText("workflows_table", 2, 1, "(This copy was automatically generated from a draft, when workflow 'Workflow3' was made inactive.)");
        this.assertTableCellHasText("workflows_table", 2, 2, "Inactive");
        this.assertTableCellHasNotText("workflows_table", 2, 3, "WorkflowScheme_Workflow1");
        this.assertTableCellHasNotText("workflows_table", 2, 3, "A second scheme");
        this.clickLink("steps_live_Copy of Workflow3");
        this.assertTextPresent("AnotherNewDraftStep");
        this.gotoWorkFlow();
        this.clickLink("steps_live_Workflow3");
        this.assertTextNotPresent("AnotherNewDraftStep");
        this.gotoWorkFlow();
        this.assertTableCellHasText("workflows_table", 3, 0, "Workflow1");
        this.assertTableCellHasText("workflows_table", 3, 2, "Active");
        this.assertTableCellHasText("workflows_table", 3, 3, "WorkflowScheme_Workflow1");
        this.assertTableCellHasText("workflows_table", 3, 3, "A second scheme");
        this.assertTableCellHasText("workflows_table", 4, 0, "Workflow1");
        this.assertTableCellHasText("workflows_table", 4, 2, "Draft");
        this.assertTableCellHasText("workflows_table", 4, 3, "WorkflowScheme_Workflow1");
        this.assertTableCellHasText("workflows_table", 4, 3, "A second scheme");
        this.assertTableCellHasText("workflows_table", 6, 0, "Workflow3");
        this.assertTableCellHasText("workflows_table", 6, 2, "Inactive");
        this.assertTableCellHasNotText("workflows_table", 6, 3, "WorkflowScheme_Workflow1");
        this.assertTableCellHasText("workflows_table", 6, 3, "A second scheme");
        this.associateWorkFlowSchemeToProject("homosapien", "Default", Collections.EMPTY_MAP);
        this.waitForSuccessfulWorkflowSchemeMigration("homosapien", "Default");
        this.gotoWorkFlow();
        this.assertTableCellHasText("workflows_table", 2, 0, "Copy of Workflow1");
        this.assertTableCellHasText("workflows_table", 2, 1, "(This copy was automatically generated from a draft, when workflow 'Workflow1' was made inactive.)");
        this.assertTableCellHasText("workflows_table", 2, 2, "Inactive");
        this.assertTableCellHasNotText("workflows_table", 2, 3, "WorkflowScheme_Workflow1");
        this.assertTableCellHasNotText("workflows_table", 2, 3, "A second scheme");
        this.assertTableCellHasText("workflows_table", 3, 0, "Copy of Workflow3");
        this.assertTableCellHasText("workflows_table", 3, 1, "(This copy was automatically generated from a draft, when workflow 'Workflow3' was made inactive.)");
        this.assertTableCellHasText("workflows_table", 3, 2, "Inactive");
        this.assertTableCellHasNotText("workflows_table", 3, 3, "WorkflowScheme_Workflow1");
        this.assertTableCellHasNotText("workflows_table", 3, 3, "A second scheme");
        this.clickLink("steps_live_Copy of Workflow3");
        this.assertTextPresent("AnotherNewDraftStep");
        this.gotoWorkFlow();
        this.clickLink("steps_live_Workflow3");
        this.assertTextNotPresent("AnotherNewDraftStep");
        this.gotoWorkFlow();
        this.clickLink("steps_live_Copy of Workflow1");
        this.assertTextPresent("NewDraftStep");
        this.gotoWorkFlow();
        this.clickLink("steps_live_Workflow1");
        this.assertTextNotPresent("NewDraftStep");
        this.gotoWorkFlow();
        this.assertTableCellHasText("workflows_table", 4, 0, "Workflow1");
        this.assertTableCellHasText("workflows_table", 4, 2, "Inactive");
        this.assertTableCellHasText("workflows_table", 4, 3, "WorkflowScheme_Workflow1");
        this.assertTableCellHasText("workflows_table", 4, 3, "A second scheme");
        this.assertTableCellHasText("workflows_table", 6, 0, "Workflow3");
        this.assertTableCellHasText("workflows_table", 6, 2, "Inactive");
        this.assertTableCellHasNotText("workflows_table", 6, 3, "WorkflowScheme_Workflow1");
        this.assertTableCellHasText("workflows_table", 6, 3, "A second scheme");
    }
}

