/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.WorkflowSchemes;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestAddWorkflowTransition
extends FuncTestCase {
    private static final String WORKFLOW_NAME = "Test Workflow";
    private static final String STEP_NAME_OPEN = "Open";
    private static final String STEP_NAME_AND = "SpecialChar&";
    private static final String STEP_NAME_LESSTHAN = "SpecialChar<";
    private static final String STEP_NAME_QUOTE = "SpecialChar\"";
    private static final String TRANSITION_NAME_AND = "To&";
    private static final String TRANSITION_NAME_LESSTHAN = "To<";
    private static final String TRANSITION_NAME_QUOTE = "To\"";
    private static final String ISSUE_STATUS_VALUE_ID = "status-val";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestAddWorkflowTransition.xml");
    }

    public void testAddWorkflowTransitionSpecialCharacters() {
        this.administration.workflows().goTo().workflowSteps(WORKFLOW_NAME).add(STEP_NAME_AND, null).add(STEP_NAME_LESSTHAN, null).add(STEP_NAME_QUOTE, null).addTransition(STEP_NAME_OPEN, TRANSITION_NAME_AND, null, STEP_NAME_AND, null).addTransition(STEP_NAME_AND, TRANSITION_NAME_LESSTHAN, null, STEP_NAME_LESSTHAN, null).addTransition(STEP_NAME_LESSTHAN, TRANSITION_NAME_QUOTE, null, STEP_NAME_QUOTE, null);
        ((WorkflowSchemes)this.administration.workflowSchemes().goTo()).addWorkflowScheme("New Workflow Scheme", "Test workflow scheme.");
        ((WorkflowSchemes)this.administration.workflowSchemes().goTo()).assignWorkflow("New Workflow Scheme", "Bug", WORKFLOW_NAME);
        this.administration.project().associateWorkflowScheme("homosapien", "New Workflow Scheme");
        this.navigation.issue().createIssue("homosapien", "Bug", "Test Special Characters");
        this.transitionCurrentIssueTo(TRANSITION_NAME_AND);
        this.transitionCurrentIssueTo(TRANSITION_NAME_LESSTHAN);
        this.transitionCurrentIssueTo(TRANSITION_NAME_QUOTE);
        this.assertCurrentIssueIsResolved();
    }

    private void transitionCurrentIssueTo(String transitionName) {
        this.navigation.clickLinkWithExactText(transitionName);
    }

    private void assertCurrentIssueIsResolved() {
        this.text.assertTextPresent(this.locator.id(ISSUE_STATUS_VALUE_ID), "Resolved");
    }
}

