/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.sharing.GroupTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.FILTERS})
public class TestViewGroup
extends FuncTestCase {
    public static final int CREATE_SHARED_FILTER = 22;
    private static final String TEST_GROUP = "test_group";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testGroupSharedFiltersReported() {
        this.gotoViewGroup("jira-users");
        this.text.assertTextPresent(this.locator.css("td.jiraformbody"), "There are no Saved Filters associated with this Group.");
        this.administration.addGlobalPermission(22, "jira-users");
        this.navigation.issueNavigator().createSearch(new NavigatorSearch(Collections.emptyList()));
        long adminId = this.navigation.issueNavigator().saveCurrentAsNewFilter("AdministratorFilter", "AdministratorFilter description", true, (Set<? extends TestSharingPermission>)ImmutableSet.of((Object)new GroupTestSharingPermission("jira-users")));
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.issueNavigator().createSearch(new NavigatorSearch(Collections.emptyList()));
        long fredId = this.navigation.issueNavigator().saveCurrentAsNewFilter("FredFilter", null, true, (Set<? extends TestSharingPermission>)ImmutableSet.of((Object)new GroupTestSharingPermission("jira-users")));
        this.navigation.logout();
        this.navigation.login("admin");
        this.gotoViewGroup("jira-users");
        this.text.assertTextPresent(this.locator.css("td.jiraformbody"), "AdministratorFilter (Owner: Administrator)");
        this.text.assertTextPresent(this.locator.css("td.jiraformbody"), "FredFilter (Owner: Fred Normal)");
        this.navigation.manageFilters().deleteFilter((int)adminId);
        this.gotoViewGroup("jira-users");
        this.text.assertTextNotPresent(this.locator.css("td.jiraformbody"), "AdministratorFilter (Owner: Administrator)");
        this.text.assertTextPresent(this.locator.css("td.jiraformbody"), "FredFilter (Owner: Fred Normal)");
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.manageFilters().deleteFilter((int)fredId);
        this.navigation.logout();
        this.navigation.login("admin");
        this.gotoViewGroup("jira-users");
        this.text.assertTextNotPresent(this.locator.css("td.jiraformbody"), "AdministratorFilter (Owner: Administrator)");
        this.text.assertTextNotPresent(this.locator.css("td.jiraformbody"), "FredFilter (Owner: Fred Normal)");
        this.text.assertTextPresent(this.locator.css("td.jiraformbody"), "There are no Saved Filters associated with this Group.");
    }

    public void testViewSchemes() {
        this.navigation.gotoAdmin();
        this.tester.clickLink("group_browser");
        this.tester.setFormElement("addName", TEST_GROUP);
        this.tester.submit("add_group");
        this.tester.clickLinkWithText(TEST_GROUP);
        this.text.assertTextPresent(this.locator.page(), "There are no Permission Schemes associated with this Group.");
        this.text.assertTextPresent(this.locator.page(), "There are no Notification Schemes associated with this Group.");
        this.text.assertTextPresent(this.locator.page(), "There are no Saved Filters associated with this Group.");
        this.text.assertTextPresent(this.locator.page(), "There are no Issue Security Schemes associated with this Group.");
        this.navigation.gotoAdmin();
        this.tester.clickLink("permission_schemes");
        this.tester.clickLink("0_edit");
        this.tester.clickLink("add_perm_23");
        this.tester.checkCheckbox("type", "group");
        this.tester.selectOption("group", TEST_GROUP);
        this.tester.submit(" Add ");
        this.navigation.gotoAdmin();
        this.tester.clickLink("notification_schemes");
        this.tester.clickLink("10000_edit");
        this.tester.clickLink("add_1");
        this.tester.checkCheckbox("type", "Group_Dropdown");
        this.tester.selectOption("Group_Dropdown", TEST_GROUP);
        this.tester.submit("Add");
        this.navigation.gotoAdmin();
        this.tester.clickLink("security_schemes");
        this.tester.clickLink("add_securityscheme");
        this.tester.setFormElement("name", "Test Issue Security Scheme");
        this.tester.submit("Add");
        this.tester.clickLinkWithText("Security Levels");
        this.tester.setFormElement("name", "Code Red");
        this.tester.submit("Add Security Level");
        this.tester.setFormElement("name", "");
        this.tester.clickLink("add_Code Red");
        this.tester.checkCheckbox("type", "group");
        this.tester.selectOption("group", TEST_GROUP);
        this.tester.submit(" Add ");
        this.gotoViewGroup(TEST_GROUP);
        this.text.assertTextPresent(this.locator.page(), "Default Permission Scheme");
        this.text.assertTextPresent(this.locator.page(), "Default Notification Scheme");
        this.text.assertTextPresent(this.locator.page(), "Test Issue Security Scheme");
        this.navigation.gotoAdmin();
        this.tester.clickLink("notification_schemes");
        this.tester.clickLink("10000_edit");
        this.tester.clickLink("del_10060");
        this.tester.submit("Delete");
        this.tester.clickLink("permission_schemes");
        this.tester.clickLink("0_edit");
        this.tester.clickLink("del_perm_23_test_group");
        this.tester.submit("Delete");
        this.tester.clickLink("security_schemes");
        this.tester.clickLink("del_Test Issue Security Scheme");
        this.tester.submit("Delete");
        this.gotoViewGroup(TEST_GROUP);
        this.text.assertTextPresent(this.locator.page(), "There are no Permission Schemes associated with this Group.");
        this.text.assertTextPresent(this.locator.page(), "There are no Notification Schemes associated with this Group.");
        this.text.assertTextPresent(this.locator.page(), "There are no Saved Filters associated with this Group.");
        this.text.assertTextPresent(this.locator.page(), "There are no Issue Security Schemes associated with this Group.");
    }

    private void gotoViewGroup(String group) {
        this.tester.gotoPage("secure/admin/user/ViewGroup.jspa?name=" + group);
        this.text.assertTextPresent(this.locator.css("td.jiraformheader"), "Group: " + group);
    }
}

