/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestUserBrowser
extends FuncTestCase {
    private static final List<String> EVERYONE = Arrays.asList("admin", "anteater", "antoinette", "anton", "antone", "barney", "detkin");
    private static final String USER_NAME_FILTER = "userNameFilter";
    private static final String FULL_NAME_FILTER = "fullNameFilter";
    private static final String EMAIL_FILTER = "emailFilter";
    private static final String MAX = "max";

    @Override
    protected void setUpTest() {
    }

    public void testFindByFiltering() {
        this.administration.restoreData("TestUserBrowser.xml");
        this.gotoUserBrowser();
        this.resetAll();
        this.assertUserNameColumn(EVERYONE);
        this.filterBy(USER_NAME_FILTER, "ant");
        this.assertUserNameColumn(Arrays.asList("anteater", "antoinette", "anton", "antone"));
        this.filterBy(FULL_NAME_FILTER, "anto");
        this.assertUserNameColumn(Arrays.asList("antoinette", "anton", "antone"));
        this.filterBy(EMAIL_FILTER, "ant");
        this.assertUserNameColumn(Arrays.asList("antoinette", "anton", "antone"));
        this.resetFilterBy(FULL_NAME_FILTER);
        this.assertUserNameColumn(Arrays.asList("anteater", "antoinette", "anton", "antone"));
        this.resetFilterBy(EMAIL_FILTER);
        this.assertUserNameColumn(Arrays.asList("anteater", "antoinette", "anton", "antone"));
        this.resetFilterBy(USER_NAME_FILTER);
        this.assertUserNameColumn(EVERYONE);
        this.filterBy(FULL_NAME_FILTER, "a");
        this.assertUserNameColumn(EVERYONE);
        this.filterBy(FULL_NAME_FILTER, "an");
        this.assertUserNameColumn(Arrays.asList("anteater", "antoinette", "anton", "antone", "detkin"));
        this.resetFilterBy(FULL_NAME_FILTER);
        this.filterBy(USER_NAME_FILTER, "d");
        this.assertUserNameColumn(Arrays.asList("admin", "detkin"));
        this.filterBy(USER_NAME_FILTER, "d");
        this.filterBy(FULL_NAME_FILTER, "an");
        this.filterBy(EMAIL_FILTER, "atlassian");
        this.assertUserNameColumn(Arrays.asList("detkin"));
    }

    public void testPaging() {
        this.administration.restoreData("TestUserBrowserManyUsers.xml");
        this.gotoUserBrowser();
        this.resetAll();
        this.filterBy(MAX, "10");
        this.assertUserNameColumn(this.asList(EVERYONE, this.userList(0, 2)));
        this.filterBy(MAX, "20");
        this.assertUserNameColumn(this.asList(EVERYONE, this.userList(0, 12)));
        this.filterBy(MAX, "50");
        this.assertUserNameColumn(this.asList(EVERYONE, this.userList(0, 42)));
        this.filterBy(MAX, "100");
        this.assertUserNameColumn(this.asList(EVERYONE, this.userList(0, 92)));
        this.filterBy(MAX, "All");
        this.assertUserNameColumn(this.asList(EVERYONE, this.userList(0, 120)));
        this.resetAll();
        this.filterBy(USER_NAME_FILTER, "username");
        this.assertUserNameColumn(this.userList(0, 19));
        this.gotoNext();
        this.assertUserNameColumn(this.userList(20, 39));
        this.gotoPrev();
        this.assertUserNameColumn(this.userList(0, 19));
        this.gotoNext();
        this.gotoNext();
        this.assertUserNameColumn(this.userList(40, 59));
        this.gotoPrev();
        this.assertUserNameColumn(this.userList(20, 39));
        this.resetAll();
        this.filterBy(USER_NAME_FILTER, "username");
        this.filterBy(EMAIL_FILTER, "odd");
        this.assertUserNameColumn(this.userListBy2(1, 39));
        this.gotoNext();
        this.assertUserNameColumn(this.userListBy2(41, 79));
        this.gotoNext();
        this.assertUserNameColumn(this.userListBy2(81, 119));
        this.gotoPrev();
        this.assertUserNameColumn(this.userListBy2(41, 79));
        this.gotoPrev();
        this.assertUserNameColumn(this.userListBy2(1, 39));
    }

    private void gotoPrev() {
        this.tester.clickLinkWithText("<< Previous");
    }

    private void gotoNext() {
        this.tester.clickLinkWithText("Next >>");
    }

    private List<String> userList(int startI, int endI) {
        return this.userListBy(startI, endI, 1);
    }

    private List<String> userListBy2(int startI, int endI) {
        return this.userListBy(startI, endI, 2);
    }

    private List<String> userListBy(int startI, int endI, int by) {
        ArrayList<String> users = new ArrayList<String>();
        for (int i = startI; i <= endI; i += by) {
            String padNum = StringUtils.leftPad((String)String.valueOf(i), (int)3, (char)'0');
            users.add("username" + padNum);
        }
        return users;
    }

    private List<String> asList(List<String> ... lists) {
        ArrayList<String> list = new ArrayList<String>();
        for (List<String> args : lists) {
            list.addAll(args);
        }
        return list;
    }

    private void assertUserNameColumn(List<String> values) {
        this.assertColumnImpl(1, 1, values);
    }

    private void assertColumnImpl(int col, int startRow, List<String> values) {
        int row = startRow;
        for (String value : values) {
            XPathLocator locator = new XPathLocator(this.tester, "//table[@id='user_browser_table']//tr[" + row + "]/td[" + col + "]");
            TestUserBrowser.assertEquals((String)("Asserting user browser row[" + row + "] col[" + col + "]"), (String)value, (String)locator.getText());
            ++row;
        }
    }

    private void filterBy(String fieldName, String value) {
        if (MAX.equals(fieldName)) {
            this.tester.selectOption(fieldName, value);
        } else {
            this.tester.setFormElement(fieldName, value);
        }
        this.tester.submit("");
    }

    private void resetAll() {
        this.resetFilterBy(USER_NAME_FILTER);
        this.resetFilterBy(FULL_NAME_FILTER);
        this.resetFilterBy(EMAIL_FILTER);
        this.filterBy(MAX, "20");
    }

    private void resetFilterBy(String fieldName) {
        this.tester.setFormElement(fieldName, "");
        this.tester.submit("");
    }

    private void gotoUserBrowser() {
        this.tester.gotoPage("secure/admin/user/UserBrowser.jspa");
    }
}

