/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ProjectRole;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.ProjectRoleClient;
import com.meterware.httpunit.WebTable;
import java.util.Map;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ROLES, Category.USERS_AND_GROUPS})
public class TestGroupToRoleMappingTool
extends JIRAWebTest {
    private static final String DEFAULT_PERMISSION_SCHEME_DESC = "This is the default Permission Scheme. Any new projects that are created will be assigned this scheme";
    private static final String HOMOSAPIEN_PERMISSION_SCHEME_DESC = "This is the homo Permission Scheme. Any new projects that are created will be assigned this scheme";
    private static final String WARNING_USE_PERMISSION_DETAILS = "Note: The following group(s) are groups to which new JIRA users are automatically added. For ease of maintenance, it is recommended that you do not map these groups to project roles.";
    private static final String WARNING_USE_PERMISSION_PREVIEW = "Warning: The following group(s) are groups to which new JIRA users are automatically added. For ease of maintenance, it is recommended that you do not include these groups in the transformation.";
    private static final int USE_PERMISSION_CODE = 1;

    public TestGroupToRoleMappingTool(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestGroupToRoleMappingTool.xml");
    }

    public void testAssociatedUnassociatedSchemeSelect() {
        this.gotoPage("secure/admin/SchemePicker!default.jspa");
        this.assertTextPresent("Default Permission Scheme");
        this.assertTextPresent("Homosapien Permission Scheme");
        this.assertTextNotPresent("Unassociated Permission Scheme");
        this.gotoPage("secure/admin/SchemePicker!switch.jspa?typeOfSchemesToDisplay=associated&selectedSchemeType=NotificationScheme");
        this.assertTextPresent("Default Notification Scheme");
        this.assertTextPresent("Homosapien Notification Scheme");
        this.assertTextNotPresent("Unassociated Notification Scheme");
        this.gotoPage("secure/admin/SchemePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=PermissionScheme");
        this.assertTextPresent("Default Permission Scheme");
        this.assertTextPresent("Homosapien Permission Scheme");
        this.assertTextPresent("Unassociated Permission Scheme");
        this.gotoPage("secure/admin/SchemePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
        this.assertTextPresent("Default Notification Scheme");
        this.assertTextPresent("Homosapien Notification Scheme");
        this.assertTextPresent("Unassociated Notification Scheme");
    }

    public void testGroupToRoleMappingScreen() {
        this.gotoPage("secure/admin/SchemePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=PermissionScheme");
        this.selectMultiOptionByValue("selectedSchemeIds", "0");
        this.selectMultiOptionByValue("selectedSchemeIds", "10000");
        this.selectMultiOptionByValue("selectedSchemeIds", "10010");
        this.submit("Map Groups to Roles");
        this.assertTextPresent("jira-administrators");
        this.assertTextPresent("jira-developers");
        this.assertTextPresent("jira-users");
        this.assertTextPresent("homosapien-users");
        this.assertTextPresent("Administrators");
        this.assertTextPresent("Developers");
        this.assertTextPresent("Users");
        this.assertTextPresent("Do not map group");
    }

    public void testGroupToRoleMappingPreview() throws SAXException {
        this.gotoPage("secure/admin/SchemePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=PermissionScheme");
        this.selectMultiOptionByValue("selectedSchemeIds", "0");
        this.selectMultiOptionByValue("selectedSchemeIds", "10000");
        this.selectMultiOptionByValue("selectedSchemeIds", "10010");
        this.submit("Map Groups to Roles");
        this.selectOption("homosapien-users_project_role", "Users");
        this.selectOption("jira-administrators_project_role", "Administrators");
        this.selectOption("jira-developers_project_role", "Developers");
        this.selectOption("jira-users_project_role", "Users");
        this.submit("Preview Mappings");
        this.assertTextPresent("3 scheme(s)");
        WebTable tableWithID = this.getDialog().getResponse().getTableWithID("group_to_role_mappings");
        String groupName = tableWithID.getCellAsText(0, 0).trim();
        String roleName = tableWithID.getCellAsText(0, 2).trim();
        TestGroupToRoleMappingTool.assertEquals((String)groupName, (String)"jira-administrators");
        TestGroupToRoleMappingTool.assertEquals((String)roleName, (String)"Administrators");
        groupName = tableWithID.getCellAsText(1, 0).trim();
        roleName = tableWithID.getCellAsText(1, 2).trim();
        TestGroupToRoleMappingTool.assertEquals((String)groupName, (String)"jira-developers");
        TestGroupToRoleMappingTool.assertEquals((String)roleName, (String)"Developers");
        groupName = tableWithID.getCellAsText(2, 0).trim();
        roleName = tableWithID.getCellAsText(2, 2).trim();
        TestGroupToRoleMappingTool.assertTrue(("homosapien-users".equals(groupName) || "jira-users".equals(groupName) ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertEquals((String)roleName, (String)"Users");
        groupName = tableWithID.getCellAsText(4, 0).trim();
        roleName = tableWithID.getCellAsText(4, 2).trim();
        TestGroupToRoleMappingTool.assertTrue(("homosapien-users".equals(groupName) || "jira-users".equals(groupName) ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertEquals((String)roleName, (String)"Users");
        this.assertTextPresent("3 project(s)");
        WebTable projectTableWithID = this.getDialog().getResponse().getTableWithID("Chimps_summary");
        String adminUsers = projectTableWithID.getCellAsText(1, 1);
        String devUsers = projectTableWithID.getCellAsText(2, 1);
        String userUsers = projectTableWithID.getCellAsText(3, 1);
        TestGroupToRoleMappingTool.assertTrue((adminUsers.indexOf("Administrator") != -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((devUsers.indexOf("Administrator") != -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((devUsers.indexOf("Barney Rubble") != -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((userUsers.indexOf("Administrator") != -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((userUsers.indexOf("Fred Normal") != -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((userUsers.indexOf("Dino Flintstone") != -1 ? 1 : 0) != 0);
        projectTableWithID = this.getDialog().getResponse().getTableWithID("monkey_summary");
        adminUsers = projectTableWithID.getCellAsText(1, 1);
        devUsers = projectTableWithID.getCellAsText(2, 1);
        userUsers = projectTableWithID.getCellAsText(3, 1);
        TestGroupToRoleMappingTool.assertTrue((adminUsers.indexOf("Administrator") != -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((devUsers.indexOf("Administrator") != -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((devUsers.indexOf("Barney Rubble") != -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((userUsers.indexOf("Administrator") != -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((userUsers.indexOf("Fred Normal") != -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((userUsers.indexOf("Dino Flintstone") != -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((userUsers.indexOf("Wilma Flintstone") == -1 ? 1 : 0) != 0);
        projectTableWithID = this.getDialog().getResponse().getTableWithID("homosapien_summary");
        adminUsers = projectTableWithID.getCellAsText(1, 1);
        devUsers = projectTableWithID.getCellAsText(2, 1);
        userUsers = projectTableWithID.getCellAsText(3, 1);
        TestGroupToRoleMappingTool.assertTrue((adminUsers.indexOf("Administrator") != -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((devUsers.indexOf("Administrator") != -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((devUsers.indexOf("Barney Rubble") != -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((userUsers.indexOf("Fred Normal") == -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((userUsers.indexOf("Dino Flintstone") != -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((userUsers.indexOf("Wilma Flintstone") != -1 ? 1 : 0) != 0);
        TestGroupToRoleMappingTool.assertTrue((userUsers.indexOf("Administrator") == -1 ? 1 : 0) != 0);
    }

    public void testNoSelectedSchemes() {
        this.gotoPage("secure/admin/SchemePicker!default.jspa");
        this.submit("Map Groups to Roles");
        this.assertTextPresent("You need to select schemes to be able to perform a mapping.");
    }

    public void testNoGroupToRoleMappings() {
        this.gotoPage("secure/admin/SchemePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=PermissionScheme");
        this.selectMultiOptionByValue("selectedSchemeIds", "0");
        this.submit("Map Groups to Roles");
        this.submit("Preview Mappings");
        this.assertTextPresent("You must select at least one group to role mapping to proceed with this wizard.");
        this.assertSubmitButtonPresent("Preview Mappings");
    }

    public void testSelectedNotificationSchemes() {
        this.gotoPage("secure/admin/SchemePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
        this.selectMultiOptionByValue("selectedSchemeIds", "10010");
        this.selectMultiOptionByValue("selectedSchemeIds", "10011");
        this.submit("Map Groups to Roles");
        this.assertTextPresent("There are no groups in the selected schemes.");
        this.assertSubmitButtonNotPresent("Preview Mappings");
    }

    public void testPersistMappingsPermissionSchemes() throws SAXException {
        this.gotoPage("secure/admin/SchemePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=PermissionScheme");
        this.selectMultiOptionByValue("selectedSchemeIds", "0");
        this.selectMultiOptionByValue("selectedSchemeIds", "10000");
        this.selectMultiOptionByValue("selectedSchemeIds", "10010");
        this.submit("Map Groups to Roles");
        this.selectOption("homosapien-users_project_role", "Users");
        this.selectOption("jira-administrators_project_role", "Administrators");
        this.selectOption("jira-developers_project_role", "Developers");
        this.selectOption("jira-users_project_role", "Users");
        this.submit("Preview Mappings");
        this.submit("Save");
        this.assertTextPresent("3 scheme(s)");
        this.assertTextPresentBeforeText("Default Permission Scheme", "Backup of Default Permission Scheme");
        this.assertTextPresentBeforeText("Homosapien Permission Scheme", "Backup of Homosapien Permission Scheme");
        this.assertTextPresentBeforeText("Unassociated Permission Scheme", "Backup of Unassociated Permission Scheme");
        this.clickLink("delete_tool");
        this.assertTextPresent("Bulk Delete Schemes: Select Schemes");
        this.assertTextPresent("Backup of Unassociated Permission Scheme");
        this.clickLink("permission_schemes");
        WebTable schemesTableWithID = this.getDialog().getResponse().getTableWithID("permission_schemes_table");
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 1, 0, "Backup of Default Permission Scheme"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 1, 0, DEFAULT_PERMISSION_SCHEME_DESC));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 1, 1, "Chimp"));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 1, 1, "monkey"));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 1, 1, "homosapien"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 2, 0, "Backup of Homosapien Permission Scheme"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 2, 0, HOMOSAPIEN_PERMISSION_SCHEME_DESC));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 2, 1, "Chimp"));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 2, 1, "monkey"));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 2, 1, "homosapien"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 3, 0, "Backup of Unassociated Permission Scheme"));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 3, 1, "Chimp"));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 3, 1, "monkey"));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 3, 1, "homosapien"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 4, 0, "Default Permission Scheme"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 4, 0, DEFAULT_PERMISSION_SCHEME_DESC));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 4, 1, "Chimp"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 4, 1, "monkey"));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 4, 1, "homosapien"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 5, 0, "Homosapien Permission Scheme"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 5, 0, HOMOSAPIEN_PERMISSION_SCHEME_DESC));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 5, 1, "Chimp"));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 5, 1, "monkey"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 5, 1, "homosapien"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 6, 0, "Unassociated Permission Scheme"));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 6, 1, "Chimp"));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 6, 1, "monkey"));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 6, 1, "homosapien"));
        this.clickLink("0_edit");
        this.assertTextNotPresentInPermissionsTables("Administrators");
        this.assertTextNotPresentInPermissionsTables("Developers");
        this.clickLinkWithText("permission schemes");
        this.clickLinkWithText("Default Permission Scheme", 1);
        this.assertTextInTable("edit_project_permissions", "Project Role");
        this.assertTextInTable("edit_votersandwatchers_permissions", "unmapped-group");
        this.assertTextNotPresentInPermissionsTables("jira-administrators");
        this.assertTextNotPresentInPermissionsTables("jira-developers");
        this.assertTextNotPresentInPermissionsTables("jira-users");
        ProjectRoleClient prc = new ProjectRoleClient(this.environmentData);
        Map roles = prc.get("CHM");
        TestGroupToRoleMappingTool.assertEquals((int)3, (int)roles.size());
        ProjectRole projectRole = prc.get("CHM", "Administrators");
        TestGroupToRoleMappingTool.assertEquals((int)1, (int)projectRole.actors.size());
        TestGroupToRoleMappingTool.assertEquals((String)"admin", (String)projectRole.actors.get((int)0).name);
        projectRole = prc.get("CHM", "Developers");
        TestGroupToRoleMappingTool.assertEquals((int)2, (int)projectRole.actors.size());
        TestGroupToRoleMappingTool.assertEquals((String)"admin", (String)projectRole.actors.get((int)0).name);
        TestGroupToRoleMappingTool.assertEquals((String)"barney", (String)projectRole.actors.get((int)1).name);
        projectRole = prc.get("CHM", "Users");
        TestGroupToRoleMappingTool.assertEquals((int)3, (int)projectRole.actors.size());
        TestGroupToRoleMappingTool.assertEquals((String)"admin", (String)projectRole.actors.get((int)0).name);
        TestGroupToRoleMappingTool.assertEquals((String)"dino", (String)projectRole.actors.get((int)1).name);
        TestGroupToRoleMappingTool.assertEquals((String)"fred", (String)projectRole.actors.get((int)2).name);
        roles = prc.get("MKY");
        TestGroupToRoleMappingTool.assertEquals((int)3, (int)roles.size());
        projectRole = prc.get("MKY", "Administrators");
        TestGroupToRoleMappingTool.assertEquals((int)1, (int)projectRole.actors.size());
        TestGroupToRoleMappingTool.assertEquals((String)"admin", (String)projectRole.actors.get((int)0).name);
        projectRole = prc.get("MKY", "Developers");
        TestGroupToRoleMappingTool.assertEquals((int)2, (int)projectRole.actors.size());
        TestGroupToRoleMappingTool.assertEquals((String)"admin", (String)projectRole.actors.get((int)0).name);
        TestGroupToRoleMappingTool.assertEquals((String)"barney", (String)projectRole.actors.get((int)1).name);
        projectRole = prc.get("MKY", "Users");
        TestGroupToRoleMappingTool.assertEquals((int)3, (int)projectRole.actors.size());
        TestGroupToRoleMappingTool.assertEquals((String)"admin", (String)projectRole.actors.get((int)0).name);
        TestGroupToRoleMappingTool.assertEquals((String)"dino", (String)projectRole.actors.get((int)1).name);
        TestGroupToRoleMappingTool.assertEquals((String)"fred", (String)projectRole.actors.get((int)2).name);
        roles = prc.get("HSP");
        TestGroupToRoleMappingTool.assertEquals((int)3, (int)roles.size());
        projectRole = prc.get("HSP", "Administrators");
        TestGroupToRoleMappingTool.assertEquals((int)1, (int)projectRole.actors.size());
        TestGroupToRoleMappingTool.assertEquals((String)"admin", (String)projectRole.actors.get((int)0).name);
        projectRole = prc.get("HSP", "Developers");
        TestGroupToRoleMappingTool.assertEquals((int)2, (int)projectRole.actors.size());
        TestGroupToRoleMappingTool.assertEquals((String)"admin", (String)projectRole.actors.get((int)0).name);
        TestGroupToRoleMappingTool.assertEquals((String)"barney", (String)projectRole.actors.get((int)1).name);
        projectRole = prc.get("HSP", "Users");
        TestGroupToRoleMappingTool.assertEquals((int)2, (int)projectRole.actors.size());
        TestGroupToRoleMappingTool.assertEquals((String)"dino", (String)projectRole.actors.get((int)0).name);
        TestGroupToRoleMappingTool.assertEquals((String)"wilma", (String)projectRole.actors.get((int)1).name);
    }

    private void assertTextNotPresentInPermissionsTables(String text) {
        this.assertTextNotInTable("edit_project_permissions", text);
        this.assertTextNotInTable("edit_issue_permissions", text);
        this.assertTextNotInTable("edit_attachments_permissions", text);
        this.assertTextNotInTable("edit_comments_permissions", text);
        this.assertTextNotInTable("edit_votersandwatchers_permissions", text);
        this.assertTextNotInTable("edit_timetracking_permissions", text);
    }

    public void testPersistMappingsNotificationSchemes() throws SAXException {
        this.gotoPage("secure/admin/SchemePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
        this.selectMultiOptionByValue("selectedSchemeIds", "10000");
        this.submit("Map Groups to Roles");
        this.selectOption("jira-administrators_project_role", "Administrators");
        this.submit("Preview Mappings");
        this.submit("Save");
        this.assertTextPresent("1 scheme(s)");
        this.assertTextPresentBeforeText("Default Notification Scheme", "Backup of Default Notification Scheme");
        this.assertTextNotPresent("Homosapien Notification Scheme");
        this.assertTextNotPresent("Unassociated Notification Scheme");
        this.clickLink("merge_tool");
        this.assertTextPresent("Merge Schemes: Select Schemes");
        this.clickLink("notification_schemes");
        WebTable schemesTableWithID = this.getDialog().getResponse().getTableWithID("notification_schemes");
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 1, 0, "Backup of Default Notification Scheme"));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 1, 1, "Chimp"));
        TestGroupToRoleMappingTool.assertFalse((boolean)this.tableCellHasText(schemesTableWithID, 1, 1, "monkey"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 2, 0, "Default Notification Scheme"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 2, 1, "Chimp"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(schemesTableWithID, 2, 1, "monkey"));
        this.clickLink("10020_edit");
        this.assertTextNotPresent("(jira-administrators)");
        this.assertTextPresent("(Administrators)");
    }

    public void testBackupOfBackupOfNamedCorrectly() {
        this.gotoPage("secure/admin/SchemePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
        this.selectMultiOptionByValue("selectedSchemeIds", "10000");
        this.submit("Map Groups to Roles");
        this.selectOption("jira-administrators_project_role", "Administrators");
        this.submit("Preview Mappings");
        this.submit("Save");
        this.assertTextPresent("1 scheme(s)");
        this.clickLink("notification_schemes");
        this.assertTextPresent("Backup of Default Notification Scheme");
        this.gotoPage("secure/admin/SchemePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=NotificationScheme");
        this.selectMultiOptionByValue("selectedSchemeIds", "10020");
        this.submit("Map Groups to Roles");
        this.selectOption("jira-developers_project_role", "Developers");
        this.submit("Preview Mappings");
        this.submit("Save");
        this.assertTextPresent("1 scheme(s)");
        this.clickLink("notification_schemes");
        this.assertTextPresent("Backup of Default Notification Scheme (1)");
    }

    public void testMappingSchemeWithEntityGroupAnyone() {
        this.gotoPage("secure/admin/SchemePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=PermissionScheme");
        this.selectMultiOptionByValue("selectedSchemeIds", "0");
        this.submit("Map Groups to Roles");
        this.selectOption("unmapped-group_project_role", "Users");
        this.selectOption("jira-administrators_project_role", "Administrators");
        this.selectOption("jira-developers_project_role", "Developers");
        this.selectOption("jira-users_project_role", "Users");
        this.assertTextNotPresent("Anyone");
    }

    public void testGroupToRoleMapperWithNoSession() {
        this.gotoPage("secure/admin/SchemeGroupToRoleMapper!default.jspa?selectedSchemeType=PermissionScheme");
        this.assertTextPresentOnlyOnce("You do not have any selected schemes to map groups to roles. Please start the wizard again.");
        this.assertSubmitButtonNotPresent("Preview Mappings");
        this.gotoPage("secure/admin/SchemeGroupToRoleMapper!default.jspa?selectedSchemeType=NotificationScheme");
        this.assertTextPresentOnlyOnce("You do not have any selected schemes to map groups to roles. Please start the wizard again.");
        this.assertSubmitButtonNotPresent("Preview Mappings");
        this.gotoPage("secure/admin/SchemeGroupToRoleMapper.jspa");
        this.assertTextPresentOnlyOnce("You do not have any selected schemes to map groups to roles. Please start the wizard again.");
        this.assertSubmitButtonNotPresent("Preview Mappings");
    }

    public void testGroupToRoleTransformerWithNoSession() {
        this.gotoPage("secure/admin/SchemeGroupToRoleTransformer!default.jspa?selectedSchemeType=PermissionScheme");
        this.assertTextPresentOnlyOnce("No schemes were selected to map groups to roles. Please start the wizard again.");
        this.assertSubmitButtonNotPresent("Save");
        this.gotoPage("secure/admin/SchemeGroupToRoleTransformer!default.jspa?selectedSchemeType=NotificationScheme");
        this.assertTextPresentOnlyOnce("No schemes were selected to map groups to roles. Please start the wizard again.");
        this.assertSubmitButtonNotPresent("Save");
        this.gotoPage("secure/admin/SchemeGroupToRoleTransformer.jspa");
        this.assertTextPresentOnlyOnce("No schemes were selected to map groups to roles. Please start the wizard again.");
        this.assertSubmitButtonNotPresent("Save");
    }

    public void testGroupToRoleTransformerSomeWithGlobalUsePermission() throws SAXException {
        this.gotoPage("secure/admin/SchemePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=PermissionScheme");
        this.selectMultiOptionByValue("selectedSchemeIds", "0");
        this.submit("Map Groups to Roles");
        this.assertTextPresent(WARNING_USE_PERMISSION_DETAILS);
        WebTable noPermTable = this.getDialog().getResponse().getTableWithID("group_to_role_mappings_no_use_permission");
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(noPermTable, 1, 0, "jira-administrators"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(noPermTable, 2, 0, "jira-developers"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(noPermTable, 3, 0, "unmapped-group"));
        WebTable hasPermTable = this.getDialog().getResponse().getTableWithID("group_to_role_mappings_use_permission");
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(hasPermTable, 1, 0, "jira-users"));
        this.selectOption("jira-administrators_project_role", "Developers");
        this.selectOption("jira-developers_project_role", "Developers");
        this.selectOption("unmapped-group_project_role", "Developers");
        this.selectOption("jira-users_project_role", "Developers");
        this.submit("Preview Mappings");
        this.assertTextPresent("Map Groups to Project Roles: Preview Transformation for Schemes");
        this.assertTextSequence(new String[]{"jira-administrators", "jira-developers", "unmapped-group", WARNING_USE_PERMISSION_PREVIEW, "jira-users"});
        this.submit("Save");
    }

    public void testGroupToRoleTransformerAllWithGlobalUsePermission() throws SAXException {
        this.grantGlobalPermission(1, "jira-developers");
        this.grantGlobalPermission(1, "unmapped-group");
        this.gotoPage("secure/admin/SchemePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=PermissionScheme");
        this.selectMultiOptionByValue("selectedSchemeIds", "0");
        this.submit("Map Groups to Roles");
        this.assertTextPresent("Map Groups to Project Roles: Select Mappings");
        WebTable noPermTable = this.getDialog().getResponse().getTableWithID("group_to_role_mappings_no_use_permission");
        TestGroupToRoleMappingTool.assertNotNull((Object)noPermTable);
        WebTable hasPermTable = this.getDialog().getResponse().getTableWithID("group_to_role_mappings_use_permission");
        TestGroupToRoleMappingTool.assertNotNull((Object)hasPermTable);
        this.assertTextSequence(new String[]{WARNING_USE_PERMISSION_DETAILS, "jira-developers", "jira-users", "unmapped-group"});
        this.selectOption("jira-administrators_project_role", "Developers");
        this.selectOption("jira-developers_project_role", "Developers");
        this.selectOption("jira-users_project_role", "Developers");
        this.selectOption("unmapped-group_project_role", "Developers");
        this.submit("Preview Mappings");
        this.assertTextPresent("Map Groups to Project Roles: Preview Transformation for Schemes");
        this.assertTextSequence(new String[]{WARNING_USE_PERMISSION_PREVIEW, "jira-developers", "jira-users", "unmapped-group"});
    }

    public void testGroupToRoleTransformerNoneWithGlobalUsePermission() throws SAXException {
        this.gotoPage("secure/admin/SchemePicker!switch.jspa?typeOfSchemesToDisplay=all&selectedSchemeType=PermissionScheme");
        this.selectMultiOptionByValue("selectedSchemeIds", "10000");
        this.submit("Map Groups to Roles");
        this.assertTextPresent("Map Groups to Project Roles: Select Mappings");
        this.assertTextNotPresent(WARNING_USE_PERMISSION_DETAILS);
        WebTable noPermTable = this.getDialog().getResponse().getTableWithID("group_to_role_mappings_no_use_permission");
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(noPermTable, 1, 0, "homosapien-users"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(noPermTable, 2, 0, "jira-administrators"));
        TestGroupToRoleMappingTool.assertTrue((boolean)this.tableCellHasText(noPermTable, 3, 0, "jira-developers"));
        WebTable hasPermTable = this.getDialog().getResponse().getTableWithID("group_to_role_mappings_use_permission");
        TestGroupToRoleMappingTool.assertNull((Object)hasPermTable);
        this.selectOption("homosapien-users_project_role", "Developers");
        this.selectOption("jira-administrators_project_role", "Developers");
        this.selectOption("jira-developers_project_role", "Developers");
        this.submit("Preview Mappings");
        this.assertTextPresent("Map Groups to Project Roles: Preview Transformation for Schemes");
        this.assertTextSequence(new String[]{"homosapien-users", "jira-administrators", "jira-developers"});
        this.assertTextNotPresent(WARNING_USE_PERMISSION_PREVIEW);
        this.submit("Save");
    }
}

