/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.PERMISSIONS, Category.USERS_AND_GROUPS})
public class TestGroupSelectorPermissions
extends JIRAWebTest {
    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("GroupSelectorPermissions.xml");
        this.administration.attachments().enable();
    }

    public TestGroupSelectorPermissions(String name) {
        super(name);
    }

    public void testWorkflowPermissions() {
        TestGroupSelectorPermissions.logSection("Testing group permission selector");
        TestGroupSelectorPermissions.log("Testing that 'GroupRadio' selection (helpdesk) can comment, can't attach");
        this.login("helpdesk", "helpdesk");
        this.gotoIssue("NP-1");
        this.assertLinkPresent("comment-issue");
        this.assertLinkNotPresent("attach-file");
        this.assertLinkNotPresent("delete-issue");
        this.assertLinkNotPresent("move-issue");
        TestGroupSelectorPermissions.log("Check that webadmin users cannot do anything");
        this.login("webadmin", "webadmin");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("comment-issue");
        this.assertLinkNotPresent("attach-file");
        this.assertLinkNotPresent("delete-issue");
        this.assertLinkNotPresent("move-issue");
        TestGroupSelectorPermissions.log("Check that unixadmin users cannot do anything");
        this.login("unixadmin", "unixadmin");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("comment-issue");
        this.assertLinkNotPresent("attach-file");
        this.assertLinkNotPresent("delete-issue");
        this.assertLinkNotPresent("move-issue");
        TestGroupSelectorPermissions.log("Testing that regular users can't comment, can't attach");
        this.login("test", "test");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("comment-issue");
        this.assertLinkNotPresent("attach-file");
        this.assertLinkNotPresent("delete-issue");
        this.assertLinkNotPresent("move-issue");
        this.login("dba", "dba");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("comment-issue");
        this.assertLinkNotPresent("attach-file");
        this.assertLinkNotPresent("delete-issue");
        this.assertLinkNotPresent("move-issue");
        TestGroupSelectorPermissions.log("Editing fields: setting GroupRadio (comment perm) to WebAdmin, and 'Assigned Groups' (attach perm) to helpdesk");
        this.gotoIssue("NP-1");
        this.clickLink("editIssue");
        this.assertOptionValuesEqual("customfield_10010", new String[]{"-1", "10000", "10001", "10002", "10003"});
        this.assertOptionValuesEqual("customfield_10030", new String[]{"-1", "10020", "10021", "10022", "10023"});
        this.assertOptionValuesEqual("customfield_10040", new String[]{"10030", "10031", "10032", "10033"});
        this.assertOptionValuesEqual("customfield_10041", new String[]{"-1", "10034", "10035", "10036", "10037"});
        this.selectOption("customfield_10010", "help-desk-group");
        this.checkCheckbox("customfield_10030", "10023");
        this.setFormElement("customfield_10040", "10030");
        this.selectOption("customfield_10041", "unix-admin-group");
        this.submit();
        this.assertTextPresentBeforeText("Assigned Groups:", "help-desk-group");
        this.assertTextPresentBeforeText("GroupRadio:", "webadmin-group");
        this.assertTextPresentBeforeText("Multi Checkboxes:", "dba-user-group");
        this.assertTextPresentBeforeText("Select List:", "unix-admin-group");
        TestGroupSelectorPermissions.log("Testing that 'GroupRadio' selection (now webadmin) can comment, can't attach");
        this.login("webadmin", "webadmin");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("attach-file");
        this.assertLinkPresent("comment-issue");
        this.assertLinkNotPresent("delete-issue");
        this.assertLinkNotPresent("move-issue");
        TestGroupSelectorPermissions.log("Testing that helpdesk can no longer comment, but can attach");
        this.login("helpdesk", "helpdesk");
        this.gotoIssue("NP-1");
        this.assertLinkPresent("attach-file");
        this.assertLinkNotPresent("comment-issue");
        this.assertLinkNotPresent("delete-issue");
        this.assertLinkNotPresent("move-issue");
        TestGroupSelectorPermissions.log("Check that DBA can delete issues");
        this.login("dba", "dba");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("attach-file");
        this.assertLinkNotPresent("comment-issue");
        this.assertLinkNotPresent("delete-issue");
        this.assertLinkPresent("move-issue");
        TestGroupSelectorPermissions.log("Check that Unix admin can move issues");
        this.login("unixadmin", "unixadmin");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("attach-file");
        this.assertLinkNotPresent("comment-issue");
        this.assertLinkPresent("delete-issue");
        this.assertLinkNotPresent("move-issue");
    }
}

