/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.HttpUnitOptions;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestGroupSelector
extends FuncTestCase {
    public static final String GROUP_PICKER_CF_NAME = "mypickerofgroups";
    public static final String INVALID_GROUP_NAME = "invalid_group_name";
    public static final String ISSUE_SUMMARY = "This is my summary";
    private String groupPickerId = null;

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.groupPickerId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:grouppicker", GROUP_PICKER_CF_NAME);
    }

    public void testCreateIssueWithGroupPicker() {
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", ISSUE_SUMMARY);
        this.tester.assertLinkPresent(this.groupPickerId + "-trigger");
        this.tester.setFormElement(this.groupPickerId, INVALID_GROUP_NAME);
        this.tester.submit("Create");
        this.text.assertTextPresentHtmlEncoded("Could not find group with name 'invalid_group_name'");
        this.tester.setFormElement(this.groupPickerId, "jira-users");
        this.tester.submit("Create");
        this.text.assertTextPresent(this.locator.page(), ISSUE_SUMMARY);
        this.text.assertTextPresent(this.locator.page(), GROUP_PICKER_CF_NAME);
        this.tester.assertLinkPresentWithText("jira-users");
    }

    public void testIssueNavWithGroupPicker() {
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", ISSUE_SUMMARY);
        this.tester.setFormElement(this.groupPickerId, "jira-users");
        this.tester.submit("Create");
        this.navigation.issueNavigator().gotoNavigator();
        this.text.assertTextPresent(this.locator.page(), GROUP_PICKER_CF_NAME);
        this.tester.assertLinkPresent("searcher-" + this.groupPickerId + "-trigger");
        this.tester.setFormElement(this.groupPickerId, INVALID_GROUP_NAME);
        this.tester.submit("show");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("Could not find group with name 'invalid_group_name'");
        this.text.assertTextPresent(this.locator.page(), "There are errors with your search query on the left, please correct them before continuing.");
        this.tester.setFormElement(this.groupPickerId, "jira-users");
        this.tester.submit("show");
        this.text.assertTextPresent(this.locator.page(), "HSP-1");
    }
}

