/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.Arrays;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestDeleteUserSharedEntities
extends FuncTestCase {
    private static final SharedEntityInfo SYSTEM_PAGE = new SharedEntityInfo(10000L, "System Dashboard", null, true, TestSharingPermissionUtils.createPublicPermissions());
    private static final SharedEntityInfo DASHBOARD_2 = new SharedEntityInfo(10011L, "Dashboard 2", null, true, TestSharingPermissionUtils.createPublicPermissions());
    private static final SharedEntityInfo DASHBOARD_FOR_ADMIN = new SharedEntityInfo(10010L, "Dashboard for Administrator", "Copy of 'System Dashboard'", true, TestSharingPermissionUtils.createPublicPermissions());

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestDeleteUserForSharedEntity.xml");
    }

    public void testDeleteUser() {
        this.administration.usersAndGroups().deleteUserConfirm("fred");
        XPathLocator locator = new XPathLocator(this.tester, "//span[@id='numberOfFilters']");
        TestDeleteUserSharedEntities.assertEquals((String)"3", (String)locator.getText().trim());
        locator = new XPathLocator(this.tester, "//span[@id='numberOfOtherFavouritedFilters']");
        TestDeleteUserSharedEntities.assertEquals((String)"2", (String)locator.getText().trim());
        locator = new XPathLocator(this.tester, "//span[@id='numberOfNonPrivatePortalPages']");
        TestDeleteUserSharedEntities.assertEquals((String)"3", (String)locator.getText().trim());
        locator = new XPathLocator(this.tester, "//span[@id='numberOfOtherFavouritedPortalPages']");
        TestDeleteUserSharedEntities.assertEquals((String)"2", (String)locator.getText().trim());
        this.tester.submit("Delete");
        this.navigation.dashboard().navigateToPopular();
        SYSTEM_PAGE.setFavCount(1);
        DASHBOARD_2.setFavCount(1);
        DASHBOARD_FOR_ADMIN.setFavCount(1);
        this.assertions.getDashboardAssertions().assertDashboardPages(Arrays.asList(DASHBOARD_2, DASHBOARD_FOR_ADMIN, SYSTEM_PAGE), Dashboard.Table.POPULAR);
        this.navigation.manageFilters().popularFilters();
        this.text.assertTextPresent(new WebPageLocator(this.tester), "There are no filters in the system that you can view.");
    }
}

