/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestDeleteGroup
extends JIRAWebTest {
    private static final String ADMIN_GROUP_2 = "jira-admin-2";
    private static final String ADMIN_USER = "admin";
    private static final String OTHER_GROUP = "jira-developers";
    private static final String ADMIN_GROUP = "jira-administrators";

    public TestDeleteGroup(String name) {
        super(name);
    }

    public void testOneAdminGroupOneNonAdminGroup() {
        this.restoreBlankInstance();
        this.attemptToDeleteGroup(ADMIN_GROUP);
        this.assertTextPresent("You cannot delete a group that grants you system administration privileges if no other group exists that also grants you system administration privileges.");
        this.attemptToDeleteGroup(OTHER_GROUP);
        this.submit("Delete");
        this.assertTextNotPresent(OTHER_GROUP);
    }

    public void testTwoAdminGroupsUserIsMemberOfOne() {
        this.restoreBlankInstance();
        this.createGroup(ADMIN_GROUP_2);
        this.grantGlobalPermission(44, ADMIN_GROUP_2);
        this.attemptToDeleteGroup(ADMIN_GROUP);
        this.assertTextPresent("You cannot delete a group that grants you system administration privileges if no other group exists that also grants you system administration privileges.");
        this.attemptToDeleteGroup(ADMIN_GROUP_2);
        this.submit("Delete");
        this.assertTextNotPresent(ADMIN_GROUP_2);
    }

    public void testTwoSysAdminGroupsUserIsMemberOfBoth() {
        this.restoreBlankInstance();
        this.createGroup(ADMIN_GROUP_2);
        this.grantGlobalPermission(44, ADMIN_GROUP_2);
        this.addUserToGroup(ADMIN_USER, ADMIN_GROUP_2);
        this.attemptToDeleteGroup(ADMIN_GROUP);
        this.submit("Delete");
        this.assertTextNotPresent(ADMIN_GROUP);
        this.attemptToDeleteGroup(ADMIN_GROUP_2);
        this.assertTextPresent("You cannot delete a group that grants you system administration privileges if no other group exists that also grants you system administration privileges.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoSysAdminGroupOneAdminGroupOneOther() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.attemptToDeleteGroup(ADMIN_GROUP);
            this.assertTextPresent("You cannot delete a group that grants you administration privileges if no other group exists that also grants you administration privileges.");
            this.attemptToDeleteGroup(OTHER_GROUP);
            this.submit("Delete");
            this.assertTextNotPresent(OTHER_GROUP);
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoSysAdminGroupTwoAdminGroupUserIsMemberOfBoth() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.createGroup(ADMIN_GROUP_2);
            this.giveAdminPermission(ADMIN_GROUP_2);
            this.addUserToGroup(ADMIN_USER, ADMIN_GROUP_2);
            this.attemptToDeleteGroup(ADMIN_GROUP);
            this.submit("Delete");
            this.assertTextNotPresent(ADMIN_GROUP);
            this.attemptToDeleteGroup(ADMIN_GROUP_2);
            this.assertTextPresent("You cannot delete a group that grants you administration privileges if no other group exists that also grants you administration privileges.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteSysAdminGroupAsAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoPage("/secure/admin/user/DeleteGroup!default.jspa?name=jira-sys-admins");
            this.assertTextPresent("Cannot delete group, only System Administrators can delete groups associated with the System Administrators global permission.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSysAdminGroupsOperationsDoNotShowToAdmins() throws SAXException {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoAdmin();
            this.clickLink("group_browser");
            WebTable groupTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
            this.assertTableCellHasText("group_browser_table", 1, 0, ADMIN_GROUP);
            this.assertTableCellHasText("group_browser_table", 1, 3, "Delete");
            this.assertTableCellHasText("group_browser_table", 1, 3, "Edit Members");
            this.assertLinkPresent("del_jira-administrators");
            this.assertLinkPresent("edit_members_of_jira-administrators");
            this.assertTableCellHasText("group_browser_table", 2, 0, OTHER_GROUP);
            this.assertTableCellHasText("group_browser_table", 2, 3, "Delete");
            this.assertTableCellHasText("group_browser_table", 2, 3, "Edit Members");
            this.assertLinkPresent("del_jira-developers");
            this.assertLinkPresent("edit_members_of_jira-developers");
            this.assertTableCellHasText("group_browser_table", 3, 0, "jira-sys-admins");
            TestDeleteGroup.assertTrue((String)"shouldn't have delete operation", (groupTable.getCellAsText(3, 3).indexOf("Delete") == -1 ? 1 : 0) != 0);
            TestDeleteGroup.assertTrue((String)"shouldn't have edit operation", (groupTable.getCellAsText(3, 3).indexOf("Edit Members") == -1 ? 1 : 0) != 0);
            this.assertLinkNotPresent("del_jira-sys-admins");
            this.assertLinkNotPresent("edit_members_of_jira-sys-admins");
            this.assertTableCellHasText("group_browser_table", 4, 0, "jira-users");
            this.assertTableCellHasText("group_browser_table", 4, 3, "Delete");
            this.assertTableCellHasText("group_browser_table", 4, 3, "Edit Members");
            this.assertLinkPresent("del_jira-users");
            this.assertLinkPresent("edit_members_of_jira-users");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    public void testDeleteGroupSwapGroup() {
        this.restoreData("TestDeleteGroupSwapGroup.xml");
        this.gotoIssue("HSP-1");
        this.assertTextPresent("Test Comment Visibility");
        this.attemptToDeleteGroup(ADMIN_GROUP);
        this.selectOption("swapGroup", "other-admins");
        this.submit("Delete");
        this.gotoIssue("HSP-1");
        this.assertTextPresent("Test Comment Visibility");
    }

    public void testDeleteGroupSwapGroupSameGroup() {
        this.restoreData("TestDeleteGroupSwapGroup.xml");
        this.gotoIssue("HSP-1");
        this.assertTextPresent("Test Comment Visibility");
        this.gotoPage(this.page.addXsrfToken("/secure/admin/user/DeleteGroup.jspa?name=jira-administrators&swapGroup=jira-administrators"));
        this.assertTextPresent("You cannot swap comments/worklogs to the group you are deleting.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteGroupAsFred() {
        this.restoreBlankInstance();
        try {
            this.getNavigation().loginUsingForm("fred", "fred");
            this.gotoPage(this.page.addXsrfToken("/secure/admin/user/DeleteGroup!default.jspa?name=jira-administrators"));
            this.assertTextPresent("my login on this computer");
        }
        finally {
            this.login(ADMIN_USER, ADMIN_USER);
        }
    }

    public void testDeleteInvalidGroup() {
        this.restoreBlankInstance();
        this.gotoPage(this.page.addXsrfToken("/secure/admin/user/DeleteGroup.jspa?name=invalid"));
        this.assertions.getJiraFormAssertions().assertFormErrMsg("The group 'invalid' is not a valid group.");
    }

    private void attemptToDeleteGroup(String groupName) {
        this.gotoAdmin();
        this.clickLink("group_browser");
        String linkId = "del_" + groupName;
        this.clickLink(linkId);
    }

    private void giveAdminPermission(String groupName) {
        this.gotoAdmin();
        this.clickLink("global_permissions");
        this.selectOption("permType", "JIRA Administrators");
        this.selectOption("groupName", groupName);
        this.submit("Add");
    }
}

