/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.locator.NodeLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebTable;
import junit.framework.Assert;
import org.w3c.dom.Node;

public class UserDirectoryTable {
    private final WebTable table;
    private final Assertions assertions;

    public UserDirectoryTable(FuncTestCase funcTestCase) {
        this.table = new TableLocator(funcTestCase.getTester(), "directory-list").getTable();
        this.assertions = funcTestCase.getAssertions();
        this.assertions.getTableAssertions().assertTableRowEqualsCollapsed(this.table, 0, new String[]{"ID", "Directory Name", "Type", "Order", "Operations"});
    }

    public TableCell getTableCell(int row, int column) {
        return this.table.getTableCell(row, column);
    }

    public RowAssertions assertRow(int rowNum) {
        return new RowAssertions(rowNum);
    }

    public class RowAssertions {
        private int rowNum;

        public RowAssertions(int rowNum) {
            this.rowNum = rowNum;
        }

        public RowAssertions contains(String id, String name, String type) {
            UserDirectoryTable.this.assertions.getTableAssertions().assertTableRowEqualsCollapsed(UserDirectoryTable.this.table, this.rowNum, new String[]{id, name, type, null, null});
            return this;
        }

        public RowAssertions hasMoveUp(boolean enabled) {
            Node cellNode = UserDirectoryTable.this.table.getTableCell(this.rowNum, 3).getDOM();
            String cellText = new NodeLocator(cellNode).getHTML();
            if (enabled) {
                Assert.assertTrue((String)("Enabled Move Up button expected. Found '" + cellText + "'"), (boolean)cellText.contains("<SPAN class=\"icon icon-move-up\">Move Up</SPAN>"));
            } else {
                Assert.assertTrue((String)("Disabled Move Up button expected. Found '" + cellText + "'"), (boolean)cellText.contains("<SPAN class=\"icon icon-move-up-disabled\">Move Up</SPAN>"));
            }
            return this;
        }

        public RowAssertions hasMoveDown(boolean enabled) {
            Node cellNode = UserDirectoryTable.this.table.getTableCell(this.rowNum, 3).getDOM();
            String cellText = new NodeLocator(cellNode).getHTML();
            if (enabled) {
                Assert.assertTrue((String)("Enabled Move Down button expected. Found '" + cellText + "'"), (boolean)cellText.contains("<SPAN class=\"icon icon-move-down\">Move Down</SPAN>"));
            } else {
                Assert.assertTrue((String)("Disabled Move Down button expected. Found '" + cellText + "'"), (boolean)cellText.contains("<SPAN class=\"icon icon-move-down-disabled\">Move Down</SPAN>"));
            }
            return this;
        }

        public void hasOnlyEditOperation() {
            String cellText = UserDirectoryTable.this.table.getCellAsText(this.rowNum, 4);
            Assert.assertTrue((String)("Edit operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Edit"));
        }

        public void hasDisableEditOperations() {
            String cellText = UserDirectoryTable.this.table.getCellAsText(this.rowNum, 4);
            Assert.assertTrue((String)("Disable operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Disable"));
            Assert.assertFalse((String)"Enable operation found but not expected.", (boolean)cellText.contains("Enable"));
            Assert.assertTrue((String)("Edit operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Edit"));
            Assert.assertFalse((String)"Synchronise operation found but not expected.", (boolean)cellText.contains("Synchronise"));
        }

        public void hasDisableEditSynchroniseOperations() {
            String cellText = UserDirectoryTable.this.table.getCellAsText(this.rowNum, 4);
            Assert.assertTrue((String)("Disable operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Disable"));
            Assert.assertFalse((String)"Enable operation found but not expected.", (boolean)cellText.contains("Enable"));
            Assert.assertTrue((String)("Edit operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Edit"));
            Assert.assertTrue((String)("Synchronise operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Synchronise"));
        }

        public void hasEnableEditRemoveSynchroniseOperations() {
            String cellText = UserDirectoryTable.this.table.getCellAsText(this.rowNum, 4);
            Assert.assertTrue((String)("Enable operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Enable"));
            Assert.assertFalse((String)"Disable operation found but not expected.", (boolean)cellText.contains("Disable"));
            Assert.assertTrue((String)("Edit operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Edit"));
            Assert.assertTrue((String)("Remove operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Remove"));
            Assert.assertTrue((String)("Synchronise operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Synchronise"));
        }

        public void hasEnableEditRemoveOperations() {
            String cellText = UserDirectoryTable.this.table.getCellAsText(this.rowNum, 4);
            Assert.assertTrue((String)("Enable operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Enable"));
            Assert.assertFalse((String)"Disable operation found but not expected.", (boolean)cellText.contains("Disable"));
            Assert.assertTrue((String)("Edit operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Edit"));
            Assert.assertTrue((String)("Remove operation not found. Found: '" + cellText + "'."), (boolean)cellText.contains("Remove"));
            Assert.assertFalse((String)"Synchronise operation found but not expected.", (boolean)cellText.contains("Synchronise"));
        }
    }
}

