/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.tpm.ldap.AbstractTpmLdapTest;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;

@WebTest(value={Category.FUNC_TEST, Category.LDAP, Category.TPM})
public class TestTpmLdapSetup
extends AbstractTpmLdapTest {
    public void testAddLdapDirectory() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection("user_directories");
        this.tester.assertTextPresent("User Directories");
        if (this.isActiveDirectory()) {
            this.log("Attempting to add an Active Directory LDAP User Directory...");
            this.addActiveDirectory();
        } else {
            this.log("Attempting to add an Open LDAP User Directory...");
            this.addOpenLdap();
        }
        WebTable table = this.assertions.getTableAssertions().getWebTable("directory-list");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 1, "JIRA Internal Directory");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 1, "LDAP Directory");
        WebTable tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        WebLink link = tblDirectoryList.getTableCell(2, 3).getLinkWith("up");
        this.navigation.clickLink(link);
        table = this.assertions.getTableAssertions().getWebTable("directory-list");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 1, "LDAP Directory");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 1, "JIRA Internal Directory");
    }

    private void addActiveDirectory() {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/ldap/");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", "LDAP Directory");
        this.tester.selectOption("type", "Microsoft Active Directory");
        this.tester.setFormElement("hostname", this.getLdapServer());
        this.tester.setFormElement("port", "636");
        this.tester.checkCheckbox("useSSL", "true");
        this.tester.setFormElement("ldapUserdn", this.getUserDn());
        this.tester.setFormElement("ldapPassword", this.getPassword());
        this.tester.setFormElement("ldapBasedn", this.getBaseDn());
        this.tester.setFormElement("ldapUserObjectclass", "user");
        this.tester.setFormElement("ldapUserFilter", "(&(objectCategory=Person)(sAMAccountName=*))");
        this.tester.setFormElement("ldapUserUsername", "sAMAccountName");
        this.tester.setFormElement("ldapUserUsernameRdn", "cn");
        this.tester.setFormElement("ldapUserFirstname", "givenName");
        this.tester.setFormElement("ldapUserLastname", "sn");
        this.tester.setFormElement("ldapUserDisplayname", "displayName");
        this.tester.setFormElement("ldapUserEmail", "mail");
        this.tester.setFormElement("ldapUserGroup", "memberOf");
        this.tester.setFormElement("ldapUserPassword", "unicodePwd");
        this.tester.setFormElement("ldapGroupObjectclass", "group");
        this.tester.setFormElement("ldapGroupFilter", "(objectCategory=Group)");
        this.tester.setFormElement("ldapGroupName", "cn");
        this.tester.setFormElement("ldapGroupDescription", "description");
        this.tester.setFormElement("ldapGroupUsernames", "member");
        this.tester.setFormElement("ldapPermissionOption", "READ_WRITE");
        this.tester.submit("test");
        this.text.assertTextPresent("Connection test successful");
        this.tester.submit("save");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.tester.assertTextPresent("JIRA Internal Directory");
        this.tester.assertTextPresent("LDAP Directory");
    }

    private void addOpenLdap() {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/ldap/");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", "LDAP Directory");
        this.tester.selectOption("type", "OpenLDAP");
        this.tester.setFormElement("hostname", this.getLdapServer());
        this.tester.setFormElement("port", "389");
        this.tester.setFormElement("ldapUserdn", this.getUserDn());
        this.tester.setFormElement("ldapBasedn", this.getBaseDn());
        this.tester.setFormElement("ldapPassword", this.getPassword());
        this.tester.setFormElement("ldapUserObjectclass", "inetorgperson");
        this.tester.setFormElement("ldapUserFilter", "(objectclass=inetorgperson)");
        this.tester.setFormElement("ldapUserUsername", "cn");
        this.tester.setFormElement("ldapUserUsernameRdn", "cn");
        this.tester.setFormElement("ldapUserFirstname", "givenName");
        this.tester.setFormElement("ldapUserLastname", "sn");
        this.tester.setFormElement("ldapUserDisplayname", "displayName");
        this.tester.setFormElement("ldapUserEmail", "mail");
        this.tester.setFormElement("ldapUserGroup", "memberOf");
        this.tester.setFormElement("ldapUserPassword", "userPassword");
        this.tester.setFormElement("ldapGroupObjectclass", "groupOfUniqueNames");
        this.tester.setFormElement("ldapGroupFilter", "(objectclass=groupOfUniqueNames)");
        this.tester.setFormElement("ldapGroupName", "cn");
        this.tester.setFormElement("ldapGroupDescription", "description");
        this.tester.setFormElement("ldapGroupUsernames", "uniqueMember");
        this.tester.setFormElement("ldapPermissionOption", "READ_WRITE");
        this.tester.submit("test");
        this.text.assertTextPresent("Connection test successful");
        this.tester.submit("save");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.tester.assertTextPresent("JIRA Internal Directory");
        this.tester.assertTextPresent("LDAP Directory");
    }
}

