/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.LDAP, Category.TPM})
public class TestTpmLdap
extends FuncTestCase {
    public void testAddAndDeleteUser() throws Exception {
        if (this.assertions.getUserAssertions().userExists("wilma")) {
            this.log("User wilma was found - attempting to clean up before running test.");
            this.deleteUser("wilma");
        }
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("add_user");
        this.tester.setFormElement("username", "wilma");
        this.tester.setFormElement("fullname", "Wilma Flintstone");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.setFormElement("email", "wilma@bedrock.com");
        this.tester.submit("Create");
        this.assertions.getUserAssertions().assertUserExists("wilma");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory");
        this.deleteUser("wilma");
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
    }

    public void testAddAndDeleteGroup() throws Exception {
        this.assertions.getUserAssertions().assertGroupDoesNotExist("newGroup");
        this.navigation.gotoAdminSection("group_browser");
        this.tester.setFormElement("addName", "newGroup");
        this.tester.submit("add_group");
        this.tester.assertTextNotPresent("Error occurred adding group");
        this.assertions.getUserAssertions().assertGroupExists("newGroup");
        this.deleteGroup("newGroup");
        this.assertions.getUserAssertions().assertGroupDoesNotExist("newGroup");
    }

    public void testLoginAsLdapUser() throws Exception {
        this.setupUserWilma();
        this.navigation.logout();
        this.navigation.loginAttempt("wilma", "fail");
        this.tester.assertTextPresent("your username and password are incorrect");
        this.navigation.login("wilma", "password");
        this.tester.clickLink("header-details-user-fullname");
        this.assertions.assertNodeByIdHasText("up-user-title-name", "Wilma Flintstone");
        this.navigation.logout();
        this.navigation.login("admin");
        this.deleteUser("wilma");
    }

    public void testEditUser() throws Exception {
        this.setupUserWilma();
        this.navigation.gotoAdminSection("user_browser");
        this.tester.setFormElement("userNameFilter", "wil");
        this.tester.submit("");
        this.tester.clickLink("edituser_link_wilma");
        this.tester.setFormElement("fullName", "Betty Rubble");
        this.tester.setFormElement("email", "betty@example.com");
        this.tester.submit("Update");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Betty Rubble", "betty@example.com", "LDAP Directory");
        this.deleteUser("wilma");
    }

    public void testAddUserToGroup() throws Exception {
        this.setupUserWilma();
        this.addGroup("cartoon-characters");
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup("wilma", "cartoon-characters");
        this.gotoViewUser("wilma");
        this.tester.clickLink("editgroups_link");
        this.tester.selectOption("groupsToJoin", "cartoon-characters");
        this.tester.submit("join");
        this.assertions.getUserAssertions().assertUserBelongsToGroup("wilma", "cartoon-characters");
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup("fred", "cartoon-characters");
        this.gotoViewUser("fred");
        this.tester.clickLink("editgroups_link");
        this.tester.selectOption("groupsToJoin", "cartoon-characters");
        this.tester.submit("join");
        this.assertions.getUserAssertions().assertUserBelongsToGroup("fred", "cartoon-characters");
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup("wilma", "jira-developers");
        this.gotoViewUser("wilma");
        this.tester.clickLink("editgroups_link");
        this.tester.selectOption("groupsToJoin", "jira-developers");
        this.tester.submit("join");
        this.assertions.getUserAssertions().assertUserBelongsToGroup("wilma", "jira-developers");
        this.deleteUser("wilma");
        this.deleteGroup("cartoon-characters");
    }

    private void setupUserWilma() {
        if (this.assertions.getUserAssertions().userExists("wilma")) {
            this.log("User wilma was found - attempting to clean up before running test.");
            this.deleteUser("wilma");
        }
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("add_user");
        this.tester.setFormElement("username", "wilma");
        this.tester.setFormElement("fullname", "Wilma Flintstone");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.setFormElement("email", "wilma@bedrock.com");
        this.tester.submit("Create");
        this.assertions.getUserAssertions().assertUserExists("wilma");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory");
    }

    private void deleteUser(String username) {
        this.gotoViewUser(username);
        this.tester.clickLink("deleteuser_link");
        this.tester.submit("Delete");
    }

    private void gotoViewUser(String username) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
    }

    private void addGroup(String name) {
        this.navigation.gotoAdminSection("group_browser");
        this.tester.setFormElement("addName", name);
        this.tester.submit("add_group");
        this.tester.assertTextNotPresent("Error occurred adding group");
        this.assertions.getUserAssertions().assertGroupExists(name);
    }

    private void deleteGroup(String name) {
        this.navigation.gotoAdminSection("group_browser");
        this.tester.setFormElement("nameFilter", name);
        this.tester.submit("");
        this.tester.clickLink("del_" + name);
        this.tester.submit("Delete");
    }
}

