/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.tpm.ldap.AbstractTpmLdapTest;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;

@WebTest(value={Category.FUNC_TEST, Category.LDAP, Category.TPM})
public class TestTpmDelegatingLdap
extends AbstractTpmLdapTest {
    public void testAddAndDeleteUser() throws Exception {
        this.disableLdapDirectory();
        this.addDelegatingLdapDirectory();
        if (this.assertions.getUserAssertions().userExists("wilma")) {
            this.log("User wilma was found - attempting to clean up before running test.");
            this.deleteUser("wilma");
        }
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("add_user");
        this.tester.setFormElement("username", "wilma");
        this.tester.setFormElement("fullname", "Wilma Flintstone");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.setFormElement("email", "wilma@bedrock.com");
        this.tester.submit("Create");
        this.assertions.getUserAssertions().assertUserExists("wilma");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "Delegating LDAP Directory");
        this.deleteUser("wilma");
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.deleteDelegatingLdapDirectory();
        this.enableLdapDirectory();
    }

    public void testAddAndDeleteGroup() throws Exception {
        this.disableLdapDirectory();
        this.addDelegatingLdapDirectory();
        this.assertions.getUserAssertions().assertGroupDoesNotExist("newGroup");
        this.navigation.gotoAdminSection("group_browser");
        this.tester.setFormElement("addName", "newGroup");
        this.tester.submit("add_group");
        this.tester.assertTextNotPresent("Error occurred adding group");
        this.assertions.getUserAssertions().assertGroupExists("newGroup");
        this.deleteGroup("newGroup");
        this.assertions.getUserAssertions().assertGroupDoesNotExist("newGroup");
        this.deleteDelegatingLdapDirectory();
        this.enableLdapDirectory();
    }

    public void testLoginAsInvalidLdapUser() throws Exception {
        this.navigation.gotoAdmin();
        if (this.assertions.getUserAssertions().userExists("wilma")) {
            this.log("User wilma was found - attempting to clean up before running test.");
            this.deleteUser("wilma");
        }
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.disableLdapDirectory();
        this.addDelegatingLdapDirectory();
        this.setupUserWilma();
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "Delegating LDAP Directory");
        this.navigation.logout();
        this.navigation.loginAttempt("wilma", "password");
        this.tester.assertTextPresent("your username and password are incorrect");
        this.navigation.login("admin");
        this.deleteUser("wilma");
        this.deleteDelegatingLdapDirectory();
        this.enableLdapDirectory();
    }

    public void testLoginAsValidLdapUser() throws Exception {
        this.setupUserWilma();
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory");
        this.disableLdapDirectory();
        this.addDelegatingLdapDirectory();
        this.setupUserWilma();
        this.navigation.logout();
        this.navigation.loginAttempt("wilma", "fail");
        this.tester.assertTextPresent("your username and password are incorrect");
        this.navigation.login("wilma", "password");
        this.tester.clickLink("header-details-user-fullname");
        this.assertions.assertNodeByIdHasText("up-user-title-name", "Wilma Flintstone");
        this.navigation.logout();
        this.navigation.login("admin");
        this.deleteUser("wilma");
        this.deleteDelegatingLdapDirectory();
        this.enableLdapDirectory();
        this.deleteUser("wilma");
    }

    public void testEditUser() throws Exception {
        this.disableLdapDirectory();
        this.addDelegatingLdapDirectory();
        this.setupUserWilma();
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "Delegating LDAP Directory");
        this.navigation.gotoAdminSection("user_browser");
        this.tester.setFormElement("userNameFilter", "wil");
        this.tester.submit("");
        this.tester.clickLink("edituser_link_wilma");
        this.tester.setFormElement("fullName", "Betty Rubble");
        this.tester.setFormElement("email", "betty@example.com");
        this.tester.submit("Update");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Betty Rubble", "betty@example.com", "Delegating LDAP Directory");
        this.deleteUser("wilma");
        this.deleteDelegatingLdapDirectory();
        this.enableLdapDirectory();
    }

    public void testAddUserToGroup() throws Exception {
        this.disableLdapDirectory();
        this.addDelegatingLdapDirectory();
        this.setupUserWilma();
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "Delegating LDAP Directory");
        this.addGroup("cartoon-characters");
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup("wilma", "cartoon-characters");
        this.gotoViewUser("wilma");
        this.tester.clickLink("editgroups_link");
        this.tester.selectOption("groupsToJoin", "cartoon-characters");
        this.tester.submit("join");
        this.assertions.getUserAssertions().assertUserBelongsToGroup("wilma", "cartoon-characters");
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup("fred", "cartoon-characters");
        this.gotoViewUser("fred");
        this.tester.clickLink("editgroups_link");
        this.tester.selectOption("groupsToJoin", "cartoon-characters");
        this.tester.submit("join");
        this.assertions.getUserAssertions().assertUserBelongsToGroup("fred", "cartoon-characters");
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup("wilma", "jira-developers");
        this.gotoViewUser("wilma");
        this.tester.clickLink("editgroups_link");
        this.tester.selectOption("groupsToJoin", "jira-developers");
        this.tester.submit("join");
        this.assertions.getUserAssertions().assertUserBelongsToGroup("wilma", "jira-developers");
        this.deleteUser("wilma");
        this.deleteGroup("cartoon-characters");
        this.deleteDelegatingLdapDirectory();
        this.enableLdapDirectory();
    }

    private void setupUserWilma() {
        if (this.assertions.getUserAssertions().userExists("wilma")) {
            this.log("User wilma was found - attempting to clean up before running test.");
            this.deleteUser("wilma");
        }
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("add_user");
        this.tester.setFormElement("username", "wilma");
        this.tester.setFormElement("fullname", "Wilma Flintstone");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.setFormElement("email", "wilma@bedrock.com");
        this.tester.submit("Create");
        this.assertions.getUserAssertions().assertUserExists("wilma");
    }

    private void deleteUser(String username) {
        this.gotoViewUser(username);
        this.tester.clickLink("deleteuser_link");
        this.tester.submit("Delete");
    }

    private void gotoViewUser(String username) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
    }

    private void addGroup(String name) {
        this.navigation.gotoAdminSection("group_browser");
        this.tester.setFormElement("addName", name);
        this.tester.submit("add_group");
        this.tester.assertTextNotPresent("Error occurred adding group");
        this.assertions.getUserAssertions().assertGroupExists(name);
    }

    private void deleteGroup(String name) {
        this.navigation.gotoAdminSection("group_browser");
        this.tester.setFormElement("nameFilter", name);
        this.tester.submit("");
        this.tester.clickLink("del_" + name);
        this.tester.submit("Delete");
    }

    private void addDelegatingLdapDirectory() throws Exception {
        this.navigation.gotoAdminSection("user_directories");
        this.tester.assertTextPresent("User Directories");
        if (this.isActiveDirectory()) {
            this.log("Attempting to add a Delegating Active Directory LDAP User Directory...");
            this.addActiveDirectory();
        } else {
            this.log("Attempting to add a Delegating Open LDAP User Directory...");
            this.addOpenLdap();
        }
        WebTable table = this.assertions.getTableAssertions().getWebTable("directory-list");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 3, 1, "Delegating LDAP Directory");
        WebTable tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        WebLink link = tblDirectoryList.getTableCell(3, 3).getLinkWith("up");
        this.navigation.clickLink(link);
        tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        link = tblDirectoryList.getTableCell(2, 3).getLinkWith("up");
        this.navigation.clickLink(link);
        table = this.assertions.getTableAssertions().getWebTable("directory-list");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 1, "Delegating LDAP Directory");
    }

    private void addActiveDirectory() {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/delegatingldap/");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-delegating-ldap-form");
        this.tester.setFormElement("name", "Delegating LDAP Directory");
        this.tester.selectOption("type", "Microsoft Active Directory");
        this.tester.setFormElement("hostname", this.getLdapServer());
        this.tester.setFormElement("port", "636");
        this.tester.checkCheckbox("useSSL", "true");
        this.tester.setFormElement("ldapUserdn", this.getUserDn());
        this.tester.setFormElement("ldapPassword", this.getPassword());
        this.tester.setFormElement("ldapBasedn", this.getBaseDn());
        this.tester.setFormElement("ldapUserUsername", "sAMAccountName");
        this.tester.submit("test");
        this.text.assertTextPresent("Connection test successful");
        this.tester.submit("save");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.tester.assertTextPresent("JIRA Internal Directory");
        this.tester.assertTextPresent("Delegating LDAP Directory");
    }

    private void addOpenLdap() {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/delegatingldap/");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-delegating-ldap-form");
        this.tester.setFormElement("name", "Delegating LDAP Directory");
        this.tester.selectOption("type", "OpenLDAP");
        this.tester.setFormElement("hostname", this.getLdapServer());
        this.tester.setFormElement("port", "389");
        this.tester.setFormElement("ldapUserdn", this.getUserDn());
        this.tester.setFormElement("ldapBasedn", this.getBaseDn());
        this.tester.setFormElement("ldapPassword", this.getPassword());
        this.tester.setFormElement("ldapUserUsername", "cn");
        this.tester.submit("test");
        this.text.assertTextPresent("Connection test successful");
        this.tester.submit("save");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.tester.assertTextPresent("JIRA Internal Directory");
        this.tester.assertTextPresent("Delegating LDAP Directory");
    }

    private void deleteDelegatingLdapDirectory() {
        this.navigation.gotoAdminSection("user_directories");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this);
        WebLink link = userDirectoryTable.getTableCell(1, 4).getLinkWith("Disable");
        this.navigation.clickLink(link);
        WebTable table = this.assertions.getTableAssertions().getWebTable("directory-list");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 1, "Delegating LDAP Directory");
        userDirectoryTable = new UserDirectoryTable(this);
        link = userDirectoryTable.getTableCell(1, 4).getLinkWith("Remove");
        this.navigation.clickLink(link);
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.text.assertTextNotPresent(new IdLocator(this.tester, "embcwd"), "Delegating LDAP Directory");
    }

    private void disableLdapDirectory() {
        this.navigation.gotoAdminSection("user_directories");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this);
        TestTpmDelegatingLdap.assertTrue((boolean)userDirectoryTable.getTableCell(1, 1).asText().contains("LDAP Directory"));
        WebLink link = userDirectoryTable.getTableCell(1, 3).getLinkWith("Move Down");
        this.navigation.clickLink(link);
        this.navigation.logout();
        this.navigation.login("admin");
        this.navigation.gotoAdminSection("user_directories");
        userDirectoryTable = new UserDirectoryTable(this);
        link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Disable");
        this.navigation.clickLink(link);
        userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(2).hasEnableEditRemoveSynchroniseOperations();
    }

    private void enableLdapDirectory() {
        this.navigation.gotoAdminSection("user_directories");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this);
        TestTpmDelegatingLdap.assertTrue((boolean)userDirectoryTable.getTableCell(2, 1).asText().contains("LDAP Directory"));
        WebLink link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Enable");
        this.navigation.clickLink(link);
        userDirectoryTable = new UserDirectoryTable(this);
        TestTpmDelegatingLdap.assertTrue((boolean)userDirectoryTable.getTableCell(2, 1).asText().contains("LDAP Directory"));
        link = userDirectoryTable.getTableCell(2, 3).getLinkWith("Move Up");
        this.navigation.clickLink(link);
    }
}

