/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.WebLink;

@WebTest(value={Category.FUNC_TEST, Category.LDAP, Category.TPM})
public class TestCrowdDirectoryMaintenance
extends FuncTestCase {
    private static final String JAACS_APPLICATION_NAME = "CousinMabel";
    private static final String JAACS_APPLICATION_CREDENTIAL = "secret";

    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
        this.setUpJaacsServer();
    }

    public void testAddCrowdDirectory() {
        this.addDirectory();
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Crowd", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
    }

    private void addDirectory() {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/crowd/");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-crowd-form");
        this.tester.setFormElement("name", "");
        this.tester.submit("test");
        this.text.assertTextPresent("Name is a required field.");
        this.text.assertTextPresent("Server URL is a required field.");
        this.text.assertTextPresent("Application name is a required field.");
        this.text.assertTextPresent("Application password is a required field.");
        this.tester.setWorkingForm("configure-crowd-form");
        this.tester.setFormElement("name", "First Crowd");
        this.tester.setFormElement("crowdServerUrl", this.tester.getTestContext().getBaseUrl());
        this.tester.setFormElement("applicationName", JAACS_APPLICATION_NAME);
        this.tester.setFormElement("applicationPassword", JAACS_APPLICATION_CREDENTIAL);
        this.tester.submit("test");
        this.tester.setWorkingForm("configure-crowd-form");
        this.tester.setFormElement("crowdServerUrl", "http://dummmy.domain.priv/crowd");
        this.tester.submit("save");
    }

    public void testEditCrowdDirectory() {
        this.navigation.gotoAdminSection("user_directories");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.addDirectory();
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this);
        WebLink link = userDirectoryTable.getTableCell(2, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setFormElement("name", "First Crowd X");
        this.tester.setFormElement("crowdServerUrl", this.tester.getTestContext().getBaseUrl());
        this.tester.setFormElement("applicationName", JAACS_APPLICATION_NAME);
        this.tester.setFormElement("applicationPassword", JAACS_APPLICATION_CREDENTIAL);
        this.tester.submit("test");
        this.tester.setWorkingForm("configure-crowd-form");
        this.tester.setFormElement("crowdServerUrl", "http://dummmy.domain.priv/crowd");
        this.tester.submit("save");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Crowd X", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
        link = userDirectoryTable.getTableCell(2, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("crowdServerUrl", "");
        this.tester.setFormElement("applicationName", "");
        this.tester.setFormElement("applicationPassword", "");
        this.tester.submit("test");
        this.text.assertTextPresent("Name is a required field.");
        this.text.assertTextPresent("Server URL is a required field.");
        this.text.assertTextPresent("Application name is a required field.");
        this.text.assertTextPresent("Application password is a required field.");
        this.tester.clickLink("configure-crowd-form-cancel");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Crowd X", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
    }

    public void testDeleteCrowdDirectory() {
        this.navigation.gotoAdminSection("user_directories");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.addDirectory();
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this);
        WebLink link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Disable");
        this.navigation.clickLink(link);
        userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Crowd  (inactive)", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(false).hasEnableEditRemoveSynchroniseOperations();
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "First Crowd");
        link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Remove");
        this.navigation.clickLink(link);
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(false).hasOnlyEditOperation();
        this.text.assertTextNotPresent(new IdLocator(this.tester, "embcwd"), "First Crowd");
    }

    private void setUpJaacsServer() {
        this.navigation.gotoAdmin();
        this.navigation.gotoPage("secure/project/ConfigureCrowdServer.jspa");
        this.tester.clickLink("crowd-add-application");
        this.tester.setWorkingForm("edit-crowd-application");
        this.tester.setFormElement("name", JAACS_APPLICATION_NAME);
        this.tester.setFormElement("credential", JAACS_APPLICATION_CREDENTIAL);
        this.tester.clickButton("edit-crowd-application-submit");
    }
}

