/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.FuncTestCase;

public abstract class AbstractTpmLdapTest
extends FuncTestCase {
    protected boolean isActiveDirectory() {
        String ldapType = this.getConfigurationOption("ldap.type");
        if (ldapType == null) {
            throw new IllegalStateException("Missing configuration for 'ldap.type'.");
        }
        if (ldapType.equals("ActiveDirectory")) {
            return true;
        }
        if (ldapType.equals("OpenLdap")) {
            return false;
        }
        throw new IllegalStateException("Unknown LDAP type '" + ldapType + "'");
    }

    protected String getTypeDisplayName() {
        String ldapType = this.getConfigurationOption("ldap.type");
        if (ldapType == null) {
            throw new IllegalStateException("Missing configuration for 'ldap.type'.");
        }
        if (ldapType.equals("ActiveDirectory")) {
            return "Microsoft Active Directory";
        }
        if (ldapType.equals("OpenLdap")) {
            return "OpenLDAP";
        }
        throw new IllegalStateException("Unknown LDAP type '" + ldapType + "'");
    }

    protected String getUserDn() {
        if (this.isActiveDirectory()) {
            if (this.getLdapServer().equals("crowd-ad1")) {
                return "cn=Administrator,cn=Users,dc=sydney,dc=atlassian,dc=com";
            }
            return "cn=Administrator,cn=Users,dc=tpm,dc=atlassian,dc=com";
        }
        if (this.getLdapServer().equals("crowd-op23")) {
            return "o=sgi,c=us";
        }
        return "cn=Manager,o=tpm";
    }

    protected String getPassword() {
        if (this.isActiveDirectory()) {
            if (this.getLdapServer().equals("crowd-ad1")) {
                return "atlassian";
            }
            return "UrXwWtx1";
        }
        return "secret";
    }

    protected String getBaseDn() {
        if (this.isActiveDirectory()) {
            if (this.getLdapServer().equals("crowd-ad1")) {
                return "dc=sydney,dc=atlassian,dc=com";
            }
            return "ou=Sandbox,dc=tpm,dc=atlassian,dc=com";
        }
        if (this.getLdapServer().equals("crowd-op23")) {
            return "ou=JIRA-TPM,o=sgi,c=us";
        }
        return "o=tpm";
    }

    private String getConfigurationOption(String key) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        return this.environmentData.getProperty(key);
    }

    protected String getLdapServer() {
        String server = this.environmentData.getProperty("ldap.server");
        if (server == null) {
            return "localhost";
        }
        return server;
    }
}

