/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timezone;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebTable;

@WebTest(value={Category.FUNC_TEST, Category.TIME_ZONES})
public class TestIssueChangeHistory
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueChangeHistory.xml");
        this.administration.generalConfiguration().setDefaultUserTimeZone("Australia/Sydney");
    }

    public void testChangeDueDate() throws Exception {
        this.navigation.login("admin");
        this.navigation.issue().viewIssue("MKY-2");
        this.tester.clickLink("editIssue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement("duedate", "12/May/09");
        this.tester.submit("Update");
        this.tester.clickLinkWithText("History");
        WebTable changehistory_10300 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10300");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10300.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10300, new String[]{"Due Date", "", "12/May/09 EST"});
        this.tester.clickLink("editIssue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement("duedate", "11/May/11");
        this.tester.submit("Update");
        WebTable changehistory_10301 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10301");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10301.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10301, new String[]{"Due Date", "12/May/09 EST", "11/May/11 EST"});
        this.navigation.login("berlin");
        this.navigation.issue().viewIssue("MKY-2");
        changehistory_10300 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10300");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10300.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10300, new String[]{"F\u00e4lligkeitsdatum", "", "12/Mai/09 EST"});
        changehistory_10301 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10301");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10301.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10301, new String[]{"F\u00e4lligkeitsdatum", "12/Mai/09 EST", "11/Mai/11 EST"});
    }

    public void testDateCF() throws Exception {
        this.navigation.login("admin");
        this.navigation.issue().viewIssue("MKY-2");
        this.tester.clickLink("editIssue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement("customfield_10000", "03/May/11");
        this.tester.submit("Update");
        this.tester.clickLinkWithText("History");
        WebTable changehistory_10300 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10300");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10300.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10300, new String[]{"DatePickerCF", "", "3/May/11 EST"});
        this.tester.clickLink("editIssue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement("customfield_10000", "01/Jan/09");
        this.tester.submit("Update");
        WebTable changehistory_10301 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10301");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10301.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10301, new String[]{"DatePickerCF", "3/May/11 EST", "1/Jan/09 EST"});
        this.navigation.login("berlin");
        this.navigation.issue().viewIssue("MKY-2");
        changehistory_10300 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10300");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10300.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10300, new String[]{"DatePickerCF", "", "3/Mai/11 EST"});
        changehistory_10301 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10301");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10301.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10301, new String[]{"DatePickerCF", "3/Mai/11 EST", "1/Jan/09 EST"});
    }

    public void testDateTimeCF() throws Exception {
        this.navigation.login("admin");
        this.navigation.issue().viewIssue("MKY-2");
        this.tester.clickLink("editIssue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement("customfield_10001", "3/May/11 08:40 AM");
        this.tester.submit("Update");
        this.tester.clickLinkWithText("History");
        WebTable changehistory_10300 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10300");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10300.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10300, new String[]{"DateTimeCF", "", "03/May/11 8:40 AM"});
        this.tester.clickLink("editIssue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement("customfield_10001", "3/May/10 03:40 AM");
        this.tester.submit("Update");
        WebTable changehistory_10301 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10301");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10301.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10301, new String[]{"DateTimeCF", "03/May/11 8:40 AM", "03/May/10 3:40 AM"});
        this.navigation.login("berlin");
        this.navigation.issue().viewIssue("MKY-2");
        changehistory_10300 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10300");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10300.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10300, new String[]{"DateTimeCF", "", "03/Mai/11 12:40 AM"});
        changehistory_10301 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10301");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10301.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10301, new String[]{"DateTimeCF", "03/Mai/11 12:40 AM ", "02/Mai/10 7:40 PM "});
    }
}

