/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING})
public class TestWorklogSystemField
extends FuncTestCase {
    private static final String COMMENT_PREVIEW_ICON = "comment-preview_link";

    public void testFieldConfiguration() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.fieldConfigurations().defaultFieldConfiguration();
        this.text.assertTextNotPresent("Log Work");
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        this.administration.fieldConfigurations().defaultFieldConfiguration();
        this.text.assertTextPresent("Log Work");
    }

    public void testXssForLogWorkInputs() throws Exception {
        this.administration.restoreData("TestLogWorkAsField.xml");
        this.navigation.issue().gotoEditIssue("HSP-1");
        this.tester.setFormElement("worklog_timeLogged", "<em>TIMELOGGED</em>");
        this.tester.setFormElement("worklog_startDate", "<em>STARTDATE</em>");
        this.tester.checkCheckbox("worklog_adjustEstimate", "new");
        this.tester.setFormElement("worklog_newEstimate", "<em>NEWESTIMATE</em>");
        this.tester.submit();
        this.tester.assertTextPresent("&lt;em&gt;TIMELOGGED&lt;/em&gt;");
        this.tester.assertTextNotPresent("<em>TIMELOGGED</em>");
        this.tester.assertTextPresent("&lt;em&gt;STARTDATE&lt;/em&gt;");
        this.tester.assertTextNotPresent("<em>STARTDATE</em>");
        this.tester.assertTextPresent("&lt;em&gt;NEWESTIMATE&lt;/em&gt;");
        this.tester.assertTextNotPresent("<em>NEWESTIMATE</em>");
        this.tester.checkCheckbox("worklog_adjustEstimate", "manual");
        this.tester.setFormElement("worklog_adjustmentAmount", "<em>ADJUSTMENTAMOUNT</em>");
        this.tester.submit();
        this.tester.assertTextPresent("&lt;em&gt;ADJUSTMENTAMOUNT&lt;/em&gt;");
        this.tester.assertTextNotPresent("<em>ADJUSTMENTAMOUNT</em>");
    }

    public void testConfigureRendererForField() throws Exception {
        this.administration.restoreData("TestLogWorkAsField.xml");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(40, "jira-developers");
        this.administration.fieldConfigurations().defaultFieldConfiguration();
        TestWorklogSystemField.assertEquals((String)"Default Text Renderer", (String)this.administration.fieldConfigurations().defaultFieldConfiguration().getRenderer("Log Work"));
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.previewIconShouldNotBePresent();
        this.createIssueWithWorkLogged();
        this.navigateToEditWorkLog();
        this.previewIconShouldNotBePresent();
        this.navigateToLogWorkForm();
        this.previewIconShouldNotBePresent();
        this.logWorkOnCurrentIssue();
        this.shouldRenderAsTextWithDefaultRenderer();
        this.administration.fieldConfigurations().defaultFieldConfiguration().setRenderer("Log Work", "Wiki Style Renderer");
        TestWorklogSystemField.assertEquals((String)"Wiki Style Renderer", (String)this.administration.fieldConfigurations().defaultFieldConfiguration().getRenderer("Log Work"));
        this.navigateToEditWorkLog();
        this.previewIconShouldBePresent();
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.previewIconShouldBePresent();
        this.navigateToLogWorkForm();
        this.previewIconShouldBePresent();
        this.shouldRenderAsWikiWithWikiRenderer();
    }

    private void navigateToEditWorkLog() {
        this.navigation.issue().gotoIssueWorkLog("HSP-2");
        this.tester.clickLink("edit_worklog_10000");
    }

    private void shouldRenderAsWikiWithWikiRenderer() {
        this.navigation.issue().gotoIssueWorkLog("HSP-2");
        this.tester.assertTextNotPresent("*Should be bold*");
        this.tester.assertTextPresent("<b>Should be bold</b>");
        this.tester.assertTextNotPresent("_Should be italics_");
        this.tester.assertTextPresent("<em>Should be italics</em>");
    }

    private void shouldRenderAsTextWithDefaultRenderer() {
        this.navigation.issue().gotoIssueWorkLog("HSP-2");
        this.tester.assertTextPresent("*Should be bold*");
        this.tester.assertTextNotPresent("<b>Should be bold</b>");
        this.tester.assertTextPresent("_Should be italics_");
        this.tester.assertTextNotPresent("<em>Should be italics</em>");
    }

    private void createIssueWithWorkLogged() {
        this.tester.setFormElement("summary", "issue summary");
        this.tester.setFormElement("worklog_timeLogged", "1h");
        this.tester.setFormElement("comment", "*Should be bold*");
        this.tester.submit();
    }

    private void logWorkOnCurrentIssue() {
        this.tester.setFormElement("timeLogged", "2h");
        this.tester.setFormElement("comment", "_Should be italics_");
        this.tester.submit();
    }

    private void navigateToLogWorkForm() {
        this.navigation.issue().gotoIssue("HSP-2");
        this.tester.clickLink("log-work");
    }

    private void previewIconShouldBePresent() {
        this.tester.assertElementPresent(COMMENT_PREVIEW_ICON);
    }

    private void previewIconShouldNotBePresent() {
        this.tester.assertElementNotPresent(COMMENT_PREVIEW_ICON);
    }
}

