/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING})
public class TestTimeTrackingWithCustomNumberOfWorkingDays
extends FuncTestCase {
    public void testNumberOfWorkingDaysPerWeekCanBeFractional() {
        this.administration.restoreBlankInstance();
        this.administration.timeTracking().enable("24", "5.5", "pretty", "hour", TimeTracking.Mode.LEGACY);
        this.text.assertTextPresent("The number of working days per week is <b>5.5</b>");
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "time tracking entry");
        this.setOriginalEstimate(issueKey, "11d");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_orig"), "2w");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_remain"), "2w");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable("24", "9.5", "pretty", "hour", TimeTracking.Mode.LEGACY);
        this.navigation.issue().viewIssue(issueKey);
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_orig"), "1w 1d 12h");
        this.text.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_remain"), "1w 1d 12h");
    }

    private void setOriginalEstimate(String issueKey, String originalEstimate) {
        this.navigation.issue().viewIssue(issueKey);
        this.getTester().clickLink("editIssue");
        this.getTester().assertFormElementPresent("timetracking");
        this.getTester().setFormElement("timetracking", originalEstimate);
        this.getTester().submit();
    }
}

