/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.text.DecimalFormat;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING})
public class TestTimeTrackingToolTips
extends FuncTestCase {
    public void testTimeTrackingToolTips() throws Exception {
        this.administration.restoreBlankInstance();
        this._testToolTips("pretty", new PrettyDurationFormatter());
        this._testToolTips("days", new ShortDurationFormatter());
        this._testToolTips("hours", new ShortDurationFormatter());
    }

    private void _testToolTips(String format, DurationFormatter formatter) {
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable("24", "7", format, "hour", TimeTracking.Mode.LEGACY);
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "time tracking entry " + format);
        this.setOriginalEstimate(key, "12.15h");
        String origEstimate = "Original Estimate - " + formatter.formatDuration(12L, 9L);
        String remainingEstimate = "Remaining Estimate - " + formatter.formatDuration(12L, 9L);
        String timeSpent = "Time Spent - Not Specified";
        this.assertTimeTrackingToolTips("orig", origEstimate, new String[0]);
        this.assertTimeTrackingToolTips("remain", remainingEstimate, new String[0]);
        this.assertTimeTrackingToolTips("spent", timeSpent, new String[0]);
        this.navigation.issue().logWork(key, "5h 9m");
        timeSpent = "Time Spent - " + formatter.formatDuration(5L, 9L);
        remainingEstimate = "Remaining Estimate - " + formatter.formatDuration(7L, null);
        this.assertTimeTrackingToolTips("orig", origEstimate, new String[0]);
        this.assertTimeTrackingToolTips("remain", remainingEstimate, timeSpent, remainingEstimate);
        this.assertTimeTrackingToolTips("spent", timeSpent, timeSpent, remainingEstimate);
        this.navigation.issue().logWork(key, "6.5h", "0h");
        remainingEstimate = "Remaining Estimate - " + formatter.formatDuration(null, 0L);
        timeSpent = "Time Spent - " + formatter.formatDuration(11L, 39L);
        this.assertTimeTrackingToolTips("orig", origEstimate, new String[0]);
        this.assertTimeTrackingToolTips("remain", remainingEstimate, new String[0]);
        this.assertTimeTrackingToolTips("spent", timeSpent, timeSpent, "Time Not Required");
        this.navigation.issue().logWork(key, "30m", "0m");
        remainingEstimate = "Remaining Estimate - " + formatter.formatDuration(null, 0L);
        timeSpent = "Time Spent - " + formatter.formatDuration(12L, 9L);
        this.assertTimeTrackingToolTips("orig", origEstimate, new String[0]);
        this.assertTimeTrackingToolTips("remain", remainingEstimate, new String[0]);
        this.assertTimeTrackingToolTips("spent", timeSpent, new String[0]);
        this.navigation.issue().logWork(key, "30m", "0m");
        timeSpent = "Time Spent - " + formatter.formatDuration(12L, 39L);
        this.assertTimeTrackingToolTips("orig", origEstimate, new String[0]);
        this.assertTimeTrackingToolTips("remain", remainingEstimate, new String[0]);
        this.assertTimeTrackingToolTips("spent", timeSpent, new String[0]);
    }

    private void assertTimeTrackingToolTips(String timeTrackingField, String expectedToolTip, String ... expectedGraphToolTip) {
        XPathLocator fieldLabelToolTipLocator = new XPathLocator(this.getTester(), String.format("//*[@id='tt_single_text_%s']/@title", timeTrackingField));
        this.text.assertTextPresent(fieldLabelToolTipLocator, expectedToolTip);
        XPathLocator fieldValueToolTipLocator = new XPathLocator(this.getTester(), String.format("//*[@id='tt_single_values_%s']/@title", timeTrackingField));
        this.text.assertTextPresent(fieldValueToolTipLocator, expectedToolTip);
        XPathLocator fieldGraphToolTipLocator = new XPathLocator(this.getTester(), String.format("//*[@id='tt_single_graph_%s']//img/@title", timeTrackingField));
        if (expectedGraphToolTip.length > 0) {
            this.text.assertTextSequence(fieldGraphToolTipLocator, expectedGraphToolTip);
        } else {
            this.text.assertTextSequence(fieldGraphToolTipLocator, expectedToolTip, new String[0]);
        }
    }

    private void setOriginalEstimate(String issueKey, String originalEstimate) {
        this.navigation.issue().viewIssue(issueKey);
        this.getTester().clickLink("editIssue");
        this.getTester().assertFormElementPresent("timetracking");
        this.getTester().setFormElement("timetracking", originalEstimate);
        this.getTester().submit();
    }

    private static class ShortDurationFormatter
    implements DurationFormatter {
        private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

        private ShortDurationFormatter() {
        }

        @Override
        public String formatDuration(Long hours, Long minutes) {
            double total = 0.0;
            if (hours != null) {
                total = hours.longValue();
            }
            if (minutes != null) {
                total += (double)minutes.longValue() / 60.0;
            }
            DecimalFormat format = DECIMAL_FORMAT;
            return format.format(total);
        }
    }

    private static class PrettyDurationFormatter
    implements DurationFormatter {
        private final String minuteUnit;
        private final String hourUnit;
        private final String separator;

        private PrettyDurationFormatter() {
            this(" minutes", " hours", ", ");
        }

        private PrettyDurationFormatter(String minuteUnit, String hourUnit, String separator) {
            this.minuteUnit = minuteUnit;
            this.hourUnit = hourUnit;
            this.separator = separator;
        }

        @Override
        public String formatDuration(Long hours, Long minutes) {
            StringBuilder builder = new StringBuilder();
            if (hours != null) {
                builder.append(hours).append(this.hourUnit);
            }
            if (minutes != null) {
                if (builder.length() > 0) {
                    builder.append(this.separator);
                }
                builder.append(minutes).append(this.minuteUnit);
            }
            return builder.toString();
        }
    }

    private static interface DurationFormatter {
        public String formatDuration(Long var1, Long var2);
    }
}

