/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import java.util.List;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS, Category.TIME_TRACKING})
public class TestTimeTrackingReport
extends JIRAWebTest {
    private static final char NEG = '\u2011';
    private static final String SIGMA = "&Sigma;";
    private static final int PID_MONOTREME = 10010;
    private static final int PID_HOMOSAPIEN = 10000;
    private static final Long PROJECT_MONKEY_ID = 10001L;
    public static final String VERSION_NAME_FOUR = "New Version 4 {b}";

    public TestTimeTrackingReport(String name) {
        super(name);
    }

    public void testTimeTrackingReportAvailable() {
        this.restoreData("TestTimeTrackingReport.xml");
        this.gotoPage("/secure/ConfigureReport.jspa?versionId=-1&sortingOrder=least&completedFilter=all&reportKey=com.atlassian.jira.plugin.system.reports%3Atime-tracking&Next=Next");
        this.assertTextPresent("There is no project selected.");
        this.gotoPage("/secure/ConfigureReport.jspa?versionId=-1&sortingOrder=least&completedFilter=all&reportKey=com.atlassian.jira.plugin.system.reports%3Atime-tracking&Next=Next&selectedProjectId=10000");
        this.assertTextNotPresent("There is no project selected.");
        this.assertTextPresent("Time Tracking Report for&nbsp;homosapien");
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:time-tracking");
        this.submit("Next");
        this.assertTextPresent("Time Tracking Report for&nbsp;homosapien");
        this.gotoPage("/secure/ConfigureReport.jspa?versionId=-1&sortingOrder=least&completedFilter=all&reportKey=com.atlassian.jira.plugin.system.reports%3Atime-tracking&Next=Next");
        this.assertTextPresent("Time Tracking Report for&nbsp;homosapien");
    }

    public void testTimeTrackingReportSwitchingBetweenProjects() {
        this.restoreData("TestTimeTrackingReport.xml");
        this.gotoPage("/secure/ConfigureReport.jspa?versionId=-1&sortingOrder=least&completedFilter=all&reportKey=com.atlassian.jira.plugin.system.reports%3Atime-tracking&Next=Next&selectedProjectId=10000");
        this.assertTextPresent("Time Tracking Report for&nbsp;homosapien");
        this.gotoPage("/secure/ConfigureReport.jspa?versionId=-1&sortingOrder=least&completedFilter=all&reportKey=com.atlassian.jira.plugin.system.reports%3Atime-tracking&Next=Next&selectedProjectId=10001");
        this.assertTextPresent("Time Tracking Report for&nbsp;monkey");
    }

    public void testTimeTrackingReportShowsSubTaskSelector() {
        this.restoreData("TestTimeTrackingReport.xml");
        this.gotoPage("/secure/ConfigureReport.jspa?versionId=-1&sortingOrder=least&completedFilter=all&reportKey=com.atlassian.jira.plugin.system.reports%3Atime-tracking&Next=Next&selectedProjectId=10000");
        this.assertTextNotPresent("Sub-task Inclusion");
        this.activateSubTasks();
        this.gotoReportConfig(10000);
        this.assertTextPresent("Sub-task Inclusion");
        this.selectOption("subtaskInclusion", "Only including sub-tasks with the selected version");
        this.selectOption("subtaskInclusion", "Also including sub-tasks without a version set");
        this.selectOption("subtaskInclusion", "Including all sub-tasks");
        this.assertOptionValueNotPresent("subtaskInclusion", "Sub-tasks are not enabled");
    }

    public void testSubTaskAggregatesWithNoSubtasksDisplayed() throws SAXException {
        this.restoreData("TestTimeTrackingReport.xml");
        this.activateSubTasks();
        this.gotoReportConfig(10000);
        this.selectMultiOptionByValue("subtaskInclusion", "all");
        this.selectMultiOptionByValue("sortingOrder", "least");
        this.selectMultiOptionByValue("completedFilter", "all");
        this.submit("Next");
        this.assertTextPresent("Including all sub-tasks");
        this.assertTextPresent(SIGMA);
        this.assertTableCellHasText("bars-summary", 0, 0, "Progress: 39%");
        this.assertTableCellHasText("bars-summary", 1, 0, "Accuracy: 0%");
        WebTable table = this.getDialog().getResponse().getTableWithID("timeReport");
        List rowList = this.getTableRowAsList(table, 1);
        String[] row = rowList.toArray(new String[rowList.size()]);
        TestTimeTrackingReport.assertTrue((row[3].indexOf("massive bug") != -1 ? 1 : 0) != 0);
        TestTimeTrackingReport.assertEquals((String)"1w 3d", (String)row[4]);
        TestTimeTrackingReport.assertEquals((String)"1w 3d", (String)row[5]);
        TestTimeTrackingReport.assertEquals((String)"5d 19h 30m", (String)row[6]);
        TestTimeTrackingReport.assertEquals((String)"5d 19h 30m", (String)row[7]);
        TestTimeTrackingReport.assertEquals((String)"4d 4h 30m", (String)row[8]);
        TestTimeTrackingReport.assertEquals((String)"4d 4h 30m", (String)row[9]);
        TestTimeTrackingReport.assertEquals((String)"on track", (String)row[10]);
        TestTimeTrackingReport.assertEquals((String)"on track", (String)row[11]);
        rowList = this.getTableRowAsList(table, 2);
        row = rowList.toArray(new String[rowList.size()]);
        TestTimeTrackingReport.assertTrue((row[3].indexOf("bug2") != -1 ? 1 : 0) != 0);
        TestTimeTrackingReport.assertEquals((String)"1d", (String)row[4]);
        TestTimeTrackingReport.assertEquals((String)"1d", (String)row[5]);
        TestTimeTrackingReport.assertEquals((String)"20h 30m", (String)row[6]);
        TestTimeTrackingReport.assertEquals((String)"20h 30m", (String)row[7]);
        TestTimeTrackingReport.assertEquals((String)"3h 30m", (String)row[8]);
        TestTimeTrackingReport.assertEquals((String)"3h 30m", (String)row[9]);
        TestTimeTrackingReport.assertEquals((String)"on track", (String)row[10]);
        TestTimeTrackingReport.assertEquals((String)"on track", (String)row[11]);
        rowList = this.getTableRowAsList(table, 3);
        row = rowList.toArray(new String[rowList.size()]);
        TestTimeTrackingReport.assertEquals((String)"Total", (String)row[3]);
        TestTimeTrackingReport.assertEquals((String)"1w 4d", (String)row[4]);
        TestTimeTrackingReport.assertEquals((String)"6d 16h", (String)row[6]);
        TestTimeTrackingReport.assertEquals((String)"4d 8h", (String)row[8]);
        TestTimeTrackingReport.assertEquals((String)"on track", (String)row[10]);
    }

    public void testSubTaskAggregates() throws SAXException {
        this.restoreData("TestTimeTrackingReportWithSubtasksEnterprise.xml");
        this.gotoReportConfig(10010);
        this.selectMultiOptionByValue("versionId", "10010");
        this.selectMultiOptionByValue("subtaskInclusion", "all");
        this.selectMultiOptionByValue("sortingOrder", "least");
        this.selectMultiOptionByValue("completedFilter", "all");
        this.submit("Next");
        this.assertTextPresent("Time Tracking Report for&nbsp;Monotreme");
        this.assertTextPresent("(v8)");
        this.assertTextPresent("Including all sub-tasks");
        WebTable table = this.getDialog().getResponse().getTableWithID("timeReport");
        List rowList = this.getTableRowAsList(table, 1);
        String[] row = rowList.toArray(new String[rowList.size()]);
        TestTimeTrackingReport.assertTrue((row[3].indexOf("monotreme parent with fixfor v8") != -1 ? 1 : 0) != 0);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[4]);
        TestTimeTrackingReport.assertEquals((String)"7h 10m", (String)row[5]);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[6]);
        TestTimeTrackingReport.assertEquals((String)"6h 10m", (String)row[7]);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[8]);
        TestTimeTrackingReport.assertEquals((String)"5h", (String)row[9]);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[10]);
        TestTimeTrackingReport.assertEquals((String)"\u20114h", (String)row[11]);
        rowList = this.getTableRowAsList(table, 2);
        row = rowList.toArray(new String[rowList.size()]);
        TestTimeTrackingReport.assertTrue((row[3].indexOf("subtask with no fixfor and parent fixfor v8") != -1 ? 1 : 0) != 0);
        TestTimeTrackingReport.assertEquals((String)"6h", (String)row[4]);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[5]);
        TestTimeTrackingReport.assertEquals((String)"6h", (String)row[6]);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[7]);
        TestTimeTrackingReport.assertEquals((String)"4h", (String)row[8]);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[9]);
        TestTimeTrackingReport.assertEquals((String)"\u20114h", (String)row[10]);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[11]);
        rowList = this.getTableRowAsList(table, 3);
        row = rowList.toArray(new String[rowList.size()]);
        TestTimeTrackingReport.assertTrue((row[3].indexOf("subtask with fixfor v8 same as parent") != -1 ? 1 : 0) != 0);
        TestTimeTrackingReport.assertEquals((String)"10m", (String)row[4]);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[5]);
        TestTimeTrackingReport.assertEquals((String)"10m", (String)row[6]);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[7]);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[8]);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[9]);
        TestTimeTrackingReport.assertEquals((String)"on track", (String)row[10]);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[11]);
        rowList = this.getTableRowAsList(table, 4);
        row = rowList.toArray(new String[rowList.size()]);
        TestTimeTrackingReport.assertTrue((row[3].indexOf("subtask complete same fixfor as parent") != -1 ? 1 : 0) != 0);
        TestTimeTrackingReport.assertEquals((String)"1h", (String)row[4]);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[5]);
        TestTimeTrackingReport.assertEquals((String)"0m", (String)row[6]);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[7]);
        TestTimeTrackingReport.assertEquals((String)"1h", (String)row[8]);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[9]);
        TestTimeTrackingReport.assertEquals((String)"on track", (String)row[10]);
        TestTimeTrackingReport.assertEquals((String)"-", (String)row[11]);
        rowList = this.getTableRowAsList(table, 5);
        row = rowList.toArray(new String[rowList.size()]);
        TestTimeTrackingReport.assertTrue((row[3].indexOf("MON-5") != -1 ? 1 : 0) != 0);
        TestTimeTrackingReport.assertTrue((row[3].indexOf("v12 subtask with v8 fixfor") != -1 ? 1 : 0) != 0);
        TestTimeTrackingReport.assertEquals((String)"44m", (String)row[4]);
        TestTimeTrackingReport.assertEquals((String)"44m", (String)row[5]);
        TestTimeTrackingReport.assertEquals((String)"23m", (String)row[6]);
        TestTimeTrackingReport.assertEquals((String)"23m", (String)row[7]);
        TestTimeTrackingReport.assertEquals((String)"21m", (String)row[8]);
        TestTimeTrackingReport.assertEquals((String)"21m", (String)row[9]);
        TestTimeTrackingReport.assertEquals((String)"on track", (String)row[10]);
        TestTimeTrackingReport.assertEquals((String)"on track", (String)row[11]);
        rowList = this.getTableRowAsList(table, 6);
        row = rowList.toArray(new String[rowList.size()]);
        TestTimeTrackingReport.assertEquals((String)"Total", (String)row[3]);
        TestTimeTrackingReport.assertEquals((String)"7h 54m", (String)row[4]);
        TestTimeTrackingReport.assertEquals((String)"6h 33m", (String)row[6]);
        TestTimeTrackingReport.assertEquals((String)"5h 21m", (String)row[8]);
        TestTimeTrackingReport.assertEquals((String)"\u20114h", (String)row[10]);
        this.assertSummaryPercentages(44, -50);
        this.assertTableCellHasText("bars-summary", 0, 2, "5h 21m completed from current total estimate of 11h 54m");
        this.assertTableCellHasText("bars-summary", 1, 2, "Issues in this version are behind the original estimate of 7h 54m by 4 hours.");
    }

    public void testSubTaskAggregatesVersionSpecific() throws SAXException {
        this.restoreData("TestTimeTrackingReportWithSubtasksEnterprise.xml");
        this.gotoReportConfig(10010);
        this.selectMultiOptionByValue("versionId", "10010");
        this.selectMultiOptionByValue("subtaskInclusion", "onlySelected");
        this.selectMultiOptionByValue("sortingOrder", "most");
        this.selectMultiOptionByValue("completedFilter", "all");
        this.submit("Next");
        this.assertTextPresent("Time Tracking Report for&nbsp;Monotreme");
        this.assertTextPresent("(v8)");
        this.assertTextPresent("Only including sub-tasks with the selected version");
        this.assertTimeReportCell(1, 3, "monotreme parent with fixfor v8");
        this.assertTimeReportCell(1, 4, "-");
        this.assertTimeReportCell(1, 5, "1h 10m");
        this.assertTimeReportCell(1, 6, "-");
        this.assertTimeReportCell(1, 7, "10m");
        this.assertTimeReportCell(1, 8, "-");
        this.assertTimeReportCell(1, 9, "1h");
        this.assertTimeReportCell(1, 10, "-");
        this.assertTimeReportCell(1, 11, "on track");
        this.assertTimeReportCell(2, 3, "subtask complete same fixfor as parent");
        this.assertTimeReportCell(2, 4, "1h");
        this.assertTimeReportCell(2, 5, "-");
        this.assertTimeReportCell(2, 6, "0m");
        this.assertTimeReportCell(2, 7, "-");
        this.assertTimeReportCell(2, 8, "1h");
        this.assertTimeReportCell(2, 9, "-");
        this.assertTimeReportCell(2, 10, "on track");
        this.assertTimeReportCell(2, 11, "-");
        this.assertTimeReportCell(3, 3, "subtask with fixfor v8 same as parent");
        this.assertTimeReportCell(3, 4, "10m");
        this.assertTimeReportCell(3, 5, "-");
        this.assertTimeReportCell(3, 6, "10m");
        this.assertTimeReportCell(3, 7, "-");
        this.assertTimeReportCell(3, 8, "-");
        this.assertTimeReportCell(3, 9, "-");
        this.assertTimeReportCell(3, 10, "on track");
        this.assertTimeReportCell(3, 11, "-");
        this.assertTimeReportCell(4, 3, "v12 subtask with v8 fixfor");
        this.assertTimeReportCell(4, 4, "44m");
        this.assertTimeReportCell(4, 5, "44m");
        this.assertTimeReportCell(4, 6, "23m");
        this.assertTimeReportCell(4, 7, "23m");
        this.assertTimeReportCell(4, 8, "21m");
        this.assertTimeReportCell(4, 9, "21m");
        this.assertTimeReportCell(4, 10, "on track");
        this.assertTimeReportCell(4, 11, "on track");
        this.assertTimeReportCell(5, 3, "Total");
        this.assertTimeReportCell(5, 4, "1h 54m");
        this.assertTimeReportCell(5, 6, "33m");
        this.assertTimeReportCell(5, 8, "1h 21");
        this.assertTimeReportCell(5, 10, "on track");
        this.assertTextNotPresent("subtask with no fixfor and parent fixfor v8");
        this.assertSummaryPercentages(71, 0);
    }

    public void testSubTaskAggregatesWithVersionAndBlank() throws SAXException {
        this.restoreData("TestTimeTrackingReportWithSubtasksEnterprise.xml");
        this.assertSubtaskAggregatesWithVersionAndBlank();
    }

    public void testSubTaskAggregatesWithVersionAndNoVersionSubtasksAddingHugeCompleteIssue() throws SAXException {
        this.restoreData("TestTimeTrackingReportWithSubtasksEnterprise.xml");
        String hugeIssueKey = this.addIssue("Monotreme", "MON", "Bug", "huge complete issue", "Critical", null, null, new String[]{"v8"}, "Administrator", "env", "huge estimates", "20w", null, null);
        this.activateTimeTracking();
        this.logWorkOnIssue(hugeIssueKey, "22w");
        this.assertSubtaskAggregatesWithVersionAndBlank();
    }

    public void testSubTasksBothResolvedAndUnresolvedIncluded() throws Exception {
        this.restoreData("TestTimeTrackingReportSubTasksResolvedAndUnresolved.xml");
        this.gotoReportConfig(10000);
        this.selectMultiOptionByValue("versionId", "10000");
        this.selectMultiOptionByValue("sortingOrder", "least");
        this.selectMultiOptionByValue("completedFilter", "all");
        this.selectMultiOptionByValue("subtaskInclusion", "all");
        this.submit("Next");
        for (int i = 1; i < 11; ++i) {
            this.assertTextPresent("HSP-" + i);
        }
    }

    private void assertSubtaskAggregatesWithVersionAndBlank() {
        this.gotoReportConfig(10010);
        this.selectMultiOptionByValue("versionId", "10011");
        this.selectMultiOptionByValue("subtaskInclusion", "selectedAndBlank");
        this.selectMultiOptionByValue("sortingOrder", "least");
        this.selectMultiOptionByValue("completedFilter", "incomplete");
        this.submit("Next");
        this.assertTextPresent("Time Tracking Report for&nbsp;Monotreme");
        this.assertTextPresent("(v12)");
        this.assertTextPresent("Also including sub-tasks without a version set");
        this.assertTimeReportCell(1, 3, "v12 issue");
        this.assertTimeReportCell(1, 4, "1d 6h");
        this.assertTimeReportCell(1, 5, "1d 10h 2m");
        this.assertTimeReportCell(1, 6, "1d 6h");
        this.assertTimeReportCell(1, 7, "1d 10h 1m");
        this.assertTimeReportCell(1, 8, "-");
        this.assertTimeReportCell(1, 9, "1h 3m");
        this.assertTimeReportCell(1, 10, "on track");
        this.assertTimeReportCell(1, 11, "\u20111h 2m");
        this.assertTimeReportCell(2, 3, "subtask v12");
        this.assertTimeReportCell(2, 4, "4h 1m");
        this.assertTimeReportCell(2, 5, "-");
        this.assertTimeReportCell(2, 6, "3h 59m");
        this.assertTimeReportCell(2, 7, "-");
        this.assertTimeReportCell(2, 8, "3m");
        this.assertTimeReportCell(2, 9, "-");
        this.assertTimeReportCell(2, 10, "\u20111m");
        this.assertTimeReportCell(2, 11, "-");
        this.assertTimeReportCell(3, 3, "no fixfor subtask of a v12 issue");
        this.assertTimeReportCell(3, 4, "1m");
        this.assertTimeReportCell(3, 5, "-");
        this.assertTimeReportCell(3, 6, "2m");
        this.assertTimeReportCell(3, 7, "-");
        this.assertTimeReportCell(3, 8, "1h");
        this.assertTimeReportCell(3, 9, "-");
        this.assertTimeReportCell(3, 10, "\u20111h 1m");
        this.assertTimeReportCell(3, 11, "-");
        this.assertTimeReportCell(4, 3, "Total");
        this.assertTimeReportCell(4, 4, "1d 10h 2m");
        this.assertTimeReportCell(4, 6, "1d 10h 1m");
        this.assertTimeReportCell(4, 8, "1h 3m");
        this.assertTimeReportCell(4, 10, "\u20111h 2m");
        this.assertSummaryPercentages(2, -3);
        this.assertTableCellHasText("bars-summary", 0, 2, "1h 3m completed from current total estimate of 1d 11h 4m");
        this.assertTableCellHasText("bars-summary", 1, 2, "Issues in this version are behind the original estimate of 1d 10h 2m by 1 hour, 2 minutes.");
    }

    public void testPrintFormatInTimeTrackingReport() {
        this.restoreData("TestTimeTrackingReport.xml");
        this.reconfigureTimetracking("days");
        this.generateTimeTrackingReport(PROJECT_MONKEY_ID);
        this.assertTextPresent("<b>2d 16h</b> completed from current total estimate of <b>2d 19h</b>");
        this.reconfigureTimetracking("hours");
        this.generateTimeTrackingReport(PROJECT_MONKEY_ID);
        this.assertTextPresent("<b>64h</b> completed from current total estimate of <b>67h</b>");
        this.reconfigureTimetracking("pretty");
        this.generateTimeTrackingReport(PROJECT_MONKEY_ID);
        this.assertTextPresent("<b>2d 16h</b> completed from current total estimate of <b>2d 19h</b>");
    }

    public void testPrettyPrintTimeTrackingReports() {
        this.restoreData("TestTimeTrackingReport.xml");
        this.reconfigureTimetracking("pretty");
        this.generateUserWorkloadReport(10000L, "admin");
        this.assertTextPresentAfterText("homosapien", "1");
        this.assertTextPresentBeforeText("1", "5 days, 19 hours, 30 minutes");
        this.assertTextPresentAfterText("monkey", "2");
        this.assertTextPresentBeforeText("2", "3 hours");
        String issueKey1 = this.addIssue("homosapien", "HSP", "Bug", "increase HSP workload by 4 days");
        this.setOriginalEstimate(issueKey1, "4d");
        this.assignIssue(issueKey1, "assigning to admin", "Administrator");
        this.generateUserWorkloadReport(10000L, "admin");
        this.assertTextPresentAfterText("homosapien", "2");
        this.assertTextPresentBeforeText("2", "1 week, 2 days, 19 hours, 30 minutes");
        this.assertTextPresentAfterText("monkey", "2");
        this.assertTextPresentBeforeText("2", "3 hours");
        this.logWorkOnIssueWithComment(issueKey1, "9d", "huge amount of work being done here");
        this.generateUserWorkloadReport(10000L, "admin");
        this.assertTextPresent("5 days, 19 hours, 30 minutes");
        this.assertTextPresent("5 days, 22 hours, 30 minutes");
        this.reconfigureTimetracking("days");
        this.generateUserWorkloadReport(10000L, "admin");
        this.assertTextPresent("5d 19.5h");
        this.assertTextPresent("3h");
        this.assertTextPresent("5d 22.5h");
        String issueKey = this.addIssue("monkey", "MKY", "Bug", "1");
        this.setOriginalEstimate(issueKey, "10d");
        this.generateUserWorkloadReport(PROJECT_MONKEY_ID, "admin");
        this.assertTextPresent("5d 19.5h");
        this.assertTextPresent("10d 3h");
        this.assertTextPresent("15d 22.5h");
    }

    public void testPrintHoursTimeTracking() {
        this.restoreData("TestTimeTrackingReport.xml");
        this.reconfigureTimetracking("hours");
        this.generateUserWorkloadReport(10000L, "admin");
        this.assertTextPresent("139.5h");
        this.assertTextPresent("3h");
        this.assertTextPresent("142.5h");
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", "Bug");
        this.setOriginalEstimate(issueKey, "2h 30m");
        this.generateUserWorkloadReport(PROJECT_MONKEY_ID, "admin");
        this.assertTextPresent("145h");
        issueKey = this.addIssue("monkey", "MKY", "Bug", "Bug");
        this.setOriginalEstimate(issueKey, "5h");
        this.generateUserWorkloadReport(PROJECT_MONKEY_ID, "admin");
        this.assertTextPresent("150h");
        this.logWorkOnIssueWithComment(issueKey, "5h", "more work");
        this.generateUserWorkloadReport(PROJECT_MONKEY_ID, "admin");
        this.assertTextPresent("145h");
    }

    public void testTimeTrackingReport() {
        this.restoreData("TestTimeTrackingReport.xml");
        this.reconfigureTimetracking("days");
        this.generateTimeTrackingReport(10000L);
        this.assertTextPresent("4d 8h");
        String issuekey = this.addIssue("homosapien", "HSP", "Bug", "Bug");
        this.setOriginalEstimate(issuekey, "3d");
        this.logWorkOnIssueWithComment(issuekey, "3d", "three more days");
        this.generateTimeTrackingReport(10000L);
        this.assertTextPresent("7d 8h");
        this.reconfigureTimetracking("hours");
        this.generateTimeTrackingReport(10000L);
        this.assertTextPresent("176h");
        this.assertTextPresent("160h");
        issuekey = this.addIssue("homosapien", "HSP", "Bug", "Bug");
        this.setOriginalEstimate(issuekey, "1d");
        this.generateTimeTrackingReport(10000L);
        this.assertTextPresent("184h");
        this.logWorkOnIssueWithComment(issuekey, "1d", "24 hours completed");
        this.generateTimeTrackingReport(10000L);
        this.assertTextPresent("160h");
        this.reconfigureTimetracking("pretty");
        this.generateTimeTrackingReport(10000L);
        this.assertTextPresent("1w 1d 8h");
        this.assertTextPresent("6d 16h");
    }

    public void testSingleLevelGroupByReport() {
        this.restoreData("TestTimeTrackingReport.xml");
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:singlelevelgroupby");
        this.setFormElement("filterid", "10000");
        this.submit("Next");
        this.assertTextPresent("Issues {all}");
    }

    public void testVersionIsEncoded() {
        this.restoreData("TestVersionAndComponentsWithHTMLNames.xml");
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:time-tracking");
        this.selectOption("versionId", "- \"version<input >");
        this.submit("Next");
        this.assertTextPresent("&quot;version&lt;input &gt;");
        this.assertTextNotPresent("\"version<input >");
    }

    public void testTimeTrackingReportNotCacheable() {
        this.restoreData("TestTimeTrackingReport.xml");
        this.gotoPage("/secure/ConfigureReport.jspa?versionId=-1&sortingOrder=least&completedFilter=all&reportKey=com.atlassian.jira.plugin.system.reports%3Atime-tracking&Next=Next&selectedProjectId=10000");
        this.assertResponseCannotBeCached();
    }

    public void testTimeTrackingReportSorting() {
        this.restoreData("TestTimeTrackingReportSorting.xml");
        this.gotoPage("/browse/AA");
        this.tester.clickLinkWithText("Time Tracking Report");
        this.tester.selectOption("sortingOrder", "Least completed issues first");
        this.tester.submit("Next");
        this.assertIssueOrder(new String[]{"AA-11", "AA-9", "AA-8", "AA-7", "AA-6", "AA-5", "AA-4", "AA-3", "AA-2", "AA-1", "AA-10"});
        this.gotoPage("/browse/AA");
        this.tester.clickLinkWithText("Time Tracking Report");
        this.tester.selectOption("sortingOrder", "Most completed issues first");
        this.tester.submit("Next");
        this.assertIssueOrder(new String[]{"AA-10", "AA-1", "AA-2", "AA-3", "AA-4", "AA-5", "AA-6", "AA-7", "AA-8", "AA-9", "AA-11"});
    }

    private void assertIssueOrder(String[] issueKeys) {
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//table[@id='timeReport']/tbody/tr/td[@class='issue-key']/a");
        Node[] nodes = xPathLocator.getNodes();
        TestTimeTrackingReport.assertEquals((int)issueKeys.length, (int)nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            String issueKey = issueKeys[i];
            TestTimeTrackingReport.assertEquals((String)("The " + i + "th row was expected to be " + issueKey), (String)issueKey, (String)xPathLocator.getText(nodes[i]));
        }
    }

    private void gotoReportConfig(int projectId) {
        this.gotoPage("/secure/ConfigureReport!default.jspa?reportKey=com.atlassian.jira.plugin.system.reports:time-tracking&selectedProjectId=" + projectId);
    }

    private void assertTimeReportCell(int row, int col, String expectedText) {
        this.assertTableCellHasText("timeReport", row, col, expectedText);
    }

    private void assertSummaryPercentages(int progressPercentage, int accuracyPercentage) {
        this.assertTableCellHasText("bars-summary", 0, 0, "Progress: " + progressPercentage + "%");
        this.assertTableCellHasText("bars-summary", 1, 0, "Accuracy: " + accuracyPercentage + "%");
    }

    private void generateTimeTrackingReport(Long projectId) {
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=" + projectId + "&reportKey=com.atlassian.jira.plugin.system.reports:time-tracking");
        this.selectOption("sortingOrder", "Most completed issues first");
        this.selectOption("completedFilter", "All");
        this.selectOption("versionId", "No Fix Version");
        this.submit("Next");
    }

    private void generateUserWorkloadReport(long projectId, String user) {
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=" + projectId + "&reportKey=com.atlassian.jira.plugin.system.reports:developer-workload");
        this.setFormElement("developer", user);
        this.submit("Next");
    }

    private void setOriginalEstimate(String issueKey, String originalEstimate) {
        this.gotoIssue(issueKey);
        this.clickLink("editIssue");
        this.setFormElement("timetracking", originalEstimate);
        this.submit("Update");
    }

    private static class Urls {
        private static final String TIMETRACKING_REPORT_DEFAULTS = "/secure/ConfigureReport.jspa?versionId=-1&sortingOrder=least&completedFilter=all&reportKey=com.atlassian.jira.plugin.system.reports%3Atime-tracking&Next=Next";
        private static final String TIMETRACKING_REPORT_CONFIG = "/secure/ConfigureReport!default.jspa?reportKey=com.atlassian.jira.plugin.system.reports:time-tracking";

        private Urls() {
        }
    }
}

