/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask.move;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SUB_TASKS})
public class TestMoveSubTaskIssueType
extends JIRAWebTest {
    public TestMoveSubTaskIssueType(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestMoveSubTaskIssueType.xml");
    }

    @Override
    public void tearDown() {
        this.restoreData("blankprojects.xml");
        super.tearDown();
    }

    public void testHappy() {
        this.gotoIssue("HSP-2");
        this.clickLink("move-issue");
        this.assertRadioOptionPresent("operation", "move.subtask.type.operation.name");
        this.assertRadioOptionPresent("operation", "move.subtask.parent.operation.name");
        this.checkCheckbox("operation", "move.subtask.type.operation.name");
        this.submit("Next >>");
        this.assertTextPresent("Sub-task 2");
        this.assertTextNotPresent("Sub-task 3");
    }

    public void testNoOtherSubsInProject() {
        this.navigation.gotoAdmin();
        this.clickLink("subtasks");
        this.clickLink("del_Sub-task 2");
        this.submit("Delete");
        this.gotoIssue("HSP-2");
        this.clickLink("move-issue");
        this.assertRadioOptionNotPresent("operation", "move.subtask.type.operation.name");
        this.assertRadioOptionPresent("operation", "move.subtask.parent.operation.name");
        this.assertTextPresent("There are no other sub-task issue types associated with this project.");
    }

    public void testNoScheme() {
        this.gotoPage("/plugins/servlet/project-config/HSP/issuetypes");
        this.clickLink("project-config-issuetype-scheme-change");
        this.checkCheckbox("createType", "chooseScheme");
        this.selectOption("schemeId", "Default Issue Type Scheme");
        this.submit(" OK ");
        this.gotoIssue("HSP-2");
        this.clickLink("move-issue");
        this.assertRadioOptionPresent("operation", "move.subtask.type.operation.name");
        this.assertRadioOptionPresent("operation", "move.subtask.parent.operation.name");
        this.checkCheckbox("operation", "move.subtask.type.operation.name");
        this.submit("Next >>");
        this.assertTextPresent("Sub-task 2");
        this.assertTextPresent("Sub-task 3");
    }

    public void testNoOtherSubsAtAll() {
        this.navigation.gotoAdmin();
        this.clickLink("subtasks");
        this.clickLink("del_Sub-task 2");
        this.submit("Delete");
        this.clickLink("del_Sub-task 3");
        this.submit("Delete");
        this.gotoPage("/plugins/servlet/project-config/HSP/issuetypes");
        this.clickLink("project-config-issuetype-scheme-change");
        this.checkCheckbox("createType", "chooseScheme");
        this.selectOption("schemeId", "Default Issue Type Scheme");
        this.submit(" OK ");
        this.gotoIssue("HSP-2");
        this.clickLink("move-issue");
        this.assertRadioOptionNotPresent("operation", "move.subtask.type.operation.name");
        this.assertRadioOptionPresent("operation", "move.subtask.parent.operation.name");
        this.assertTextPresent("There are no other sub-task issue types defined in the system.");
    }
}

