/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import org.junit.Ignore;

@Ignore(value="Disabled pending more investigation --lmiranda")
@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
public class TestSubtaskSecurity
extends JIRAWebTest {
    private String jiraContextPath;

    public TestSubtaskSecurity(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestSubtaskSecurity.xml");
        this.jiraContextPath = this.getEnvironmentData().getContext();
        this.administration.attachments().enable();
    }

    @Override
    public void tearDown() {
        super.tearDown();
    }

    public void testParentIssueShouldNotBeLinkedOnIssueNavigator() {
        this.login("ted", "ted");
        this.displayAllIssues();
        this.assertTextPresent("<a href=\"/jira/browse/HSP-3\">HSP-3</a>");
        this.assertNoLinksToHSP1();
        this.assertTextNotPresent("a href=\"" + this.jiraContextPath + "/browse/HSP-1\" class=\"parentIssue\" title=\"A parent bug assigned to bill\">HSP-1</a>");
    }

    public void testParentIssueShouldNotBeLinkedOnManageAttachmentsPage() {
        this.login("ted", "ted");
        this.navigation.issue().attachments("HSP-3").manage();
        this.assertTextPresent(this.unlinkedTextForHSP1());
        this.assertNoLinksToHSP1();
    }

    public void testParentIssueShouldNotBeLinkedOnManageTrackbacksPage() {
        this.login("ted", "ted");
        this.gotoIssue("HSP-3");
        this.clickLinkWithText("Manage Trackbacks");
        this.assertTextPresent(this.unlinkedTextForHSP1());
        this.assertNoLinksToHSP1();
    }

    public void testParentIssueShouldNotBeLinkedOnViewIssuePage() {
        this.login("ted", "ted");
        this.gotoIssue("HSP-3");
        this.assertTextPresent(this.unlinkedTextForHSP1());
        this.assertNoLinksToHSP1();
    }

    public void testParentIssueShouldBeLinkedOnIssueNavigator() {
        this.login("bill", "bill");
        this.displayAllIssues();
        this.assertTextPresent("a href=\"" + this.jiraContextPath + "/browse/HSP-1\" class=\"parentIssue\" title=\"A parent bug assigned to bill\">HSP-1</a>");
        this.assertTextNotPresent(this.unlinkedTextForHSP1());
    }

    public void testParentIssueShouldBeLinkedOnManageAttachmentsPage() {
        this.login("bill", "bill");
        this.navigation.issue().attachments("HSP-2").manage();
        this.assertTextPresent(this.linkForHSP1());
        this.assertTextNotPresent(this.unlinkedTextForHSP1());
    }

    public void testParentIssueShouldBeLinkedOnManageTrackbacksPage() {
        this.login("bill", "bill");
        this.gotoIssue("HSP-2");
        this.clickLinkWithText("Manage Trackbacks");
        this.assertTextPresent(this.linkForHSP1());
        this.assertTextNotPresent(this.unlinkedTextForHSP1());
    }

    public void testParentIssueShouldBeLinkedOnViewIssuePage() {
        this.login("bill", "bill");
        this.gotoIssue("HSP-2");
        this.assertTextPresent(this.linkForHSP1());
        this.assertTextNotPresent(this.unlinkedTextForHSP1());
    }

    private void assertNoLinksToHSP1() {
        this.assertTextNotPresent("<a id=\"parent_issue_summary\" href=\"" + this.jiraContextPath + "/browse/HSP-1\">");
        this.assertTextNotPresent("<a href=\"" + this.jiraContextPath + "/browse/HSP-1\">");
        this.assertTextNotPresent("<a href=\"" + this.jiraContextPath + "/browse/HSP-1\" class=\"parentIssue\" title=\"A parent bug assigned to bill\">HSP-1</a>");
    }

    public void disabledTestParentIssueShouldBeLinked() {
        this.gotoProjectBrowse("HSP");
        this.clickLinkWithText("Road Map");
        this.assertTextPresent("<a href=\"" + this.jiraContextPath + "/browse/HSP-1\" style=\"text-decoration: none;\" title=\"A parent bug assigned to bill\">HSP-1</a>");
        this.assertTextNotPresent(this.unlinkedTextForHSP1());
        this.gotoProjectBrowse("HSP");
        this.clickLinkWithText("Versions");
        this.clickLink("version_10000");
        this.assertTextPresent("<a href=\"" + this.jiraContextPath + "/browse/HSP-1\" style=\"text-decoration: none;\" title=\"A parent bug assigned to bill\">HSP-1</a>");
        this.assertTextNotPresent(this.unlinkedTextForHSP1());
        this.gotoProjectBrowse("HSP");
        this.clickLinkWithText("Components");
        this.clickLink("component_10000");
        this.assertTextPresent("<a href=\"" + this.jiraContextPath + "/browse/HSP-1\" style=\"text-decoration: none;\" title=\"A parent bug assigned to bill\">HSP-1</a>");
        this.assertTextNotPresent(this.unlinkedTextForHSP1());
        this.gotoProjectBrowse("HSP");
        this.clickLinkWithText("Version Workload Report");
        this.selectOption("versionId", "- New Version 1");
        this.submit("Next");
        this.assertTextPresent("<a href=\"" + this.jiraContextPath + "/browse/HSP-1\" style=\"text-decoration: none;\" title=\"A parent bug assigned to bill\">HSP-1</a>");
        this.assertTextNotPresent(this.unlinkedTextForHSP1());
        this.gotoProjectBrowse("HSP");
        this.clickLinkWithText("Time Tracking Report");
        this.selectOption("versionId", "- New Version 1");
        this.submit("Next");
        this.assertTextPresent("<a href=\"" + this.jiraContextPath + "/browse/HSP-1\">HSP-1</a>");
        this.assertTextNotPresent(this.unlinkedTextForHSP1());
    }

    private void disabledTestParentIssueShouldNotBeLinked() {
        this.gotoPage("browse/HSP#selectedTab=com.atlassian.jira.plugin.system.project%3Aroadmap-panel");
        this.assertTextPresent("<span class=\"smallgrey\">HSP-1</span>");
        this.assertTextNotPresent("<a href=\"" + this.jiraContextPath + "/browse/HSP-1\" style=\"text-decoration: none;\" title=\"A parent bug assigned to bill\">HSP-1</a>");
        this.gotoPage("browse/HSP#selectedTab=com.atlassian.jira.plugin.system.project%3Aversions-panel");
        this.clickLink("version_10000");
        this.assertTextPresent(this.unlinkedTextForHSP1());
        this.assertTextNotPresent("<a href=\"" + this.jiraContextPath + "/browse/HSP-1\" style=\"text-decoration: none;\" title=\"A parent bug assigned to bill\">HSP-1</a>");
        this.gotoPage("browse/HSP#selectedTab=com.atlassian.jira.plugin.system.project%3Acomponents-panel");
        this.clickLink("component_10000");
        this.assertTextPresent(this.unlinkedTextForHSP1());
        this.assertTextNotPresent("<a href=\"" + this.jiraContextPath + "/browse/HSP-1\" style=\"text-decoration: none;\" title=\"A parent bug assigned to bill\">HSP-1</a>");
        this.gotoProjectBrowse("HSP");
        this.clickLinkWithText("Version Workload Report");
        this.selectOption("versionId", "- New Version 1");
        this.submit("Next");
        this.assertTextPresent(this.unlinkedTextForHSP1());
        this.assertTextNotPresent("<a href=\"" + this.jiraContextPath + "/browse/HSP-1\" style=\"text-decoration: none;\" title=\"A parent bug assigned to bill\">HSP-1</a>");
        this.gotoProjectBrowse("HSP");
        this.clickLinkWithText("Time Tracking Report");
        this.selectOption("versionId", "- New Version 1");
        this.submit("Next");
        this.assertTextPresent(this.unlinkedTextForHSP1());
        this.assertTextNotPresent("<a href=\"" + this.jiraContextPath + "/browse/HSP-1\" style=\"text-decoration: none;\" title=\"A parent bug assigned to bill\">HSP-1</a>");
    }

    private String linkForHSP1() {
        return "<a title=\"A parent bug assigned to bill\" id=\"parent_issue_summary\" href=\"" + this.jiraContextPath + "/browse/HSP-1\">";
    }

    private String unlinkedTextForHSP1() {
        return "<li>HSP-1</li>";
    }
}

