/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SUB_TASKS})
public class TestIssueToSubTaskConversionStep2
extends JIRAWebTest {
    private static final String ISSUE_TO_CONVERT_ID = "10050";
    private static final String ISSUE_TO_CONVERT_KEY = "MKY-4";
    private static final String ISSUE_TO_CONVERT_INVALID_STATUS_ID = "10051";
    private static final String ISSUE_TO_CONVERT_INVALID_STATUS_KEY = "MKY-5";
    private static final String PARENT_ISSUE = "MKY-3";
    private static final String SUBTASK_TYPE = "Sub-task";
    private static final String SUBTASK_TYPE_ID = "5";
    private static final String SUBTASK_TYPE_3 = "Sub-task 3";
    private static final String SUBTASK_TYPE_3_ID = "7";
    private static final String VALID_STATUS = "1";
    private static final String INVALID_STATUS = "3";
    private static final String NON_EXISTANT_STATUS = "932";

    public TestIssueToSubTaskConversionStep2(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueToSubTaskConversion.xml");
    }

    public void testSameWorkflow() {
        this.gotoConvertIssueStep2(ISSUE_TO_CONVERT_ID, PARENT_ISSUE, SUBTASK_TYPE_ID);
        this.assertTextPresent("Step 2 is not required.");
        this.assertThirdStepPaneWithout2nd(ISSUE_TO_CONVERT_KEY, PARENT_ISSUE, SUBTASK_TYPE, "Open");
        this.assertTextNotPresent("Closed");
        this.assertTextNotPresent("Reopened");
        this.assertTextNotPresent("Resolved");
        this.submit("Next >>");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_KEY, 4);
        this.assertTextNotInTable("convert_confirm_table", "Status");
        this.submit("Finish");
        IdLocator locator = new IdLocator(this.tester, "type-val");
        this.text.assertTextPresent(locator, SUBTASK_TYPE);
        locator = new IdLocator(this.tester, "status-val");
        this.text.assertTextPresent(locator, "Open");
        this.clickLinkWithText("History");
        this.assertTextPresentOnlyOnce("Status");
        this.assertTextSequence(new String[]{"History", "Issue Type", "Bug", SUBTASK_TYPE});
        this.assertTextSequence(new String[]{"History", "Parent", PARENT_ISSUE});
    }

    public void testDiffWorkflowValidStatus() {
        this.gotoConvertIssueStep2(ISSUE_TO_CONVERT_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID);
        this.assertTextPresent("Step 2 is not required.");
        this.assertThirdStepPaneWithout2nd(ISSUE_TO_CONVERT_KEY, PARENT_ISSUE, SUBTASK_TYPE_3, "Open");
        this.assertTextNotPresent("Closed");
        this.assertTextNotPresent("Reopened");
        this.assertTextNotPresent("Resolved");
        this.submit("Next >>");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_KEY, 4);
        this.assertTextInTable("convert_confirm_table", "Status");
        this.assertTextSequence(new String[]{"Status", "(Workflow)", "Open", "status-inactive", "(jira)", "Open", "status-active", "(Subtask Workflow)"});
        this.submit("Finish");
        IdLocator locator = new IdLocator(this.tester, "type-val");
        this.text.assertTextPresent(locator, SUBTASK_TYPE_3);
        locator = new IdLocator(this.tester, "status-val");
        this.text.assertTextPresent(locator, "Open");
        this.clickLinkWithText("History");
        this.assertTextPresentOnlyOnce("Status");
        this.assertTextSequence(new String[]{"History", "Workflow", "jira", "Subtask Workflow"});
        this.assertTextSequence(new String[]{"History", "Issue Type", "Bug", SUBTASK_TYPE_3});
        this.assertTextSequence(new String[]{"History", "Parent", PARENT_ISSUE});
    }

    public void testDiffWorkflowInvalidStatus() {
        this.gotoConvertIssueStep2(ISSUE_TO_CONVERT_INVALID_STATUS_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID);
        this.assertTextPresent("Step 2 of 4");
        this.assertOptionsEqual("targetStatusId", new String[]{"Open", "Resolved", "Reopened", "Closed"});
        this.assertOptionValueNotPresent("targetStatusId", "In Progress");
        this.assertTextSequence(new String[]{"Select New Status", "In Progress", "Workflow", "jira", "Workflow", "Subtask Workflow"});
        this.assertSecondStepPane(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, PARENT_ISSUE, SUBTASK_TYPE_3);
        this.setFormElement("targetStatusId", VALID_STATUS);
        this.submit("Next >>");
        this.assertTextNotPresent("Closed");
        this.assertTextNotPresent("Reopened");
        this.assertTextNotPresent("Resolved");
        this.submit("Next >>");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, 4);
        this.assertTextInTable("convert_confirm_table", "Status");
        this.assertTextSequence(new String[]{"Status", "(Workflow)", "status-inactive", "In Progress", "status-inactive", "(jira)", "status-active", "Open", "status-active", "(Subtask Workflow)"});
        this.submit("Finish");
        IdLocator locator = new IdLocator(this.tester, "type-val");
        this.text.assertTextPresent(locator, SUBTASK_TYPE_3);
        locator = new IdLocator(this.tester, "status-val");
        this.text.assertTextPresent(locator, "Open");
        this.clickLinkWithText("History");
        this.assertTextSequence(new String[]{"History", "Workflow", "jira", "Subtask Workflow"});
        this.assertTextSequence(new String[]{"History", "Status", "In Progress", "Open"});
        this.assertTextSequence(new String[]{"History", "Issue Type", "Bug", SUBTASK_TYPE_3});
        this.assertTextSequence(new String[]{"History", "Parent", PARENT_ISSUE});
    }

    public void testBrowseBackOnPane() {
        this.gotoConvertIssueStep3(ISSUE_TO_CONVERT_INVALID_STATUS_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID, VALID_STATUS);
        this.submit("Next >>");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, 4);
        this.clickLinkWithText("Select Parent and Sub-task Type");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, 1);
        this.assertTextPresent("Step 1 of 4");
        this.assertTextPresent(PARENT_ISSUE);
        this.getDialog().dumpResponse();
        this.assertTextPresent("option value=\"7\" SELECTED");
        this.gotoConvertIssueStep3(ISSUE_TO_CONVERT_INVALID_STATUS_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID, VALID_STATUS);
        this.submit("Next >>");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, 4);
        this.clickLinkWithText("Select New Status");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, 2);
        this.assertTextPresent("Step 2 of 4");
        this.assertTextPresent("option value=\"1\" SELECTED");
        this.gotoConvertIssueStep3(ISSUE_TO_CONVERT_INVALID_STATUS_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID, VALID_STATUS);
        this.submit("Next >>");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, 4);
        this.clickLinkWithText("Update Fields");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, 3);
        this.assertTextPresent("Step 3 of 4");
    }

    public void testResultsValidStatus() {
        this.gotoConvertIssueStep3(ISSUE_TO_CONVERT_INVALID_STATUS_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID, VALID_STATUS);
        this.assertTextPresent("Step 3 of 4");
        this.assertThirdStepPaneWith2nd(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, PARENT_ISSUE, SUBTASK_TYPE_3, "Open");
    }

    public void testResultsInvalidStatus() {
        this.gotoConvertIssueStep3(ISSUE_TO_CONVERT_INVALID_STATUS_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID, INVALID_STATUS);
        this.assertTextPresent("Step 2 of 4");
        this.assertTextPresent("Selected status (In Progress) is not valid for target workflow");
        this.assertSecondStepPane(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, PARENT_ISSUE, SUBTASK_TYPE_3);
    }

    public void testResultsNoStatus() {
        this.gotoConvertIssueStep3(ISSUE_TO_CONVERT_INVALID_STATUS_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID, "");
        this.assertTextPresent("Step 2 of 4");
        this.assertTextPresent("No status specified");
        this.assertSecondStepPane(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, PARENT_ISSUE, SUBTASK_TYPE_3);
    }

    public void testResultsNonExistantStatus() {
        this.gotoConvertIssueStep3(ISSUE_TO_CONVERT_INVALID_STATUS_ID, PARENT_ISSUE, SUBTASK_TYPE_3_ID, NON_EXISTANT_STATUS);
        this.assertTextPresent("Step 2 of 4");
        this.assertTextPresent("Status with id 932 does not exist");
        this.assertSecondStepPane(ISSUE_TO_CONVERT_INVALID_STATUS_KEY, PARENT_ISSUE, SUBTASK_TYPE_3);
    }

    public void testResultsValidStatusForIssueThatDoesntNeedChanging() {
        this.gotoConvertIssueStep3(ISSUE_TO_CONVERT_ID, PARENT_ISSUE, SUBTASK_TYPE_ID, INVALID_STATUS);
        this.assertTextPresent("Status should not be changed for this conversion");
    }

    private void assertSecondStepPane(String key, String parent, String type) {
        this.assertSubTaskConversionPanelSteps(key, 2);
        this.assertLinkPresentWithText("Select Parent and Sub-task Type");
        this.assertLinkNotPresentWithText("Select New Status");
        this.assertLinkNotPresentWithText("Update Fields");
        this.assertTextSequence(new String[]{"Parent Issue:", "<strong>" + parent + "</strong>", "Sub-task Type:", "<strong>" + type + "</strong>", "Select New Status"});
    }

    private void assertThirdStepPaneWith2nd(String key, String parent, String type, String status) {
        this.assertSubTaskConversionPanelSteps(key, 3);
        this.assertLinkPresentWithText("Select Parent and Sub-task Type");
        this.assertLinkPresentWithText("Select New Status");
        this.assertLinkNotPresentWithText("Update Fields");
        this.assertTextSequence(new String[]{"Parent Issue:", "<strong>" + parent + "</strong>", "Sub-task Type:", "<strong>" + type + "</strong>", "Status:", "<strong>" + status + "</strong>"});
    }

    private void assertThirdStepPaneWithout2nd(String key, String parent, String type, String status) {
        this.assertSubTaskConversionPanelSteps(key, 3);
        this.assertLinkPresentWithText("Select Parent and Sub-task Type");
        this.assertLinkNotPresentWithText("Select New Status");
        this.assertLinkNotPresentWithText("Update Fields");
        this.assertTextSequence(new String[]{"Parent Issue:", "<strong>" + parent + "</strong>", "Sub-task Type:", "<strong>" + type + "</strong>", "Status:", "<strong>" + status + "</strong>"});
    }
}

