/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import java.io.IOException;

@WebTest(value={Category.FUNC_TEST, Category.SUB_TASKS})
public class TestCreateSubTasks
extends JIRAWebTest {
    private static final String PROJECT_MONKEY_ID = "10001";

    public TestCreateSubTasks(String name) {
        super(name);
    }

    public void testCreateSubTaskInJiraWithSingleSubTaskType() {
        this.administration.restoreData("TestOneProjectWithOneIssueType.xml");
        this.administration.project().addProject("neanderthal", "NEA", "admin");
        this.gotoPage("/plugins/servlet/project-config/HSP/issuetypes");
        this.clickLink("project-config-issuetype-scheme-change");
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "Bugs & Sub-tasks");
        this.tester.submit();
        this.navigation.issue().createIssue("homosapien", "Bug", "First issue");
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLink("create-subtask");
        this.tester.assertTextNotPresent("Choose the project and issue type");
        this.tester.assertTextPresent("Create Sub-Task");
        this.assertTextSequence(new String[]{"Project", "homosapien", "Issue Type", "Sub-task"});
        this.tester.assertFormElementPresent("summary");
    }

    public void testCreateSubTasks() {
        this.restoreBlankInstance();
        this.addProject("neanderthal", "NDT", "admin");
        this.createSubTaskType("Custom Sub Task", "Custom Sub Task");
        this.resetFields();
        String issueKeyNormal = this.addIssue("homosapien", "HSP", "Bug", "test for sub tasks", "Minor", null, null, null, "Administrator", "test environment 1", "test description for sub tasks", null, null, null);
        this.subTasksWithSubTasksEnabled(issueKeyNormal);
        this.subTasksCreateSubTaskWithCustonType(issueKeyNormal);
        this.subTasksWithCreatePermission(issueKeyNormal);
        this.subTaskWithNoSummary(issueKeyNormal);
        this.subTaskWithRequiredFields(issueKeyNormal);
        this.subTaskWithHiddenFields(issueKeyNormal);
        this.subTaskWithInvalidDueDate(issueKeyNormal);
        this.subTaskWithSchedulePermission(issueKeyNormal);
        this.subTaskWithAssignPermission(issueKeyNormal);
        this.subTaskWithModifyReporterPermission(issueKeyNormal);
        this.subTaskWithTimeTracking(issueKeyNormal);
        this.subTaskWithUnassignableUser(issueKeyNormal);
        this.subTaskMoveIssueWithSubTask(issueKeyNormal);
        this.deleteIssue(issueKeyNormal);
    }

    public void testCreateSubtaskSkipStep1OnlyOneProjectAndOneIssueType() {
        this.restoreData("TestCreateSubtaskOneProjectOneSubtaskType.xml");
        this.assertRedirectAndFollow("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10000", ".*CreateSubTaskIssue\\.jspa\\?parentIssueId=10000&pid=10001&issuetype=4$");
        this.assertTextSequence(new String[]{"Create Sub-Task", "Project", "monkey", "Issue Type", "Sub-task", "Summary"});
    }

    public void testCreateIssueSkipStep1IssueTypeSchemeInfersOneProjectAndIssueType() {
        this.restoreData("TestCreateMonkeyHasOneIssueType.xml");
        this.assertRedirectAndFollow("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10000", ".*CreateSubTaskIssue\\.jspa\\?parentIssueId=10000&pid=10001&issuetype=5$");
        this.assertTextSequence(new String[]{"Create Sub-Task", "Project", "monkey", "Issue Type", "Sub-task", "Summary"});
        this.gotoPage("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10001");
        this.assertTextSequence(new String[]{"Create Issue", "Choose the issue type"});
        this.logout();
        this.gotoPage("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10000");
        this.assertTextPresent("You are not logged in");
        this.clickLinkWithText("Log In");
        this.setFormElement("os_username", "admin");
        this.setFormElement("os_password", "admin");
        this.setWorkingForm("login-form");
        this.submit();
        this.assertTextSequence(new String[]{"Create Sub-Task", "Project", "monkey", "Issue Type", "Sub-task", "Summary"});
    }

    public void subTasksWithSubTasksEnabled(String issueKey) {
        this.activateSubTasks();
        TestCreateSubTasks.log("Sub Task Create: Tests the availability of the 'Sub Task' Link with 'Sub Tasks' enabled");
        this.gotoIssue(issueKey);
        this.assertLinkPresent("create-subtask");
        this.deactivateSubTasks();
        this.gotoIssue(issueKey);
        this.assertLinkNotPresent("create-subtask");
    }

    public void subTasksCreateSubTaskWithCustonType(String issueKey) {
        TestCreateSubTasks.log("Sub Task Create: Tests the ability to create a sub task using a custom-made sub task type");
        this.createSubTaskStep1(issueKey, "Custom Sub Task");
        this.setFormElement("summary", "Custom Sub Task of Test 5");
        this.submit();
        this.assertTextPresent("Custom Sub Task of Test 5");
        this.assertTextPresent("test for sub tasks");
        this.deleteCurrentIssue();
        this.deactivateSubTasks();
        this.assertTextPresent("Enable");
    }

    public void subTasksWithCreatePermission(String issueKey) {
        TestCreateSubTasks.log("Sub Task Create: Test availability of 'Create Sub Task' link with 'Create Issue' permission.");
        this.activateSubTasks();
        this.removeGroupPermission(11, "jira-users");
        this.gotoIssue(issueKey);
        this.assertLinkNotPresent("create-subtask");
        this.grantGroupPermission(11, "jira-users");
        this.gotoIssue(issueKey);
        this.assertLinkPresent("create-subtask");
        this.deactivateSubTasks();
    }

    public void subTaskWithNoSummary(String issueKey) {
        TestCreateSubTasks.log("Sub Task Create: Adding sub task without summary");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.selectOption("priority", "Minor");
        this.submit();
        this.assertTextPresent("Create Sub-Task");
        this.assertTextPresent("You must specify a summary of the issue.");
        this.deactivateSubTasks();
    }

    public void subTaskWithRequiredFields(String issueKey) {
        this.setRequiredFields();
        TestCreateSubTasks.log("Sub Task Create: Test the creation of a sub task using required fields");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.setFormElement("summary", "This is a new summary");
        this.setFormElement("reporter", "");
        this.submit("Create");
        this.assertTextPresent("Create Sub-Task");
        this.assertTextPresent("Component/s is required");
        this.assertTextPresent("Affects Version/s is required");
        this.assertTextPresent("Fix Version/s is required");
        this.resetFields();
        this.deactivateSubTasks();
    }

    public void subTaskWithHiddenFields(String issueKey) {
        this.setHiddenFields("Component/s");
        this.setHiddenFields("Affects Version/s");
        this.setHiddenFields("Fix Version/s");
        TestCreateSubTasks.log("Sub Task Create: Test the creation of a sub task using hidden fields");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.assertTextPresent("Create Sub-Task");
        this.assertLinkNotPresent("components");
        this.assertLinkNotPresent("versions");
        this.assertLinkNotPresent("fixVersions");
        this.resetFields();
        this.deactivateSubTasks();
    }

    public void subTaskWithInvalidDueDate(String issueKey) {
        TestCreateSubTasks.log("Sub Task Create: Creating sub task with invalid due date");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.setFormElement("summary", "stuff");
        this.setFormElement("duedate", "stuff");
        this.submit("Create");
        this.assertTextPresent("Create Sub-Task");
        this.assertTextPresent("You did not enter a valid date. Please enter the date in the format &quot;d/MMM/yy&quot;");
        this.deactivateSubTasks();
    }

    public void subTaskWithSchedulePermission(String issueKey) {
        TestCreateSubTasks.log("Sub Task Create: Test prescence of 'Due Date' field with 'Schedule Issue' permission.");
        this.removeGroupPermission(28, "jira-developers");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.assertTextNotPresent("Due Date");
        this.deactivateSubTasks();
        this.grantGroupPermission(28, "jira-developers");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.assertTextPresent("Due Date");
        this.deactivateSubTasks();
    }

    public void subTaskWithAssignPermission(String issueKey) {
        TestCreateSubTasks.log("Sub Task Create: Test ability to specify assignee with 'Assign Issue' permission.");
        this.removeGroupPermission(13, "jira-developers");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.assertFormElementNotPresent("assignee");
        this.deactivateSubTasks();
        this.grantGroupPermission(13, "jira-developers");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.assertFormElementPresent("assignee");
        this.deactivateSubTasks();
    }

    public void subTaskWithModifyReporterPermission(String issueKey) {
        TestCreateSubTasks.log("Sub Task Create: Test availability of Reporter with 'Modify Reporter' permission.");
        this.removeGroupPermission(30, "jira-administrators");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.assertFormElementNotPresent("reporter");
        this.deactivateSubTasks();
        this.grantGroupPermission(30, "jira-administrators");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.assertFormElementPresent("reporter");
        this.deactivateSubTasks();
    }

    public void subTaskWithTimeTracking(String issueKey) {
        TestCreateSubTasks.log("Sub task Create: Test availability of the original esitmate field with time tracking activated");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.assertFormElementNotPresent("timetracking");
        this.deactivateSubTasks();
        this.activateTimeTracking();
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.assertFormElementPresent("timetracking");
        this.deactivateTimeTracking();
        this.deactivateSubTasks();
    }

    public void subTaskWithUnassignableUser(String issueKey) {
        TestCreateSubTasks.log("Sub Task Create: Attempt to set the assignee to be an unassignable user ...");
        this.removeGroupPermission(17, "jira-developers");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.submit("Create");
        this.assertTextPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.grantGroupPermission(17, "jira-developers");
        this.deactivateSubTasks();
    }

    public void subTaskMoveIssueWithSubTask(String issueKey) {
        TestCreateSubTasks.log("Sub Task Move: Move issue with a sub task");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.setFormElement("summary", "Sub Task of Test 5");
        this.submit();
        this.assertTextPresent("Sub Task of Test 5");
        this.assertTextPresent("test for sub tasks");
        this.grantGroupPermission(25, "jira-developers");
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.selectOption("pid", "neanderthal");
        this.submit();
        this.getDialog().setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("New Value (after move)");
        this.submit("Move");
        this.assertTextPresent("test for sub tasks");
        this.gotoIssue(issueKey);
        this.clickLinkWithText("Sub Task of Test 5");
        this.assertTextPresent("neanderthal");
        this.deleteCurrentIssue();
        this.deactivateSubTasks();
    }

    public void subTaskMoveSubTask(String issueKey) {
        String subTaskKey;
        TestCreateSubTasks.log("Sub Task Move; Move a sub task to a different sub task type.");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.setFormElement("summary", "Sub Task of Test 5");
        this.submit();
        this.assertTextPresent("Sub Task of Test 5");
        this.assertTextPresent("test for sub tasks");
        try {
            String text = this.getDialog().getResponse().getText();
            int projectIdLocation = text.indexOf("NDT");
            int endOfIssueKey = text.indexOf("]", projectIdLocation);
            subTaskKey = text.substring(projectIdLocation, endOfIssueKey);
        }
        catch (IOException t) {
            TestCreateSubTasks.fail((String)"Unable to obtain sub-task key");
            return;
        }
        this.removeGroupPermission(25, "jira-developers");
        this.gotoIssue(subTaskKey);
        this.assertLinkNotPresent("move-issue");
        this.grantGroupPermission(25, "jira-developers");
        this.gotoIssue(subTaskKey);
        this.clickLink("move-issue");
        this.selectOption("issuetype", "Custom Sub Task");
        this.getDialog().setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("Step 2 of 3");
        this.getDialog().setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("Step 4 of 4");
        this.submit("Move");
        this.assertTextPresent("Custom Sub Task");
        this.assertTextPresent("Details");
        this.gotoIssue(subTaskKey);
        this.deleteCurrentIssue();
        this.deactivateSubTasks();
    }
}

