/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS, Category.ROLES})
public class TestViewProjectRoleUsage
extends FuncTestCase {
    private static final String TEST_SCHEME_NAME_AAAAA = "AAAAA";
    private static final String TEST_SCHEME_NAME_ZZZZ = "ZZZZ";
    private static final String TEST_SCHEME_NAME_bbb = "bbb";
    private static final String TEST_SCHEME_NAME_yy = "yy";

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestViewProjectRoleUsage.xml");
    }

    public void testSchemeUsageTablesAreOrdered() throws SAXException {
        this.navigation.gotoAdminSection("project_role_browser");
        this.tester.clickLink("view_Administrators");
        WebTable notificationSchemeTable = this.tester.getDialog().getResponse().getTableWithID("relatednotificationschemes");
        this.assertSchemeUsageTableOrdered(notificationSchemeTable);
        WebTable permissionSchemeTable = this.tester.getDialog().getResponse().getTableWithID("relatedpermissionschemes");
        this.assertSchemeUsageTableOrdered(permissionSchemeTable);
        WebTable issueSecuritySchemeTable = this.tester.getDialog().getResponse().getTableWithID("issuesecurityschemes");
        this.assertSchemeUsageTableOrdered(issueSecuritySchemeTable);
    }

    private void assertSchemeUsageTableOrdered(WebTable table) {
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 0, TEST_SCHEME_NAME_AAAAA);
        this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 0, TEST_SCHEME_NAME_bbb);
        this.assertions.getTableAssertions().assertTableCellHasText(table, 3, 0, TEST_SCHEME_NAME_yy);
        this.assertions.getTableAssertions().assertTableCellHasText(table, 4, 0, TEST_SCHEME_NAME_ZZZZ);
    }
}

