/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS})
public class TestViewProject
extends JIRAWebTest {
    public TestViewProject(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
    }

    public void testViewProjectUrlEncoding() {
        this.restoreData("TestViewProject.xml");
        this.setUnsafeUrl("http://<b>hi</b>\">");
        this.assertUrlEncoded();
        this.tester.clickLink("view_projects");
        this.assertUrlEncoded();
        this.tester.gotoPage("secure/BrowseProjects.jspa");
        this.assertUrlEncoded();
        this.tester.gotoPage("browse/HSP");
        this.assertUrlEncoded();
        this.tester.gotoPage("browse/HSP#selectedTab=com.atlassian.jira.plugin.system.project%3Asummary-panel");
        this.assertUrlEncoded();
    }

    private void setUnsafeUrl(String url) {
        this.gotoAdmin();
        this.tester.gotoPage("/plugins/servlet/project-config/HSP/summary");
        this.tester.clickLink("edit_project");
        this.tester.setFormElement("name", "homosapien");
        this.tester.setFormElement("url", url);
        this.tester.submit("Update");
    }

    private void assertUrlEncoded() {
        this.assertTextPresent("http://&lt;b&gt;hi&lt;/b&gt;&quot;&gt;");
    }
}

